/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scanimport.ImagePanel;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewer;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class CardShadow {
    private final CardViewer cardViewer;
    private final int maxHeight;
    private float height = 0.0f;
    private final BufferedImage[] shadowImages;

    public CardShadow(CardViewer viewer, int maxHeight, boolean pregenerate) {
        this.cardViewer = viewer;
        this.maxHeight = maxHeight;
        this.shadowImages = new BufferedImage[maxHeight];
        if (pregenerate) {
            for (int i = 1; i <= maxHeight; ++i) {
                this.getImageForHeight(i);
            }
        }
    }

    public float getHeight() {
        return this.height;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setHeight(float height) {
        this.height = MathUtils.clamp(height, 0.0f, (float)this.maxHeight);
    }

    public void paint(Graphics2D g2, int cardX, int cardY) {
        if (this.height <= 0.0f) {
            return;
        }
        Composite composite = g2.getComposite();
        float alpha = (float)MathUtils.rangeFraction(this.height, this.maxHeight * 2, 0.0);
        int floorHeight = (int)Math.floor(this.height);
        int ceilHeight = (int)Math.ceil(this.height);
        float subFraction = (float)MathUtils.rangeFraction(this.height, floorHeight, ceilHeight);
        Point position = new Point((int)((float)cardX + this.height), (int)((float)cardY + this.height));
        if (floorHeight > 0) {
            g2.setComposite(AlphaComposite.getInstance(3, alpha * (1.0f - subFraction)));
            g2.drawImage((Image)this.getImageForHeight(floorHeight), position.x, position.y, null);
        }
        if (ceilHeight != floorHeight) {
            g2.setComposite(AlphaComposite.getInstance(3, alpha * subFraction));
            g2.drawImage((Image)this.getImageForHeight(ceilHeight), position.x, position.y, null);
        }
        g2.setComposite(composite);
    }

    private BufferedImage getImageForHeight(int height) {
        int cacheIndex = MathUtils.clamp(height, 1, this.maxHeight) - 1;
        if (this.shadowImages[cacheIndex] == null) {
            this.shadowImages[cacheIndex] = this.generateShadow((int)((double)height * 1.4));
        }
        return this.shadowImages[cacheIndex];
    }

    private BufferedImage generateShadow(int radius) {
        ImagePanel imagePanel = this.cardViewer == null ? null : this.cardViewer.getImagePanel();
        Dimension size = imagePanel == null ? PatchworkProject.CARD_DIMENSION : new Dimension(imagePanel.getWidth(), imagePanel.getHeight());
        BufferedImage result = new BufferedImage(size.width + 2 * radius, size.height + 2 * radius, 3);
        Graphics2D g2 = result.createGraphics();
        g2.translate(radius, radius);
        if (imagePanel == null) {
            g2.setComposite(AlphaComposite.SrcOver);
        } else {
            imagePanel.paint(g2);
        }
        g2.setColor(Color.BLACK);
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.fillRect(0, 0, size.width, size.height);
        g2.dispose();
        result = ImageUtils.quickBlur(result, radius, radius, 1);
        return result;
    }
}

