/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridCoords;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridViewerPanel;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.Collection.StringMap;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.xml.SimpleTranscoder;
import com.sodiumarc.patchwork.util.xml.StringMapTranscoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CardSaveData {
    private final String cardGUID;
    private final String sceneLocationGUID;
    private final GridCoords gridCoords;
    private final StringMap stateGUIDMap;
    private final List<String> underCardGUIDs;
    private final List<String> overCardGUIDs;
    private final boolean isInPlay;
    private PatchworkProject project;

    public CardSaveData(GridViewerPanel gridViewer, CardViewer cardViewer) {
        this.cardGUID = cardViewer.getCard().getGUID();
        this.stateGUIDMap = new StringMap();
        Map<SceneLayer, SceneLayerState> layerStates = cardViewer.getCurrentStates();
        for (Map.Entry<SceneLayer, SceneLayerState> entry : layerStates.entrySet()) {
            SceneLayer layer = entry.getKey();
            SceneLayerState state = entry.getValue();
            if (state == null) continue;
            this.stateGUIDMap.put(layer.getGUID(), state.getGUID());
        }
        SceneLocation location = cardViewer.getCurrentLocation();
        this.sceneLocationGUID = location == null ? null : location.getGUID();
        this.gridCoords = gridViewer.getCoords(cardViewer.getCard());
        this.underCardGUIDs = new ArrayList<String>();
        for (CardViewer underCardViewer : cardViewer.getUnderCapturedCards()) {
            this.underCardGUIDs.add(underCardViewer.getCard().getGUID());
        }
        this.overCardGUIDs = new ArrayList<String>();
        for (CardViewer overCardViewer : cardViewer.getOverCapturedCards()) {
            this.overCardGUIDs.add(overCardViewer.getCard().getGUID());
        }
        this.isInPlay = cardViewer.isInPlay();
    }

    public boolean isValid() {
        if (this.project == null) {
            return false;
        }
        return this.project.resolveGUID(this.cardGUID) != null;
    }

    public Card getCard() {
        if (this.project == null) {
            return null;
        }
        return (Card)this.project.resolveGUID(this.cardGUID);
    }

    public SceneLocation getSceneLocation() {
        if (this.project == null) {
            return null;
        }
        return (SceneLocation)this.project.resolveGUID(this.sceneLocationGUID);
    }

    public List<Card> getUnderCards() {
        if (this.project == null) {
            return null;
        }
        ArrayList<Card> result = new ArrayList<Card>();
        for (String cardGUID : this.underCardGUIDs) {
            result.add((Card)this.project.resolveGUID(cardGUID));
        }
        return result;
    }

    public List<Card> getOverCards() {
        if (this.project == null) {
            return null;
        }
        ArrayList<Card> result = new ArrayList<Card>();
        for (String cardGUID : this.overCardGUIDs) {
            result.add((Card)this.project.resolveGUID(cardGUID));
        }
        return result;
    }

    public boolean isInPlay() {
        return this.isInPlay;
    }

    public GridCoords getGridCoords() {
        return this.gridCoords;
    }

    public Map<SceneLayer, SceneLayerState> getLayerStates() {
        HashMap<SceneLayer, SceneLayerState> result = new HashMap<SceneLayer, SceneLayerState>();
        if (this.project != null) {
            for (Map.Entry entry : this.stateGUIDMap.entrySet()) {
                SceneLayer cardlayer = (SceneLayer)this.project.resolveGUID((String)entry.getKey());
                SceneLayerState state = (SceneLayerState)this.project.resolveGUID((String)entry.getValue());
                result.put(cardlayer, state);
            }
        }
        return result;
    }

    protected void setProject(PatchworkProject project) {
        this.project = project;
    }

    private CardSaveData(String cardGUID, StringMap stateGUIDMap, String sceneLocationGUID, GridCoords gridCoords, List<String> underCardGUIDs, List<String> overCardGUIDs, boolean isInPlay) {
        this.cardGUID = cardGUID;
        this.stateGUIDMap = stateGUIDMap;
        this.sceneLocationGUID = sceneLocationGUID;
        this.gridCoords = gridCoords;
        this.underCardGUIDs = underCardGUIDs;
        this.overCardGUIDs = overCardGUIDs;
        this.isInPlay = isInPlay;
    }

    public static class Transcoder
    extends SimpleTranscoder<CardSaveData> {
        private static final String ELEM_NAME = "CardSaveData";
        private static final String ATTR_CARD_GUID = "cardGUID";
        private static final String ATTR_LOCATION_GUID = "locationGUID";
        private static final String ATTR_GRID_COORDS = "gridCoords";
        private static final String ATTR_UNDER_CARD_GUIDS = "underCardGUIDs";
        private static final String ATTR_OVER_CARD_GUIDS = "overCardGUIDs";
        private static final String FIELD_STATE_GUID_MAP = "stateGUIDMap";
        private static final String FIELD_IS_IN_PLAY = "isInPlay";

        protected Transcoder() {
            super(ELEM_NAME, CardSaveData.class);
            this.setFieldTranscoder(FIELD_STATE_GUID_MAP, new StringMapTranscoder("StringMap"));
        }

        @Override
        protected void getAttributes(CardSaveData object, Map<String, String> destination) {
            destination.put(ATTR_CARD_GUID, object.cardGUID);
            destination.put(ATTR_LOCATION_GUID, object.sceneLocationGUID);
            destination.put(FIELD_IS_IN_PLAY, Boolean.toString(object.isInPlay));
            if (object.gridCoords != null) {
                destination.put(ATTR_GRID_COORDS, object.gridCoords.encode());
            }
            if (!object.underCardGUIDs.isEmpty()) {
                destination.put(ATTR_UNDER_CARD_GUIDS, StringUtils.toDelimitedList(object.underCardGUIDs, "|"));
            }
            if (!object.overCardGUIDs.isEmpty()) {
                destination.put(ATTR_OVER_CARD_GUIDS, StringUtils.toDelimitedList(object.overCardGUIDs, "|"));
            }
        }

        @Override
        protected void getChildren(CardSaveData object, MultiMap<String, Object> destination) {
            destination.putLast(FIELD_STATE_GUID_MAP, object.stateGUIDMap);
        }

        @Override
        protected CardSaveData decode(Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            StringMap stateGUIDMap = (StringMap)decodedChildren.getFirst(FIELD_STATE_GUID_MAP);
            String cardGUID = attributes.get(ATTR_CARD_GUID);
            String locationGUID = attributes.get(ATTR_LOCATION_GUID);
            GridCoords gridCoords = null;
            if (attributes.containsKey(ATTR_GRID_COORDS)) {
                gridCoords = new GridCoords(attributes.get(ATTR_GRID_COORDS));
            }
            List underCardGUIDs = Collections.emptyList();
            if (attributes.containsKey(ATTR_UNDER_CARD_GUIDS)) {
                underCardGUIDs = (List)StringUtils.split(attributes.get(ATTR_UNDER_CARD_GUIDS), "\\|", false, new ArrayList<String>());
            }
            List overCardGUIDs = Collections.emptyList();
            if (attributes.containsKey(ATTR_OVER_CARD_GUIDS)) {
                overCardGUIDs = (List)StringUtils.split(attributes.get(ATTR_OVER_CARD_GUIDS), "\\|", false, new ArrayList<String>());
            }
            boolean isInPlay = false;
            if (attributes.containsKey(FIELD_IS_IN_PLAY)) {
                isInPlay = Boolean.valueOf(attributes.get(FIELD_IS_IN_PLAY));
            }
            CardSaveData result = new CardSaveData(cardGUID, stateGUIDMap, locationGUID, gridCoords, underCardGUIDs, overCardGUIDs, isInPlay);
            return result;
        }
    }
}

