/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scenecomposer.model.GridDirection;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.ProgressRectanglePainter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.EnumSet;
import java.util.Set;

public class CardBorder {
    private boolean showSelection = true;
    private final ProgressRectanglePainter progressPainter;
    private final Dimension size;
    private boolean selected;
    private final Set<GridDirection> linkedDirs;
    private float percentComplete = 100.0f;
    private static final int BORDER_WIDTH = 7;
    private static final Color SELECTED_COLOR = new Color(225, 245, 255);
    private static final Color OUTLINE_COLOR = Color.GRAY;

    public CardBorder(Dimension size) {
        this.size = size;
        this.linkedDirs = EnumSet.noneOf(GridDirection.class);
        this.progressPainter = new ProgressRectanglePainter();
        this.progressPainter.setPercentComplete(100.0f);
        this.progressPainter.setOutlineColor(OUTLINE_COLOR);
    }

    public void clearLinkedDirs() {
        this.linkedDirs.clear();
    }

    public void addLinkedDir(GridDirection dir) {
        this.linkedDirs.add(dir);
    }

    public void removeLinkedDir(GridDirection dir) {
        this.linkedDirs.remove((Object)dir);
    }

    public Set<GridDirection> getLinkedDirs() {
        return this.linkedDirs;
    }

    public void setShowSelection(boolean showSelection) {
        this.showSelection = showSelection;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setPercentComplete(float percentComplete) {
        this.percentComplete = (float)Math.ceil(percentComplete);
        this.progressPainter.setPercentComplete(percentComplete);
    }

    public void paint(Graphics2D graphics, Point location) {
        graphics.setComposite(AlphaComposite.SrcOver);
        if (this.percentComplete >= 100.0f) {
            this.paintCompleteBorder(graphics, new Rectangle(location.x, location.y, this.size.width, this.size.height));
        } else {
            this.progressPainter.setControlRectangle(new Rectangle(location.x, location.y, this.size.width - 1, this.size.height - 1));
            this.progressPainter.setFillColor(this.selected ? SELECTED_COLOR : Color.WHITE);
            int borderWidth = 7;
            int north = this.linkedDirs.contains((Object)GridDirection.NORTH) ? 0 : borderWidth;
            int south = this.linkedDirs.contains((Object)GridDirection.SOUTH) ? 0 : borderWidth;
            int west = this.linkedDirs.contains((Object)GridDirection.WEST) ? 0 : borderWidth;
            int east = this.linkedDirs.contains((Object)GridDirection.EAST) ? 0 : borderWidth;
            this.progressPainter.setInsets(new Insets(north, west, south, east));
            this.progressPainter.paint(graphics);
        }
    }

    private void paintCompleteBorder(Graphics2D graphics, Rectangle exteriorRect) {
        Rectangle cornerRect;
        Color fillColor = this.selected && this.showSelection ? SELECTED_COLOR : Color.WHITE;
        int xMinOut = exteriorRect.x;
        int xMaxOut = xMinOut + exteriorRect.width - 1;
        int yMinOut = exteriorRect.y;
        int yMaxOut = yMinOut + exteriorRect.height - 1;
        graphics.setColor(fillColor);
        if (!this.linkedDirs.contains((Object)GridDirection.NORTH)) {
            graphics.fillRect(xMinOut, yMinOut, exteriorRect.width, 7);
        }
        if (!this.linkedDirs.contains((Object)GridDirection.SOUTH)) {
            graphics.fillRect(xMinOut, yMaxOut - 7, exteriorRect.width, 7);
        }
        if (!this.linkedDirs.contains((Object)GridDirection.EAST)) {
            graphics.fillRect(xMaxOut - 7, yMinOut, 7, exteriorRect.height);
        }
        if (!this.linkedDirs.contains((Object)GridDirection.WEST)) {
            graphics.fillRect(xMinOut, yMinOut, 7, exteriorRect.height);
        }
        graphics.setColor(OUTLINE_COLOR);
        if (!this.linkedDirs.contains((Object)GridDirection.NORTH)) {
            graphics.drawLine(xMinOut, yMinOut, xMaxOut, yMinOut);
        }
        if (!this.linkedDirs.contains((Object)GridDirection.SOUTH)) {
            graphics.drawLine(xMinOut, yMaxOut, xMaxOut, yMaxOut);
        }
        if (!this.linkedDirs.contains((Object)GridDirection.EAST)) {
            graphics.drawLine(xMaxOut, yMinOut, xMaxOut, yMaxOut);
        }
        if (!this.linkedDirs.contains((Object)GridDirection.WEST)) {
            graphics.drawLine(xMinOut, yMinOut, xMinOut, yMaxOut);
        }
        int xMinIn = xMinOut;
        int yMinIn = yMinOut;
        int xMaxIn = xMaxOut;
        int yMaxIn = yMaxOut;
        if (!this.linkedDirs.contains((Object)GridDirection.NORTH)) {
            yMinIn += 7;
        }
        if (!this.linkedDirs.contains((Object)GridDirection.SOUTH)) {
            yMaxIn -= 7;
        }
        if (!this.linkedDirs.contains((Object)GridDirection.EAST)) {
            xMaxIn -= 7;
        }
        if (!this.linkedDirs.contains((Object)GridDirection.WEST)) {
            xMinIn += 7;
        }
        graphics.drawRect(xMinIn, yMinIn, xMaxIn - xMinIn, yMaxIn - yMinIn);
        graphics.setColor(fillColor);
        if (this.linkedDirs.contains((Object)GridDirection.NORTH)) {
            if (this.linkedDirs.contains((Object)GridDirection.EAST)) {
                cornerRect = new Rectangle(xMaxOut - 6, yMinOut, 7, 7);
                graphics.fillRect(cornerRect.x, cornerRect.y, cornerRect.width, cornerRect.height);
                graphics.setColor(OUTLINE_COLOR);
                graphics.drawLine(xMaxOut, yMinOut, xMaxOut, yMinOut);
                graphics.drawLine(cornerRect.x, cornerRect.y + cornerRect.height, cornerRect.x + cornerRect.width, cornerRect.y + cornerRect.height);
                graphics.drawLine(cornerRect.x, cornerRect.y, cornerRect.x, cornerRect.y + cornerRect.height);
            } else if (this.linkedDirs.contains((Object)GridDirection.WEST)) {
                cornerRect = new Rectangle(xMinOut, yMinOut, 7, 7);
                graphics.fillRect(cornerRect.x, cornerRect.y, cornerRect.width, cornerRect.height);
                graphics.setColor(OUTLINE_COLOR);
                graphics.drawLine(xMinOut, yMinOut, xMinOut, yMinOut);
                graphics.drawLine(cornerRect.x, cornerRect.y + cornerRect.height, cornerRect.x + cornerRect.width, cornerRect.y + cornerRect.height);
                graphics.drawLine(cornerRect.x + cornerRect.width, cornerRect.y, cornerRect.x + cornerRect.width, cornerRect.y + cornerRect.height);
            }
        }
        if (this.linkedDirs.contains((Object)GridDirection.SOUTH)) {
            if (this.linkedDirs.contains((Object)GridDirection.EAST)) {
                cornerRect = new Rectangle(xMaxOut - 6, yMaxOut - 6, 7, 7);
                graphics.fillRect(cornerRect.x, cornerRect.y, cornerRect.width, cornerRect.height);
                graphics.setColor(OUTLINE_COLOR);
                graphics.drawLine(xMaxOut, yMaxOut, xMaxOut, yMaxOut);
                graphics.drawLine(cornerRect.x, cornerRect.y, cornerRect.x + cornerRect.width, cornerRect.y);
                graphics.drawLine(cornerRect.x, cornerRect.y, cornerRect.x, cornerRect.y + cornerRect.height);
            } else if (this.linkedDirs.contains((Object)GridDirection.WEST)) {
                cornerRect = new Rectangle(xMinOut, yMaxOut - 7, 7, 8);
                graphics.fillRect(cornerRect.x, cornerRect.y, cornerRect.width, cornerRect.height);
                graphics.setColor(OUTLINE_COLOR);
                graphics.drawLine(xMinOut, yMaxOut, xMinOut, yMaxOut);
                graphics.drawLine(cornerRect.x, cornerRect.y, cornerRect.x + cornerRect.width, cornerRect.y);
                graphics.drawLine(cornerRect.x + cornerRect.width, cornerRect.y, cornerRect.x + cornerRect.width, cornerRect.y + cornerRect.height);
            }
        }
    }
}

