/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import java.util.Map;

public class BooleanFormulaParser {
    public boolean evaluate(String expression, Map<String, Boolean> varValues) {
        if (expression == null) {
            return false;
        }
        Operator operator = this.getLeadingOperator(expression = expression.trim());
        if (operator != null) {
            expression = expression.substring(1).trim();
            if (operator == Operator.NOT) {
                return !this.evaluate(expression, varValues);
            }
        }
        boolean firstTermValue = true;
        String term = this.getLeadingTerm(expression);
        if (term != null) {
            expression = expression.substring(term.length()).trim();
            firstTermValue = this.evaluateTerm(term, varValues);
        }
        if ((operator = this.getLeadingOperator(expression)) == Operator.AND) {
            return firstTermValue && this.evaluate(expression.substring(1).trim(), varValues);
        }
        if (operator == Operator.OR) {
            return firstTermValue || this.evaluate(expression.substring(1).trim(), varValues);
        }
        return firstTermValue;
    }

    private String getLeadingTerm(String expression) {
        int endIndex;
        expression = expression.trim();
        for (endIndex = 0; endIndex < expression.length() && !Character.isWhitespace(expression.charAt(endIndex)) && !this.isSpecialCharacter(expression.charAt(endIndex)); ++endIndex) {
        }
        if (endIndex == 0 && expression.charAt(0) == '(') {
            int parenDepth = 1;
            for (endIndex = 1; parenDepth > 0 && endIndex < expression.length(); ++endIndex) {
                char c = expression.charAt(endIndex);
                if (c == '(') {
                    ++parenDepth;
                    continue;
                }
                if (c != ')') continue;
                --parenDepth;
            }
        }
        if (endIndex >= 0) {
            return expression.substring(0, endIndex);
        }
        return null;
    }

    private boolean evaluateTerm(String term, Map<String, Boolean> varValues) {
        if ((term = term.trim()).isEmpty()) {
            return false;
        }
        if (term.charAt(0) == '(') {
            if ((term = term.substring(1)).endsWith(")")) {
                term = term.substring(0, term.length() - 1);
            }
            return this.evaluate(term, varValues);
        }
        if (varValues.containsKey(term)) {
            return varValues.get(term);
        }
        return false;
    }

    private Operator getLeadingOperator(String expression) {
        if (expression.isEmpty()) {
            return null;
        }
        expression = expression.trim();
        for (Operator operator : Operator.values()) {
            if (expression.charAt(0) != operator.getChar()) continue;
            return operator;
        }
        return null;
    }

    private boolean isSpecialCharacter(char c) {
        if (c == '(' || c == ')') {
            return true;
        }
        for (Operator operator : Operator.values()) {
            if (c != operator.getChar()) continue;
            return true;
        }
        return false;
    }

    public static enum Operator {
        AND('&'),
        OR('|'),
        NOT('!');

        private final char c;

        public char getChar() {
            return this.c;
        }

        private Operator(char c) {
            this.c = c;
        }
    }
}

