/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.animation.Animation;
import com.sodiumarc.patchwork.animation.AnimationListener;
import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.UnitlessDragSensor;
import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.GeometricAxis;
import com.sodiumarc.patchwork.util.MathUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AnimationControls
extends JPanel {
    private final JButton playPauseButton;
    private final JButton toStartButton;
    private final JButton toEndButton;
    private final JSlider animationSlider;
    private final JSpinner timeSpinner;
    private final JLabel timeLabel;
    private final UnitlessDragSensor animationSensor;
    private final ChangeListener sliderListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            AnimationControls.this.sliderIsChanging = true;
            AnimationControls.this.targetAnimation.setElapsedFraction((float)AnimationControls.this.animationSlider.getValue() / 100.0f);
            AnimationControls.this.sliderIsChanging = false;
        }
    };
    private final ChangeListener spinnerListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            Double elapsedSeconds = (Double)AnimationControls.this.timeSpinner.getValue();
            double elapsedMillis = elapsedSeconds * 1000.0;
            AnimationControls.this.targetAnimation.setElapsedFraction((float)(elapsedMillis / (double)AnimationControls.this.targetAnimation.getDurationInMillis()));
        }
    };
    private final AnimationListener animationListener = new AnimationListener(){

        @Override
        public void elapsedFractionChanged(Animation source, float elapsedFraction) {
            long thisFrameTime = System.currentTimeMillis();
            AnimationControls.this.fps = AnimationControls.this.lastFrameTime < 0L ? -1.0f : 1000.0f / (float)(thisFrameTime - AnimationControls.this.lastFrameTime);
            AnimationControls.this.lastFrameTime = thisFrameTime;
            AnimationControls.this.updateSlider();
            AnimationControls.this.updateEnabling();
            AnimationControls.this.updateTimeLabel();
            AnimationControls.this.elapsedFractionChanged(source, elapsedFraction);
        }

        @Override
        public void animationStopped(Animation source) {
            AnimationControls.this.lastFrameTime = -1L;
            AnimationControls.this.fps = -1.0f;
            AnimationControls.this.updateEnabling();
            AnimationControls.this.updateTimeLabel();
            AnimationControls.this.animationStopped(source);
        }

        @Override
        public void animationStarted(Animation source) {
            AnimationControls.this.updateEnabling();
            AnimationControls.this.updateTimeLabel();
            AnimationControls.this.animationStarted(source);
        }
    };
    private Animation targetAnimation;
    private boolean sliderIsChanging = false;
    private long lastFrameTime = -1L;
    private float fps = -1.0f;
    private static final Icon TO_START_ICON = IconLoader.loadIcon("openiconlibrary/media-skip-backward-7.png");
    private static final Icon TO_END_ICON = IconLoader.loadIcon("openiconlibrary/media-skip-forward-7.png");
    private static final Icon PLAY_ICON = IconLoader.loadIcon("openiconlibrary/media-playback-start-7.png");
    private static final Icon PAUSE_ICON = IconLoader.loadIcon("openiconlibrary/media-playback-pause-7.png");
    private static final DecimalFormat SECONDS_FORMAT = new DecimalFormat("00.0");
    private static final DecimalFormat FPS_FORMAT = new DecimalFormat("00.0");

    public AnimationControls() {
        super(new BorderLayout(5, 5));
        Filter<MouseEvent> eventFilter = new Filter<MouseEvent>(){

            @Override
            public boolean accept(MouseEvent event) {
                int onmask = 4160;
                int offmask = 128;
                return (event.getModifiersEx() & (onmask | offmask)) == onmask;
            }
        };
        this.animationSensor = new UnitlessDragSensor(this, eventFilter){

            @Override
            protected void update(float localDeltaX, float localDeltaY, float cumulativeDeltaX, float cumulativeDeltaY) {
                AnimationControls.this.targetAnimation.setElapsedFraction(MathUtils.clamp(AnimationControls.this.targetAnimation.getElapsedFraction() + localDeltaY, 0.0f, 1.0f));
            }
        };
        this.animationSensor.setInputScaleY(-0.01f);
        this.animationSensor.setInputScaleX(0.0f);
        this.animationSensor.setMouseWheelAxis(GeometricAxis.Y);
        this.animationSensor.setMouseWheelScale(-0.02f);
        this.toStartButton = this.makeControlButton(TO_START_ICON);
        this.toStartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimationControls.this.targetAnimation.setElapsedFraction(0.0f);
            }
        });
        this.toEndButton = this.makeControlButton(TO_END_ICON);
        this.toEndButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimationControls.this.targetAnimation.setElapsedFraction(1.0f);
            }
        });
        this.playPauseButton = this.makeControlButton(PLAY_ICON);
        this.playPauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnimationControls.this.targetAnimation.isRunning()) {
                    AnimationControls.this.targetAnimation.stop();
                } else {
                    AnimationControls.this.targetAnimation.start();
                }
            }
        });
        this.animationSlider = new JSlider(0, 100, 0);
        this.animationSlider.addChangeListener(this.sliderListener);
        this.timeSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 0.05));
        ((JSpinner.DefaultEditor)this.timeSpinner.getEditor()).getTextField().setColumns(4);
        this.timeLabel = new JLabel();
        Font labelFont = this.timeLabel.getFont();
        Font infoFont = new Font(labelFont.getName(), 0, labelFont.getSize());
        this.timeLabel.setFont(infoFont);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3));
        buttonPanel.add(this.toStartButton);
        buttonPanel.add(this.playPauseButton);
        buttonPanel.add(this.toEndButton);
        this.add((Component)buttonPanel, "West");
        this.add((Component)this.animationSlider, "Center");
        JPanel timePanel = new JPanel(new FlowLayout());
        timePanel.add((Component)this.timeSpinner, "Center");
        timePanel.add((Component)this.timeLabel, "East");
        this.add((Component)timePanel, "East");
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.updateEnabling();
        this.updateTimeLabel();
    }

    public void setAnimation(Animation animation, boolean fromBeginning) {
        if (this.targetAnimation != null) {
            this.targetAnimation.removeListener(this.animationListener);
        }
        this.targetAnimation = animation;
        if (this.targetAnimation != null) {
            this.targetAnimation.addListener(this.animationListener);
            if (fromBeginning) {
                this.targetAnimation.setElapsedFraction(0.0f);
            }
        }
        this.animationSensor.reset();
        this.updateSlider();
        this.updateEnabling();
        this.updateTimeLabel();
    }

    public void startAnimation(boolean fromBeginning) {
        if (this.targetAnimation != null && !this.targetAnimation.isRunning()) {
            if (fromBeginning) {
                this.targetAnimation.setElapsedFraction(0.0f);
            }
            this.targetAnimation.start();
        }
    }

    protected void elapsedFractionChanged(Animation source, float elapsedFraction) {
    }

    protected void animationStopped(Animation source) {
    }

    protected void animationStarted(Animation source) {
    }

    private void updateEnabling() {
        this.playPauseButton.setEnabled(this.targetAnimation != null);
        this.playPauseButton.setIcon(this.targetAnimation != null && this.targetAnimation.isRunning() ? PAUSE_ICON : PLAY_ICON);
        this.timeLabel.setEnabled(this.targetAnimation != null);
        boolean staticControlsEnabled = this.targetAnimation != null && !this.targetAnimation.isRunning();
        this.toStartButton.setEnabled(staticControlsEnabled && this.targetAnimation.getElapsedFraction() != 0.0f);
        this.toEndButton.setEnabled(staticControlsEnabled && this.targetAnimation.getElapsedFraction() != 1.0f);
        this.animationSlider.setEnabled(staticControlsEnabled);
        this.animationSensor.setEnabled(staticControlsEnabled);
    }

    private void updateSlider() {
        if (this.sliderIsChanging) {
            return;
        }
        this.animationSlider.removeChangeListener(this.sliderListener);
        if (this.targetAnimation != null) {
            this.animationSlider.setValue((int)MathUtils.clamp(this.targetAnimation.getElapsedFraction() * 100.0f, 0.0f, 100.0f));
        }
        this.animationSlider.addChangeListener(this.sliderListener);
    }

    private void updateTimeLabel() {
        float elapsedSeconds = 0.0f;
        float totalSeconds = 0.0f;
        if (this.targetAnimation != null) {
            totalSeconds = (float)this.targetAnimation.getDurationInMillis() / 1000.0f;
            elapsedSeconds = this.targetAnimation.getElapsedFraction() * totalSeconds;
        }
        this.timeSpinner.removeChangeListener(this.spinnerListener);
        this.timeSpinner.setValue(elapsedSeconds);
        this.timeSpinner.addChangeListener(this.spinnerListener);
        this.timeLabel.setText(String.format("/ %ss %s fps", SECONDS_FORMAT.format(totalSeconds), FPS_FORMAT.format(MathUtils.clamp(this.fps, 0.0f, 99.0f))));
    }

    private JButton makeControlButton(Icon icon) {
        JButton result = new JButton(null, icon);
        result.setPreferredSize(new Dimension(40, 30));
        return result;
    }
}

