/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.tree;

import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ProjectComponentTreeModel
implements TreeModel {
    private final ProjectComponentListener listener = new ProjectComponentListener(){

        @Override
        public void childComponentRemoved(List<ProjectComponent> parentPath, ProjectComponent child, int index) {
            ProjectComponentTreeModel.this.fireChildRemoved(parentPath, child, index);
        }

        @Override
        public void childComponentAdded(List<ProjectComponent> parentPath, ProjectComponent child, int index) {
            ProjectComponentTreeModel.this.fireChildInserted(parentPath, child, index);
        }

        @Override
        public void modified(List<ProjectComponent> modifiedPath) {
        }
    };
    private final List<ProjectComponent> rootComponents;
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private final Object metaroot = "ROOT";

    public ProjectComponentTreeModel() {
        this.rootComponents = new ArrayList<ProjectComponent>();
    }

    public List<ProjectComponent> getRootComponents() {
        return this.rootComponents;
    }

    public void setRoots(Collection<? extends ProjectComponent> newRoots) {
        for (ProjectComponent projectComponent : new ArrayList<ProjectComponent>(this.rootComponents)) {
            if (newRoots.contains(projectComponent)) continue;
            this.removeRoot(projectComponent);
        }
        for (ProjectComponent projectComponent : newRoots) {
            this.addRoot(projectComponent);
        }
    }

    public void addRoot(ProjectComponent root) {
        int index = this.getIndexOfChild(this.metaroot, root);
        if (index < 0) {
            this.rootComponents.add(root);
            root.addListener(this.listener);
            this.fireChildInserted(this.metaroot, root);
        }
    }

    public void removeRoot(ProjectComponent root) {
        int index = this.getIndexOfChild(this.metaroot, root);
        if (index >= 0) {
            this.rootComponents.add(root);
            root.removeListener(this.listener);
            this.fireChildRemoved(index, this.metaroot, root);
        }
    }

    public void updatePathDisplay(Object ... path) {
        this.fireNodeChanged(path);
    }

    @Override
    public Object getRoot() {
        return this.metaroot;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this.getChildList(parent).get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return this.getChildList(parent).size();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.getChildList(parent).indexOf(child);
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildList(node).isEmpty();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    private List<ProjectComponent> getChildList(Object node) {
        ArrayList<ProjectComponent> children = new ArrayList<ProjectComponent>();
        if (node == this.metaroot) {
            children.addAll(this.rootComponents);
        } else if (node instanceof ProjectComponent) {
            children.addAll(((ProjectComponent)node).getTreeChildComponents());
        }
        return children;
    }

    private void fireNodeChanged(Object ... path) {
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this.metaroot});
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesChanged(event);
        }
    }

    private void fireTreeStructureChanged() {
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this.metaroot});
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(event);
        }
    }

    private void fireChildInserted(Object ... path) {
        int index = this.getIndexOfChild(path[path.length - 2], path[path.length - 1]);
        Object[] parentPath = new Object[path.length - 1];
        for (int i = 0; i < parentPath.length; ++i) {
            parentPath[i] = path[i];
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, parentPath, new int[]{index}, new Object[]{path[path.length - 1]});
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesInserted(event);
        }
    }

    private void fireChildRemoved(int index, Object ... path) {
        Object[] parentPath = new Object[path.length - 1];
        for (int i = 0; i < parentPath.length; ++i) {
            parentPath[i] = path[i];
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, parentPath, new int[]{index}, new Object[]{path[path.length - 1]});
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesInserted(event);
        }
    }

    private void fireChildInserted(List<ProjectComponent> parentPath, ProjectComponent child, int index) {
        ArrayList<Object> fullPath = new ArrayList<Object>(parentPath.size() + 1);
        fullPath.add(this.metaroot);
        fullPath.addAll(parentPath);
        Object[] treePath = fullPath.toArray(new Object[0]);
        TreeModelEvent event = new TreeModelEvent((Object)this, treePath, new int[]{index}, new Object[]{child});
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesInserted(event);
        }
    }

    private void fireChildRemoved(List<ProjectComponent> parentPath, ProjectComponent child, int index) {
        ArrayList<Object> fullPath = new ArrayList<Object>(parentPath.size() + 1);
        fullPath.add(this.metaroot);
        fullPath.addAll(parentPath);
        Object[] treePath = fullPath.toArray(new Object[0]);
        TreeModelEvent event = new TreeModelEvent((Object)this, treePath, new int[]{index}, new Object[]{child});
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesRemoved(event);
        }
    }
}

