/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.tree;

import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.InterpolatedViewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.Viewpoint;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ProjectComponentTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Set<Class<?>> enabledTypes;
    private float alpha;

    public void setEnabledTypes(Set<Class<?>> enabledTypes) {
        this.enabledTypes = enabledTypes;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.alpha = 1.0f;
        if (component instanceof JLabel) {
            boolean enabled = false;
            JLabel label = (JLabel)component;
            if (value instanceof ProjectComponent) {
                ProjectComponent pc = (ProjectComponent)value;
                enabled = this.isValidSelection(pc);
                String text = pc.getDisplayName(true);
                label.setIcon(pc.getIcon());
                if (pc instanceof SceneLocation) {
                    SceneLocation loc = (SceneLocation)pc;
                    Viewpoint viewpoint = loc.getViewpoint();
                    float f = this.alpha = viewpoint instanceof InterpolatedViewpoint ? 0.5f : 1.0f;
                    if (!loc.getTransitions().isEmpty()) {
                        text = String.format("<html><b>%s</b></html>", text);
                    }
                }
                label.setText(text);
            }
            label.setEnabled(enabled);
            label.setSize(label.getPreferredSize());
        }
        return component;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
        super.paint(g2);
        g2.dispose();
    }

    private boolean isValidSelection(ProjectComponent selection) {
        if (this.enabledTypes == null) {
            return true;
        }
        for (Class<?> type : this.enabledTypes) {
            if (!type.isAssignableFrom(selection.getClass())) continue;
            return true;
        }
        return false;
    }
}

