/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.tree;

import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentTransferHandler;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.tree.ProjectComponentTreeCellRenderer;
import com.sodiumarc.patchwork.app.scenecomposer.tree.ProjectComponentTreeModel;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class ProjectComponentTree
extends JTree {
    private final ProjectComponentTransferHandler transferHandler = new ProjectComponentTransferHandler(){

        @Override
        protected boolean canDragSelected(JComponent c) {
            Set<ProjectComponent> selection = ProjectComponentTree.this.getSelection();
            if (selection.isEmpty()) {
                return false;
            }
            return ProjectComponentTree.this.canDrag(ProjectComponentTree.this.getSelection());
        }

        @Override
        protected Set<ProjectComponent> getExportComponents(JComponent c) {
            return ProjectComponentTree.this.getSelection();
        }

        @Override
        protected void exportDone(Set<String> guids, int action) {
        }

        @Override
        protected boolean canImportComponents(TransferHandler.DropLocation dropLocation, Set<String> guids) {
            JTree.DropLocation dl = (JTree.DropLocation)dropLocation;
            TreePath path = dl.getPath();
            int childIndex = dl.getChildIndex();
            ProjectComponent parent = (ProjectComponent)path.getLastPathComponent();
            return ProjectComponentTree.this.canDropChildComponents(parent, this.resolve(parent, guids), childIndex);
        }

        @Override
        protected void importComponents(TransferHandler.DropLocation dropLocation, Set<String> guids) {
            JTree.DropLocation dl = (JTree.DropLocation)dropLocation;
            TreePath path = dl.getPath();
            int childIndex = dl.getChildIndex();
            ProjectComponent parent = (ProjectComponent)path.getLastPathComponent();
            ProjectComponentTree.this.dropChildComponents(parent, this.resolve(parent, guids), childIndex);
        }
    };
    private ProjectComponentTreeModel componentTreeModel;
    private ProjectComponentTreeCellRenderer cellRenderer = new ProjectComponentTreeCellRenderer();

    public ProjectComponentTree(boolean enableDrag) {
        this.setCellRenderer(this.cellRenderer);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setRowHeight(20);
        this.setToggleClickCount(0);
        this.componentTreeModel = new ProjectComponentTreeModel();
        this.setModel(this.componentTreeModel);
        if (enableDrag) {
            this.setDragEnabled(true);
            this.setDropMode(DropMode.ON_OR_INSERT);
            this.setTransferHandler(this.transferHandler);
        }
        this.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ProjectComponentTree.this.onSelectionChanged(ProjectComponentTree.this.getSelection());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                if (e.getClickCount() == 2 && (path = ProjectComponentTree.this.getPathForLocation(e.getX(), e.getY())) != null) {
                    ProjectComponentTree.this.onDoubleClick(path.getLastPathComponent());
                }
            }
        });
    }

    public void setEnabledTypes(Set<Class<?>> enabledTypes) {
        this.cellRenderer.setEnabledTypes(enabledTypes);
    }

    public void setRoots(Collection<? extends ProjectComponent> newRoots) {
        this.componentTreeModel.setRoots(newRoots);
        this.expandPath(new TreePath(new Object[]{this.componentTreeModel.getRoot()}));
    }

    public void updateSelectionDisplay() {
        TreePath[] selections = this.getSelectionModel().getSelectionPaths();
        if (selections != null) {
            for (TreePath path : selections) {
                this.componentTreeModel.updatePathDisplay(path.getPath());
            }
        }
        this.repaint();
    }

    public ProjectComponentTreeModel getTreeModel() {
        return this.componentTreeModel;
    }

    public Set<ProjectComponent> getSelection() {
        HashSet<ProjectComponent> result = new HashSet<ProjectComponent>();
        TreePath[] selections = this.getSelectionModel().getSelectionPaths();
        if (selections != null) {
            for (TreePath path : selections) {
                if (path.getPathCount() <= 1) continue;
                result.add((ProjectComponent)path.getLastPathComponent());
            }
        }
        return result;
    }

    public ProjectComponent getSingleSelection() {
        Set<ProjectComponent> selection = this.getSelection();
        if (selection.size() == 1) {
            return CollectionUtils.first(selection);
        }
        return null;
    }

    public <T extends ProjectComponent> Set<T> getSelectionByType(Class<T> type, boolean includeAncestors) {
        HashSet<T> result = new HashSet<T>();
        TreePath[] selections = this.getSelectionModel().getSelectionPaths();
        if (selections != null) {
            block0: for (TreePath path : selections) {
                for (int i = path.getPathCount() - 1; i >= 0; --i) {
                    Object pathObj = path.getPathComponent(i);
                    if (type.isAssignableFrom(pathObj.getClass())) {
                        result.add(type.cast(pathObj));
                    }
                    if (!includeAncestors) continue block0;
                }
            }
        }
        return result;
    }

    public <T extends ProjectComponent> T getSingleSelectionByType(Class<T> type, boolean includeAncestors) {
        Set<T> selection = this.getSelectionByType(type, includeAncestors);
        if (selection.size() == 1) {
            return (T)((ProjectComponent)CollectionUtils.first(selection));
        }
        return null;
    }

    public void setSingleSelection(ProjectComponent component) {
        this.getSelectionModel().setSelectionPath(this.toTreePath(component.getPath()));
    }

    public void expandPath(ProjectComponent component) {
        this.expandPath(this.toTreePath(component.getPath()));
    }

    protected void onSelectionChanged(Set<ProjectComponent> selection) {
    }

    protected void onDoubleClick(Object lastPathComponent) {
    }

    protected boolean canDrag(Set<ProjectComponent> selection) {
        return true;
    }

    protected void dropChildComponents(ProjectComponent parent, Set<ProjectComponent> children, int insertIndex) {
    }

    protected boolean canDropChildComponents(ProjectComponent parent, Set<ProjectComponent> children, int insertIndex) {
        return false;
    }

    private TreePath toTreePath(List<ProjectComponent> path) {
        ArrayList<Object> fullPath = new ArrayList<Object>();
        fullPath.add(this.componentTreeModel.getRoot());
        ArrayList<ProjectComponent> componentPath = new ArrayList<ProjectComponent>(path);
        List<ProjectComponent> componentRoots = this.componentTreeModel.getRootComponents();
        while (!componentPath.isEmpty() && !componentRoots.contains(componentPath.get(0))) {
            componentPath.remove(0);
        }
        fullPath.addAll(componentPath);
        return new TreePath(fullPath.toArray());
    }
}

