/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.table;

import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.Predicate;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.StateTransition;
import com.sodiumarc.patchwork.app.scenecomposer.table.ProjectComponentTable;
import java.util.EnumSet;
import java.util.List;

public class StateTransitionTable
extends ProjectComponentTable<SceneLayer> {
    public StateTransitionTable() {
        super("Transitions", EnumSet.of(ProjectComponentTable.ButtonColumn.Del, ProjectComponentTable.ButtonColumn.Edit, ProjectComponentTable.ButtonColumn.Add), "State / Transition", false);
    }

    @Override
    protected void getRows(SceneLayer target, List<ProjectComponent> tableRows) {
        if (target != null) {
            for (SceneLayerState state : target.getStates(true)) {
                tableRows.add(state);
                for (StateTransition transition : state.getTransitions()) {
                    tableRows.add(transition);
                    for (Predicate predicate : transition.getPredicates()) {
                        tableRows.add(predicate);
                    }
                }
            }
        }
    }

    @Override
    protected int getIndent(int row, List<ProjectComponent> tableRows) {
        ProjectComponent component = tableRows.get(row);
        if (component instanceof SceneLayerState) {
            return 0;
        }
        if (component instanceof StateTransition) {
            return 20;
        }
        return 40;
    }

    @Override
    protected boolean isSectionHeaderRow(int row, List<ProjectComponent> tableRows) {
        ProjectComponent component = tableRows.get(row);
        return component instanceof SceneLayerState;
    }

    @Override
    protected void removeRow(int row, List<ProjectComponent> tableRows) {
        ProjectComponent component = tableRows.get(row);
        component.getParentComponent().removeChildComponent(component);
    }

    @Override
    protected void addAtRow(int row, List<ProjectComponent> tableRows) {
        ProjectComponent projectComponent = tableRows.get(row);
        if (projectComponent instanceof SceneLayerState) {
            ((SceneLayerState)projectComponent).addChildComponent("transition", StateTransition.class);
        } else if (projectComponent instanceof StateTransition) {
            ((StateTransition)projectComponent).addChildComponent("predicate", Predicate.class);
        }
    }

    @Override
    protected boolean isRowEditable(int row, List<ProjectComponent> tableRows) {
        return true;
    }

    @Override
    protected boolean isRowRemovable(int row, List<ProjectComponent> tableRows) {
        return this.isRowEditable(row, tableRows);
    }

    @Override
    protected boolean isRowAddable(int row, List<ProjectComponent> tableRows) {
        ProjectComponent projectComponent = tableRows.get(row);
        return !(projectComponent instanceof Predicate);
    }
}

