/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.table;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerApp;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentTransferHandler;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.table.ProjectComponentTableCellRenderer;
import com.sodiumarc.patchwork.util.TargetablePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public abstract class ProjectComponentTable<T extends ProjectComponent>
extends TargetablePanel<T> {
    public static final Icon DELETE_ICON = IconLoader.loadIcon("silk/cross.png");
    private final String columnName;
    private final List<ButtonColumn> buttonColumns;
    private final ProjectComponentTableModel tableModel;
    private final List<ProjectComponent> tableRows;
    private final ProjectComponentTransferHandler transferHandler = new ProjectComponentTransferHandler(){

        @Override
        protected boolean canDragSelected(JComponent c) {
            for (int r : ProjectComponentTable.this.table.getSelectedRows()) {
                if (ProjectComponentTable.this.isRowDragable(r, ProjectComponentTable.this.tableRows)) continue;
                return false;
            }
            return true;
        }

        @Override
        protected Set<ProjectComponent> getExportComponents(JComponent c) {
            HashSet<ProjectComponent> result = new HashSet<ProjectComponent>();
            for (int row : ProjectComponentTable.this.table.getSelectedRows()) {
                ProjectComponent component = (ProjectComponent)ProjectComponentTable.this.tableRows.get(row);
                result.add(component);
            }
            return result;
        }

        @Override
        protected void exportDone(Set<String> guids, int action) {
        }

        @Override
        protected void importComponents(TransferHandler.DropLocation dropLocation, Set<String> guids) {
            JTable.DropLocation dl = (JTable.DropLocation)dropLocation;
            int row = dl.getRow();
            for (String guid : guids) {
                Reference<String> ref = new Reference<String>((ProjectComponent)ProjectComponentTable.this.getTarget(), guid);
                ProjectComponentTable.this.insertRow(row, (ProjectComponent)((Object)ref.resolve()), ProjectComponentTable.this.tableRows);
                ProjectComponentTable.this.updateTable();
                ProjectComponentTable.this.fireTargetModified();
            }
        }
    };
    private static final Color SECTION_HEADER_COLOR = new Color(225, 235, 245);
    private final JTable table;

    public ProjectComponentTable(Set<ButtonColumn> buttons, String columnName, boolean enableDrag) {
        this(null, buttons, columnName, enableDrag);
    }

    public ProjectComponentTable(String title, Set<ButtonColumn> buttons, String columnName, boolean enableDrag) {
        super(new BorderLayout(5, 2));
        this.columnName = columnName;
        this.buttonColumns = new ArrayList<ButtonColumn>(buttons);
        this.tableModel = new ProjectComponentTableModel();
        this.tableRows = new ArrayList<ProjectComponent>();
        this.table = new JTable(this.tableModel);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowHeight(25);
        this.table.setIntercellSpacing(new Dimension(0, 1));
        this.table.setShowVerticalLines(false);
        for (int c = 1; c < this.tableModel.getColumnCount(); ++c) {
            this.table.getColumnModel().getColumn(c).setMaxWidth(40);
        }
        if (enableDrag) {
            this.table.setDragEnabled(true);
            this.table.setDropMode(DropMode.INSERT_ROWS);
            this.table.setTransferHandler(this.transferHandler);
            this.transferHandler.createGestureRecognizer(this.table);
        }
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProjectComponentTable.this.cellClicked(ProjectComponentTable.this.table.rowAtPoint(e.getPoint()), ProjectComponentTable.this.table.columnAtPoint(e.getPoint()));
            }
        });
        ProjectComponentTableCellRenderer projectComponentRenderer = new ProjectComponentTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                JLabel label = (JLabel)result;
                if (ProjectComponentTable.this.isSectionHeaderRow(row, ProjectComponentTable.this.tableRows)) {
                    label.setBackground(SECTION_HEADER_COLOR);
                    label.setText("<html><b>" + label.getText() + "</b></html>");
                } else {
                    label.setBackground(Color.WHITE);
                }
                return result;
            }

            @Override
            protected int getIndent(Object value, int row) {
                return ProjectComponentTable.this.getIndent(row, ProjectComponentTable.this.tableRows);
            }

            @Override
            protected String getLabelText(ProjectComponent value, int row) {
                int labelGenerations = ProjectComponentTable.this.getLabelGenerations(row, ProjectComponentTable.this.tableRows);
                if (labelGenerations > 1) {
                    return value.getIDPath(labelGenerations - 1, ".");
                }
                return super.getLabelText(value, row);
            }
        };
        this.table.setDefaultRenderer(ProjectComponent.class, projectComponentRenderer);
        DefaultTableCellRenderer buttonRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (column == 0) {
                    return result;
                }
                ButtonColumn col = (ButtonColumn)((Object)ProjectComponentTable.this.buttonColumns.get(column - 1));
                JLabel label = (JLabel)result;
                label.setHorizontalAlignment(0);
                label.setText(null);
                if (((Boolean)value).booleanValue()) {
                    label.setIcon(col.getIcon());
                } else {
                    label.setIcon(null);
                }
                if (ProjectComponentTable.this.isSectionHeaderRow(row, ProjectComponentTable.this.tableRows)) {
                    label.setBackground(SECTION_HEADER_COLOR);
                } else {
                    label.setBackground(Color.WHITE);
                }
                return result;
            }
        };
        this.table.setDefaultRenderer(Boolean.class, buttonRenderer);
        JScrollPane scroller = new JScrollPane(this.table);
        scroller.getViewport().setBackground(Color.WHITE);
        scroller.setBorder(BorderFactory.createEtchedBorder(1));
        scroller.setPreferredSize(new Dimension(400, 200));
        this.add((Component)scroller, "Center");
        if (title != null) {
            TitledBorder titleBorder = BorderFactory.createTitledBorder(title);
            Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            CompoundBorder outerBorder = BorderFactory.createCompoundBorder(titleBorder, emptyBorder);
            this.setBorder(outerBorder);
        }
    }

    @Override
    protected void targetSet() {
        this.updateTable();
    }

    protected abstract void getRows(T var1, List<ProjectComponent> var2);

    protected int getIndent(int row, List<ProjectComponent> tableRows) {
        return 0;
    }

    protected int getLabelGenerations(int row, List<ProjectComponent> tableRows) {
        return 1;
    }

    protected boolean isSectionHeaderRow(int row, List<ProjectComponent> tableRows) {
        return false;
    }

    protected boolean isRowRemovable(int row, List<ProjectComponent> tableRows) {
        return false;
    }

    protected boolean isRowAddable(int row, List<ProjectComponent> tableRows) {
        return false;
    }

    protected boolean isRowEditable(int row, List<ProjectComponent> tableRows) {
        return false;
    }

    protected boolean isRowDragable(int row, List<ProjectComponent> tableRows) {
        return false;
    }

    protected void insertRow(int row, ProjectComponent component, List<ProjectComponent> tableRows) {
    }

    protected void removeRow(int row, List<ProjectComponent> tableRows) {
    }

    protected void addAtRow(int row, List<ProjectComponent> tableRows) {
    }

    protected final JTable getTable() {
        return this.table;
    }

    private Component makeButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton addButton = new JButton(ButtonColumn.Add.getIcon());
        addButton.setHorizontalAlignment(0);
        buttonPanel.add(addButton);
        return buttonPanel;
    }

    private void updateTable() {
        this.tableRows.clear();
        ProjectComponent target = (ProjectComponent)this.getTarget();
        if (target != null) {
            this.getRows(target, this.tableRows);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void cellClicked(int row, int column) {
        boolean changed = false;
        if (column == 0) {
            return;
        }
        ButtonColumn col = this.buttonColumns.get(column - 1);
        switch (col) {
            case Add: {
                if (!this.isRowAddable(row, this.tableRows)) break;
                this.addAtRow(row, this.tableRows);
                changed = true;
                break;
            }
            case Del: {
                if (!this.isRowRemovable(row, this.tableRows)) break;
                this.removeRow(row, this.tableRows);
                changed = true;
                break;
            }
            case Edit: {
                if (!this.isRowEditable(row, this.tableRows)) break;
                PatchworkComposerApp.getInstance().getMainPanel().showEditDialog(this.tableRows.get(row));
                changed = true;
            }
        }
        if (changed) {
            this.updateTable();
            this.fireTargetModified();
        }
    }

    private class ProjectComponentTableModel
    extends AbstractTableModel {
        private ProjectComponentTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ProjectComponentTable.this.columnName;
                }
            }
            return ((ButtonColumn)((Object)ProjectComponentTable.this.buttonColumns.get(column - 1))).toString();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ProjectComponent.class;
                }
            }
            return Boolean.class;
        }

        @Override
        public int getRowCount() {
            return ProjectComponentTable.this.tableRows.size();
        }

        @Override
        public int getColumnCount() {
            return 1 + ProjectComponentTable.this.buttonColumns.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ProjectComponentTable.this.tableRows.get(rowIndex);
                }
            }
            ButtonColumn col = (ButtonColumn)((Object)ProjectComponentTable.this.buttonColumns.get(columnIndex - 1));
            switch (col) {
                case Add: {
                    return ProjectComponentTable.this.isRowAddable(rowIndex, ProjectComponentTable.this.tableRows);
                }
                case Del: {
                    return ProjectComponentTable.this.isRowRemovable(rowIndex, ProjectComponentTable.this.tableRows);
                }
                case Edit: {
                    return ProjectComponentTable.this.isRowEditable(rowIndex, ProjectComponentTable.this.tableRows);
                }
            }
            return false;
        }
    }

    public static enum ButtonColumn {
        Edit{

            @Override
            public Icon getIcon() {
                return IconLoader.loadIcon("silk/pencil.png");
            }
        }
        ,
        Del{

            @Override
            public Icon getIcon() {
                return IconLoader.loadIcon("silk/cross.png");
            }
        }
        ,
        Add{

            @Override
            public Icon getIcon() {
                return IconLoader.loadIcon("silk/add.png");
            }
        };


        public abstract Icon getIcon();
    }
}

