/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.table;

import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.util.CompareUtilities;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class IOTypeTable
extends JTable {
    private final IODirectoryTableModel model = new IODirectoryTableModel();
    private Map<IOFileType, String> targetMap;
    private final Map<IOFileType, String> defaultMap;
    private final List<IOFileType> keys;

    public IOTypeTable(Map<IOFileType, String> defaultMap) {
        this.defaultMap = defaultMap;
        this.keys = new ArrayList<IOFileType>();
        this.keys.addAll(defaultMap.keySet());
        this.setModel(this.model);
        this.getColumnModel().getColumn(0).setMaxWidth(100);
        this.getColumnModel().getColumn(0).setMinWidth(100);
        this.setRowSelectionAllowed(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                IOTypeTable.this.cellClicked(IOTypeTable.this.rowAtPoint(e.getPoint()), IOTypeTable.this.columnAtPoint(e.getPoint()));
            }
        });
    }

    public final void setTargetMap(Map<IOFileType, String> targetMap) {
        this.targetMap = targetMap;
        this.model.fireTableDataChanged();
    }

    protected void targetChanged(Map<IOFileType, String> targetMap) {
    }

    protected String onEdit(IOFileType key, String currentValue) {
        return currentValue;
    }

    private void cellClicked(int rowIndex, int colIndex) {
        String newValue;
        IOFileType key;
        String oldValue;
        if (this.targetMap == null) {
            return;
        }
        if (rowIndex < this.model.getRowCount() && colIndex == 1 && !CompareUtilities.equals(oldValue = this.getValue(key = (IOFileType)((Object)this.model.getValueAt(rowIndex, 0))), newValue = this.onEdit(key, oldValue))) {
            this.targetMap.put(key, newValue);
            this.model.fireTableDataChanged();
            this.targetChanged(this.targetMap);
        }
    }

    private String getValue(IOFileType key) {
        String targetValue;
        String string = targetValue = this.targetMap == null ? null : this.targetMap.get((Object)key);
        if (targetValue != null) {
            return targetValue;
        }
        return this.defaultMap.get((Object)key);
    }

    private class IODirectoryTableModel
    extends AbstractTableModel {
        private IODirectoryTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Value";
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return IOFileType.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public int getRowCount() {
            return IOTypeTable.this.keys.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            IOFileType enumVal = (IOFileType)((Object)IOTypeTable.this.keys.get(rowIndex));
            switch (columnIndex) {
                case 0: {
                    return enumVal;
                }
                case 1: {
                    return IOTypeTable.this.getValue(enumVal);
                }
            }
            return null;
        }
    }
}

