/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.sound;

import com.sodiumarc.patchwork.app.scenecomposer.sound.FloatSampleUtils;
import com.sodiumarc.patchwork.app.scenecomposer.sound.Transitioner;
import java.util.Locale;
import javax.sound.sampled.AudioFormat;

public class CrossFader
implements Transitioner {
    private float ditherBits = 0.3f;
    private TypeOfFade type = TypeOfFade.PARABOLIC;

    @Override
    public void process(byte[] active, byte[] next, int srcOffset, byte[] result, int dstOffset, int frameCount, AudioFormat format) {
        int i;
        float[][] lastFloatBuffer = new float[format.getChannels()][frameCount];
        float[][] nextFloatBuffer = new float[format.getChannels()][frameCount];
        FloatSampleUtils.byte2float(active, srcOffset, (Object[])lastFloatBuffer, 0, frameCount, format);
        FloatSampleUtils.byte2float(next, srcOffset, (Object[])nextFloatBuffer, 0, frameCount, format);
        int overlap = frameCount % 2 == 0 ? 0 : 1;
        int len = frameCount / 2 + overlap;
        for (float[] f : lastFloatBuffer) {
            for (i = 0; i < len; ++i) {
                f[i] = this.fadeOut(f[i], i, len - 1);
            }
        }
        for (float[] f : nextFloatBuffer) {
            for (i = 0; i < len; ++i) {
                f[i + len - overlap] = this.fadeIn(f[i + len - overlap], i, len - 1);
            }
        }
        FloatSampleUtils.float2byte((Object[])lastFloatBuffer, 0, result, dstOffset, len, format, this.ditherBits);
        FloatSampleUtils.float2byte((Object[])nextFloatBuffer, len - overlap, result, (len - overlap) * format.getFrameSize() + dstOffset, len, format, this.ditherBits);
    }

    private float fadeIn(float sample, int index, int range) {
        switch (this.type) {
            case TRIANGULAR: {
                return sample * (float)index / (float)range;
            }
            case PARABOLIC: {
                float f = (float)index / (float)range;
                return sample * f * f;
            }
        }
        return -1000.0f;
    }

    private float fadeOut(float sample, int index, int range) {
        switch (this.type) {
            case TRIANGULAR: {
                return sample * ((float)index / (float)range * -1.0f + 1.0f);
            }
            case PARABOLIC: {
                float f = 1.0f - (float)index / (float)range;
                return sample * f * f;
            }
        }
        return -1000.0f;
    }

    @Override
    public String getName() {
        return "OutInFader - \u00a9 C.U.";
    }

    @Override
    public String getParameters() {
        String typeStr = "";
        switch (this.type) {
            case TRIANGULAR: {
                typeStr = "Triangular (linear) shape";
                break;
            }
            case PARABOLIC: {
                typeStr = "Parabolic shape";
            }
        }
        return String.format(Locale.US, typeStr + " - Dither bits: %.1f", Float.valueOf(this.ditherBits));
    }

    public TypeOfFade getTypeOfFade(TypeOfFade type) {
        return type;
    }

    public void setTypeOfFade(TypeOfFade type) {
        this.type = type;
    }

    public float getDitherBits() {
        return this.ditherBits;
    }

    public void setDitherBits(float ditherBits) {
        this.ditherBits = ditherBits;
    }

    public static enum TypeOfFade {
        TRIANGULAR,
        PARABOLIC;

    }
}

