/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.sound;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class ArrayClip
implements Clip {
    private byte[] audioData;
    protected int frameLength;
    protected int frameSize;
    protected int framePos;
    protected AudioFormat format;
    protected SourceDataLine dataLine;
    protected volatile boolean active;
    protected long timeStarted;
    protected int loopCount;
    protected int loopStart;
    protected int loopEnd;

    @Override
    public void open(AudioFormat format, byte[] data, int offset, int bufferSize) throws LineUnavailableException {
        if (bufferSize % format.getFrameSize() != 0) {
            throw new IllegalArgumentException("Buffer size must be multiple of frame size!");
        }
        AudioInputStream ais = new AudioInputStream(new ByteArrayInputStream(data, offset, bufferSize), format, bufferSize / format.getFrameSize());
        try {
            this.open(ais);
        }
        catch (IOException e) {
            throw new RuntimeException("Something is seriously broken!", e);
        }
    }

    @Override
    public void open(AudioInputStream stream) throws LineUnavailableException, IOException {
        if (stream.getFormat().getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            stream = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, stream);
        }
        this.frameLength = (int)stream.getFrameLength();
        this.format = stream.getFormat();
        this.frameSize = this.format.getFrameSize();
        int len = this.frameLength * this.frameSize;
        this.audioData = new byte[len];
        int numRead = 0;
        int offset = 0;
        while (numRead != -1) {
            numRead = stream.read(this.audioData, offset, len);
            offset += numRead;
        }
        this.setLoopPoints(0, -1);
        this.framePos = 0;
        this.active = false;
        this.dataLine = AudioSystem.getSourceDataLine(this.format);
        this.dataLine.open(this.format);
    }

    @Override
    public int getFrameLength() {
        return this.frameLength;
    }

    @Override
    public long getMicrosecondLength() {
        return this.framesToMicroseconds(this.frameLength);
    }

    @Override
    public void setFramePosition(int frames) {
        this.framePos = frames;
    }

    @Override
    public void setMicrosecondPosition(long microseconds) {
        this.framePos = this.microsecondsToFrames(microseconds);
    }

    @Override
    public void setLoopPoints(int start, int end) {
        if (end == -1) {
            end = this.frameLength - 1;
        }
        if (start < 0 || end >= this.frameLength || start > end) {
            throw new IllegalArgumentException("Loop points out of bounds or end before start!");
        }
        this.loopStart = start;
        this.loopEnd = end;
    }

    @Override
    public void loop(int count) {
        if (this.loopEnd / this.frameSize >= this.framePos) {
            this.loopCount = count;
        }
        this.start();
    }

    @Override
    public void drain() {
        this.dataLine.drain();
    }

    @Override
    public void flush() {
        this.dataLine.flush();
    }

    @Override
    public void start() {
        if (this.active) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                ArrayClip.this.dataLine.start();
                int dataLineBufferFrames = ArrayClip.this.dataLine.getBufferSize() / ArrayClip.this.frameSize;
                int transferBufferFrames = dataLineBufferFrames / 4;
                int transferBufferBytes = transferBufferFrames * ArrayClip.this.frameSize;
                ArrayClip.this.active = true;
                do {
                    ArrayClip.this.timeStarted = System.currentTimeMillis() * 1000L - ArrayClip.this.framesToMicroseconds(ArrayClip.this.getFramePosition());
                    while (ArrayClip.this.active && (ArrayClip.this.loopsRemaining() && ArrayClip.this.framePos <= ArrayClip.this.loopEnd || ArrayClip.this.loopCount == 0 && ArrayClip.this.framePos < ArrayClip.this.frameLength)) {
                        int len;
                        int bytePos = ArrayClip.this.framePos * ArrayClip.this.frameSize;
                        int available = ArrayClip.this.dataLine.available();
                        if (available >= transferBufferBytes && (len = Math.min(available, (ArrayClip.this.loopCount > 0 ? (ArrayClip.this.loopEnd + 1) * ArrayClip.this.frameSize : ArrayClip.this.audioData.length) - bytePos)) > 0) {
                            ArrayClip.this.framePos += ArrayClip.this.dataLine.write(ArrayClip.this.audioData, bytePos, len) / ArrayClip.this.frameSize;
                        }
                        if (ArrayClip.this.framePos == 0 || ArrayClip.this.dataLine.getBufferSize() != ArrayClip.this.dataLine.available()) continue;
                        System.err.println("Buffer underrun!");
                    }
                    if (!ArrayClip.this.loopsRemaining()) continue;
                    ArrayClip.this.framePos = ArrayClip.this.loopStart;
                } while (ArrayClip.this.active && (ArrayClip.this.loopCount == -1 || ArrayClip.this.loopCount > 0 && --ArrayClip.this.loopCount >= 0));
                ArrayClip.this.dataLine.drain();
                ArrayClip.this.dataLine.stop();
                ArrayClip.this.active = false;
            }
        }.start();
    }

    private boolean loopsRemaining() {
        return this.loopCount > 0 || this.loopCount == -1;
    }

    @Override
    public synchronized void stop() {
        this.loopCount = 0;
        this.active = false;
    }

    @Override
    public boolean isRunning() {
        if (this.dataLine == null) {
            return false;
        }
        return this.dataLine.isRunning();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public int getBufferSize() {
        return this.audioData.length;
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public int getFramePosition() {
        if (this.dataLine != null) {
            return this.framePos - (this.dataLine.getBufferSize() - this.dataLine.available()) / this.frameSize;
        }
        return 0;
    }

    @Override
    public long getLongFramePosition() {
        return this.getFramePosition();
    }

    @Override
    public long getMicrosecondPosition() {
        if (this.isActive()) {
            return System.currentTimeMillis() * 1000L - this.timeStarted;
        }
        return this.framesToMicroseconds(this.getFramePosition());
    }

    @Override
    public float getLevel() {
        return this.dataLine.getLevel();
    }

    @Override
    public Line.Info getLineInfo() {
        return this.dataLine.getLineInfo();
    }

    @Override
    public void open() throws LineUnavailableException {
        throw new IllegalArgumentException("open() may not be called on a Clip!");
    }

    @Override
    public void close() {
        this.dataLine.close();
        this.audioData = null;
    }

    @Override
    public boolean isOpen() {
        return this.dataLine != null && this.dataLine.isOpen();
    }

    @Override
    public Control[] getControls() {
        return this.dataLine.getControls();
    }

    @Override
    public boolean isControlSupported(Control.Type control) {
        return this.dataLine.isControlSupported(control);
    }

    @Override
    public Control getControl(Control.Type control) {
        return this.dataLine.getControl(control);
    }

    @Override
    public void addLineListener(LineListener listener) {
        this.dataLine.addLineListener(listener);
    }

    @Override
    public void removeLineListener(LineListener listener) {
        this.dataLine.removeLineListener(listener);
    }

    public long framesToMicroseconds(int frames) {
        return (long)((double)frames / (double)this.format.getSampleRate() * 1000000.0);
    }

    public int microsecondsToFrames(long microseconds) {
        return (int)Math.round((double)microseconds / 1000000.0 * (double)this.format.getSampleRate());
    }
}

