/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.parallax;

import com.sodiumarc.patchwork.app.scanimport.OffsetImage;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.parallax.ParallaxedImage;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GraphicAnimator;
import com.sodiumarc.patchwork.render.mesh.MeshUtils;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.vecmath.Point3d;
import org.apache.log4j.Logger;

class ParallaxedGraphic
extends ParallaxedImage {
    private final Camera homeCamera;
    private final Point3d refPoint;
    private final SceneLocationLayer layer;
    private final Dimension outputSize;
    private final double clipDistance = 1.0;
    private final GraphicAnimator animator;
    private BufferedImage currentImage;
    private BufferedImage cacheImage;
    private Rectangle4d renderBounds;
    private Camera currentCamera;
    private Rectangle4d currentViewport;
    private float alpha = 1.0f;
    private Color hazeColor;
    private boolean showBoundaries;
    private boolean showRef;
    private boolean clipToOutput = true;
    private static final Logger LOGGER = Logger.getLogger(ParallaxedGraphic.class);

    public ParallaxedGraphic(SceneLocationLayer layer, GraphicAnimator graphic, Dimension outputSize, Transform3D coordTransform) {
        this.layer = layer;
        Camera layerCamera = graphic.getViewpoint().getCamera();
        if (layerCamera == null) {
            this.homeCamera = new Camera("dummy");
        } else if (coordTransform != null) {
            Transform3D transform = new Transform3D(coordTransform);
            transform.mul(layerCamera.getCumulativeTransform());
            this.homeCamera = new Camera("home", transform);
        } else {
            this.homeCamera = layerCamera;
        }
        this.setHomeCamera(this.homeCamera);
        Rectangle4d baseViewport = graphic.getViewpoint().getViewport();
        Rectangle4d outputBounds = new Rectangle4d(outputSize);
        Rectangle4d margins = graphic.getGraphic().getMarginsRegion();
        this.setHomeViewport(baseViewport.fromProportional(margins), outputBounds.fromProportional(margins).getSize());
        this.refPoint = layer.isBackground() ? null : layer.getRefPoint();
        this.outputSize = outputSize;
        if (coordTransform != null && this.refPoint != null) {
            coordTransform.transform(this.refPoint);
        }
        this.setRefPoint(this.refPoint);
        this.animator = graphic;
        this.updateRenderBounds();
        this.currentCamera = this.getHomeCamera();
    }

    public String getID() {
        return this.layer.getParentComponent().getID() + "." + this.layer.getID();
    }

    public void setClipToOutput(boolean clipToOutput) {
        this.clipToOutput = clipToOutput;
        this.updateRenderBounds();
    }

    public void setShowBoundaries(boolean showBoundaries) {
        this.showBoundaries = showBoundaries;
    }

    public void setShowRef(boolean showRef) {
        this.showRef = showRef;
    }

    public void setCurrentViewpoint(Camera currentCamera, Rectangle4d viewport) {
        this.currentCamera = currentCamera;
        this.currentViewport = viewport;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setHazeColor(Color hazeColor) {
        this.hazeColor = hazeColor;
    }

    public Color getHazeColor() {
        return this.hazeColor;
    }

    public BufferedImage getCurrentImage(boolean forceUpdate) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.cacheImage == null || forceUpdate) {
            this.cacheImage = this.getCurrentImage();
        }
        return this.cacheImage;
    }

    public BufferedImage getCurrentImage() {
        if (!this.isDisplayable() || this.isEmpty()) {
            return null;
        }
        Graphics2D g2 = (Graphics2D)this.currentImage.getGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, this.currentImage.getWidth(), this.currentImage.getHeight());
        this.paintCurrentImage(g2);
        g2.dispose();
        return this.currentImage;
    }

    public void paintCurrentImage(Graphics2D g2) {
        AffineTransform transform;
        if (!this.isDisplayable() || this.isEmpty()) {
            return;
        }
        if (this.animator.getGraphic().tracksCamera()) {
            transform = new AffineTransform();
        } else if (this.refPoint == null) {
            transform = new AffineTransform();
        } else {
            Camera homeCamera = this.getHomeCamera();
            Rectangle4d homeViewport = this.getHomeViewport(true);
            Rectangle4d currentViewport = this.getCurrentViewport();
            Dimension renderSize = this.getRenderSize();
            Rectangle4d homeRect = this.getRefRect(homeCamera, homeViewport, renderSize, 1.0f);
            Rectangle4d currentRect = this.getRefRect(this.currentCamera, currentViewport, renderSize, 1.0f);
            transform = this.getParallaxTransform(homeRect, currentRect);
        }
        Point offset = this.animator.getOffset();
        AffineTransform offsetTransform = new AffineTransform();
        offsetTransform.setToTranslation(offset.x, offset.y);
        transform.concatenate(offsetTransform);
        if (this.clipToOutput) {
            offsetTransform = new AffineTransform();
            offsetTransform.setToTranslation((int)this.renderBounds.getX(), (int)this.renderBounds.getY());
            offsetTransform.concatenate(transform);
            transform = offsetTransform;
        }
        g2.setComposite(this.alpha < 1.0f ? AlphaComposite.getInstance(2, this.alpha) : AlphaComposite.Src);
        g2.drawImage(this.animator.getImage(), transform, null);
        if (this.hazeColor != null && this.hazeColor.getAlpha() > 0) {
            g2.setColor(this.hazeColor);
            g2.setComposite(AlphaComposite.SrcOver);
            g2.fillRect(0, 0, this.currentImage.getWidth(), this.currentImage.getHeight());
        }
        if (this.showBoundaries) {
            g2.setColor(Color.RED);
            Rectangle4d border = new Rectangle4d(0.0, 0.0, this.currentImage.getWidth() - 1, this.currentImage.getHeight() - 1);
            border = border.transform(transform);
            g2.drawRect((int)border.getX(), (int)border.getY(), (int)border.getWidth(), (int)border.getHeight());
            g2.setColor(Color.GRAY);
            g2.drawRect(0, 0, this.currentImage.getWidth() - 1, this.currentImage.getHeight() - 1);
        }
        if (this.showRef) {
            this.drawRefPoint(g2);
            this.drawRefRect(g2, 2.0f);
        }
    }

    public Dimension getCurrentImageSize() {
        return this.clipToOutput ? this.outputSize : this.getRenderSize();
    }

    public Rectangle4d getRenderBounds() {
        return this.renderBounds;
    }

    public int getXOffset() {
        return this.clipToOutput ? 0 : (int)this.renderBounds.getX();
    }

    public int getYOffset() {
        return this.clipToOutput ? 0 : (int)this.renderBounds.getY();
    }

    public AlphaComposite getAlphaComposite() {
        return this.animator.getGraphic().getAlphaComposite();
    }

    public Point3d getRefPoint() {
        return this.refPoint;
    }

    public double getCameraDistance(Camera camera) {
        if (this.refPoint == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.refPoint.distance(camera.getGlobalPosition());
    }

    public double getCameraZDistance(Camera camera) {
        if (this.refPoint == null) {
            return Double.POSITIVE_INFINITY;
        }
        return -camera.globalToCamera(this.refPoint).getZ();
    }

    public Camera getHomeCamera() {
        return this.homeCamera;
    }

    public Point3d getHomeCameraPosition() {
        return this.getHomeCamera().getGlobalPosition();
    }

    public Rectangle4d getHomeViewport(boolean includeMargins) {
        Rectangle4d baseViewport = this.animator.getViewpoint().getViewport();
        if (!includeMargins) {
            return baseViewport;
        }
        return baseViewport.fromProportional(this.getMarginsRegion());
    }

    public boolean isEmpty() {
        return this.animator.isEmpty();
    }

    public boolean isDisplayable() {
        return this.isDisplayableFrom(this.currentCamera);
    }

    public boolean isDisplayableFrom(Camera camera) {
        if (this.getHomeCamera() == null || camera == null) {
            return false;
        }
        if (this.refPoint == null) {
            return true;
        }
        Point3d refCamera = camera.globalToCamera(this.refPoint);
        return refCamera.z <= -1.0;
    }

    @Override
    protected OffsetImage getHomeImage() {
        return new OffsetImage(this.animator.getImage(), this.animator.getOffset());
    }

    public String toString() {
        return this.getID();
    }

    private AffineTransform getParallaxTransform(Rectangle4d fromRect, Rectangle4d toRect) {
        double scale = toRect.getWidth() / fromRect.getWidth();
        double xTrans = toRect.getX() - fromRect.getX() * scale;
        double yTrans = toRect.getY() - fromRect.getY() * scale;
        if (LOGGER.isDebugEnabled()) {
            // empty if block
        }
        AffineTransform transform = new AffineTransform();
        transform.translate(xTrans, yTrans);
        transform.scale(scale, scale);
        return transform;
    }

    private Rectangle4d getRefRect(Camera camera, Rectangle4d viewport, Dimension imageSize, float rectSize) {
        if (this.refPoint == null) {
            return null;
        }
        Point3d refCamera = camera.globalToCamera(this.refPoint);
        Point3d topLeft = new Point3d(refCamera.getX() - (double)rectSize, refCamera.getY() + (double)rectSize, refCamera.getZ());
        Point3d bottomRight = new Point3d(refCamera.getX() + (double)rectSize, refCamera.getY() - (double)rectSize, refCamera.getZ());
        topLeft = camera.cameraToDisplay(topLeft, viewport, imageSize);
        bottomRight = camera.cameraToDisplay(bottomRight, viewport, imageSize);
        return new Rectangle4d(topLeft.getX(), topLeft.getY(), bottomRight.getX() - topLeft.getX(), bottomRight.getY() - topLeft.getY());
    }

    private Rectangle4d getCurrentViewport() {
        return this.currentViewport == null ? null : this.currentViewport.fromProportional(this.getMarginsRegion());
    }

    private Rectangle4d getMarginsRegion() {
        return this.animator.getGraphic().getMarginsRegion();
    }

    private Dimension getRenderSize() {
        return new Dimension(this.renderBounds.getSize());
    }

    private void drawRefRect(Graphics2D graphics, float rectSize) {
        Camera homeCamera = this.getHomeCamera();
        Rectangle4d homeViewport = this.getHomeViewport(true);
        Rectangle4d currentViewport = this.getCurrentViewport();
        Dimension renderSize = this.getRenderSize();
        Rectangle4d homeRect = this.getRefRect(homeCamera, homeViewport, renderSize, rectSize);
        Rectangle4d currentRect = this.getRefRect(this.currentCamera, currentViewport, renderSize, rectSize);
        AffineTransform transform = this.getParallaxTransform(homeRect, currentRect);
        Rectangle4d refRect = homeRect.transform(transform);
        graphics.setColor(Color.RED);
        graphics.drawRect((int)refRect.getX(), (int)refRect.getY(), (int)refRect.getWidth(), (int)refRect.getHeight());
        graphics.drawString(this.getID(), (int)refRect.getX(), (int)refRect.getY() - 2);
    }

    private void drawRefPoint(Graphics2D graphics) {
        if (this.refPoint == null) {
            return;
        }
        graphics.setComposite(AlphaComposite.SrcOver);
        Point3d refProjected = this.currentCamera.globalToDisplay(this.refPoint, this.getCurrentViewport(), this.getRenderSize());
        MeshUtils.drawVertex(graphics, refProjected, Color.RED, 5, null);
    }

    private void updateRenderBounds() {
        Dimension size;
        Rectangle4d newRenderBounds;
        Rectangle4d outputBounds = new Rectangle4d(this.outputSize);
        this.renderBounds = newRenderBounds = outputBounds.fromProportional(this.getMarginsRegion());
        Dimension dimension = size = this.clipToOutput ? this.outputSize : this.renderBounds.getSize();
        if (this.currentImage == null || this.currentImage.getWidth() != size.width || this.currentImage.getHeight() != size.height) {
            this.renderBounds = newRenderBounds;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
            this.currentImage = gc.createCompatibleImage(size.width, size.height, 3);
            this.currentImage.setAccelerationPriority(1.0f);
        }
    }
}

