/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.sound;

import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundClip;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequence;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import java.util.Map;
import javax.swing.Icon;

public class SoundSequenceEntry
extends ProjectComponent {
    private Reference<SoundClip> soundClip = new Reference();
    private boolean loop = false;
    private float volume = 1.0f;
    private int startDelayMillis = 0;
    private int transitionMillis = 1000;
    private String layerID = null;

    public SoundSequenceEntry(String id) {
        super(id);
    }

    public SoundClip getSoundClip() {
        return this.soundClip.resolve();
    }

    public void setSoundClip(SoundClip soundClip) {
        this.soundClip = new Reference<SoundClip>((ProjectComponent)this, soundClip);
        this.fireModified();
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
        this.fireModified();
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float volume) {
        this.volume = volume;
        this.fireModified();
    }

    public int getStartDelayMillis() {
        return this.startDelayMillis;
    }

    public void setStartDelayMillis(int startDelayMillis) {
        this.startDelayMillis = startDelayMillis;
        this.fireModified();
    }

    public int getTransitionMillis() {
        return this.transitionMillis;
    }

    public void setTransitionMillis(int transitionMillis) {
        this.transitionMillis = transitionMillis;
        this.fireModified();
    }

    public String getLayerID() {
        return this.layerID;
    }

    public void setLayerID(String layer) {
        this.layerID = layer;
        this.fireModified();
    }

    @Override
    public Icon getIcon() {
        return SoundSequence.ICON;
    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<SoundSequenceEntry> {
        private static final String ELEMENT_NAME = "SoundSequenceEntry";
        private static final String ATTR_SOUND_CLIP = "soundClip";
        private static final String ATTR_LOOP = "loop";
        private static final String ATTR_VOLUME = "volume";
        private static final String ATTR_START_DELAY = "startDelayMillis";
        private static final String ATTR_TRANSITION = "transitionMillis";
        private static final String ATTR_LAYER_ID = "layerID";

        public Transcoder() {
            super(ELEMENT_NAME, SoundSequenceEntry.class);
        }

        @Override
        protected void getAttributes(SoundSequenceEntry object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_SOUND_CLIP, object.soundClip.encode());
            destination.put(ATTR_LOOP, Boolean.toString(object.loop));
            destination.put(ATTR_VOLUME, Float.toString(object.volume));
            destination.put(ATTR_START_DELAY, Integer.toString(object.startDelayMillis));
            destination.put(ATTR_TRANSITION, Integer.toString(object.transitionMillis));
            if (object.layerID != null) {
                destination.put(ATTR_LAYER_ID, object.layerID);
            }
        }

        @Override
        protected final SoundSequenceEntry decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            SoundSequenceEntry result = new SoundSequenceEntry(id);
            result.soundClip = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_SOUND_CLIP));
            if (attributes.containsKey(ATTR_LOOP)) {
                result.loop = Boolean.valueOf(attributes.get(ATTR_LOOP));
            }
            if (attributes.containsKey(ATTR_VOLUME)) {
                result.volume = Float.valueOf(attributes.get(ATTR_VOLUME)).floatValue();
            }
            if (attributes.containsKey(ATTR_START_DELAY)) {
                result.startDelayMillis = Integer.valueOf(attributes.get(ATTR_START_DELAY));
            }
            if (attributes.containsKey(ATTR_TRANSITION)) {
                result.transitionMillis = Integer.valueOf(attributes.get(ATTR_TRANSITION));
            }
            result.layerID = attributes.get(ATTR_LAYER_ID);
            return result;
        }
    }
}

