/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.graphic;

import com.sodiumarc.patchwork.animation.SpriteSequence;
import com.sodiumarc.patchwork.animation.SpriteSheet;
import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.resource.ResourceManager;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class SpriteSequenceGraphic
extends LocationLayerGraphic {
    public static final Icon ICON = IconLoader.loadIcon("silk/film.png");
    public static final String SHADOW_SUFFIX = "SH";
    public static final int DEFAULT_MAX_SHEET_WIDTH = 650;
    public static final float DEFAULT_SHADOW_ALPHA = 0.3f;
    private String animationName;
    private float framesPerSecond = 12.0f;
    private boolean isPreCropped = true;
    private int maxSheetWidth = 650;
    private float shadowAlpha = 0.3f;
    private SpriteSheet spriteSheet;
    private int frameCount = 0;
    private int durationMillis = 0;
    private int currentFrameIndex = 0;
    private boolean updateSequenceRequired = true;
    private static final int SHEET_CELL_PADDING = 4;
    private static final int SHEET_MARGIN_ADJUST = 2;
    private static final Logger LOGGER = Logger.getLogger(SpriteSequenceGraphic.class);

    public SpriteSequenceGraphic(String id) {
        super(id);
    }

    public String getAnimationName() {
        return this.animationName;
    }

    public void setAnimationName(String animationName) {
        this.animationName = animationName;
        this.updateSequenceRequired = true;
        this.fireModified();
    }

    public File getAnimationDirectory() {
        if (this.animationName == null) {
            return null;
        }
        return new File(this.getIODirectory(IOFileType.ANIMATION_ROOT), this.animationName);
    }

    public int getFramesCount() {
        return this.frameCount;
    }

    public float getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public void setFramesPerSecond(float fps) {
        this.framesPerSecond = fps;
        this.updateDuration();
        this.fireModified();
    }

    public boolean isPreCropped() {
        return this.isPreCropped;
    }

    public void setPreCropped(boolean isPreCropped) {
        this.isPreCropped = isPreCropped;
        this.updateSequenceRequired = true;
        this.fireModified();
    }

    public int getMaxSheetWidth() {
        return this.maxSheetWidth;
    }

    public void setMaxSheetWidth(int maxSheetWidth) {
        this.maxSheetWidth = maxSheetWidth;
        this.fireModified();
    }

    public float getShadowAlpha() {
        return this.shadowAlpha;
    }

    public void setShadowAlpha(float shadowAlpha) {
        this.shadowAlpha = shadowAlpha;
        this.fireModified();
    }

    public void updateFromFrameImages() {
        SpriteSheet spriteSheet = null;
        if (this.animationName != null) {
            try {
                ArrayList<BufferedImage> frameImages = new ArrayList<BufferedImage>();
                File animationDir = this.getAnimationDirectory();
                if (animationDir == null) {
                    return;
                }
                Rectangle4d viewport = null;
                Dimension renderSize = this.getOutputBounds().getSize();
                if (!this.isPreCropped) {
                    viewport = this.getAncestorByType(SceneLocation.class).getViewportProportional(false);
                    viewport = viewport.fromProportional(this.getMarginsRegion());
                    renderSize = PatchworkProject.CARD_RECT.fromProportional(this.getMarginsRegion()).getSize();
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Viewport: " + viewport);
                    LOGGER.debug("Render size: " + renderSize);
                }
                SpriteSequence shadowSequence = new SpriteSequence(this.animationName + SHADOW_SUFFIX, animationDir, viewport);
                List<BufferedImage> shadowImages = shadowSequence.getFrameImages(renderSize);
                SpriteSequence sequence = new SpriteSequence(this.animationName, animationDir, viewport);
                List<BufferedImage> fillImages = sequence.getFrameImages(renderSize);
                SpriteSheet traceSheet = this.loadSpriteSheet(this.animationName + ".TR");
                for (int i = 0; i < fillImages.size(); ++i) {
                    BufferedImage foregroundImage = fillImages.get(i);
                    BufferedImage traceImage = traceSheet == null ? null : traceSheet.getFrameImage(i, renderSize, 2);
                    BufferedImage shadowImage = i >= shadowImages.size() ? null : shadowImages.get(i);
                    frameImages.add(this.compositeFrame(traceImage, foregroundImage, shadowImage));
                }
                spriteSheet = new SpriteSheet(this.animationName, frameImages, 4, this.maxSheetWidth, this.getOutputSize());
                spriteSheet.save(animationDir);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to update animation " + this.getID() + ": " + e.getMessage());
            }
        }
        this.setSpriteSheet(spriteSheet);
        this.updateSequenceRequired = false;
        this.fireModified();
    }

    public SpriteSheet getSpriteSheet() {
        this.updateSpriteSheet();
        return this.spriteSheet;
    }

    public void saveFrameImages(File directory) {
        this.updateSpriteSheet();
        try {
            this.spriteSheet.writeFrameImages(directory, "png", this.getOutputSize(), 0);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write frame images for " + this.getID() + ": " + e.getMessage());
        }
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public boolean isAnimated() {
        return this.animationName != null;
    }

    @Override
    public BufferedImage getImageImpl(float elapsedFraction, boolean doScale) {
        this.updateSpriteSheet();
        Dimension renderSize = this.getOutputBounds().getSize();
        int lastFrameIndex = this.frameCount - 1;
        lastFrameIndex = Math.max(lastFrameIndex, 0);
        float frameIndexFloat = elapsedFraction * (float)(lastFrameIndex + 1);
        int frameIndex = (int)MathUtils.clamp(Math.floor(frameIndexFloat), 0.0, (double)lastFrameIndex);
        if (this.spriteSheet != null) {
            return this.spriteSheet.getFrameImage(frameIndex, renderSize, 2);
        }
        return null;
    }

    @Override
    public int getDurationInMillis() {
        this.updateSpriteSheet();
        return this.durationMillis;
    }

    @Override
    public boolean isEmpty() {
        return this.animationName == null;
    }

    @Override
    public boolean publish() {
        this.updateSpriteSheet();
        if (this.spriteSheet == null) {
            return false;
        }
        String guid = this.getGUID();
        long lastModified = this.getLastModified();
        long sheetLastModified = ResourceManager.getLastModification(SpriteSheet.getSheetImageFilename(guid));
        long propsLastModified = ResourceManager.getLastModification(SpriteSheet.getPropertiesFilename(guid));
        if (lastModified > sheetLastModified || lastModified > propsLastModified) {
            try {
                this.spriteSheet.save(ResourceManager.getPublishDir(), this.getGUID());
            }
            catch (IOException e) {
                LOGGER.warn("Failed to publish " + this.getID() + ": " + e.getMessage());
            }
            return true;
        }
        return false;
    }

    @Override
    public void preload() {
        this.updateSpriteSheet();
    }

    private void updateSpriteSheet() {
        if (!this.updateSequenceRequired) {
            return;
        }
        SpriteSheet spriteSheet = null;
        PatchworkProject project = (PatchworkProject)this.getPath().get(0);
        if (project.isPublished()) {
            String guid = this.getGUID();
            InputStream imageFile = ResourceManager.getInputStream(SpriteSheet.getSheetImageFilename(guid));
            InputStream propsFile = ResourceManager.getInputStream(SpriteSheet.getPropertiesFilename(guid));
            if (imageFile != null && propsFile != null) {
                spriteSheet = SpriteSheet.load(imageFile, propsFile);
            }
        } else {
            spriteSheet = this.loadSpriteSheet(this.animationName);
        }
        if (spriteSheet != null) {
            this.setSpriteSheet(spriteSheet);
        } else {
            this.updateFromFrameImages();
        }
        this.currentFrameIndex = Math.min(this.currentFrameIndex, this.getFramesCount() - 1);
        this.updateDuration();
        this.updateSequenceRequired = false;
    }

    private SpriteSheet loadSpriteSheet(String name) {
        File animationDir = this.getAnimationDirectory();
        if (animationDir == null) {
            return null;
        }
        return SpriteSheet.load(animationDir, name);
    }

    private void setSpriteSheet(SpriteSheet spriteSheet) {
        if (spriteSheet != null) {
            this.frameCount = spriteSheet.getFrameCount();
            this.currentFrameIndex = Math.min(this.currentFrameIndex, this.frameCount - 1);
        } else {
            this.frameCount = 0;
            this.currentFrameIndex = 0;
        }
        this.spriteSheet = spriteSheet;
        this.updateDuration();
    }

    private void updateDuration() {
        this.durationMillis = this.frameCount == 0 ? 0 : (int)((float)this.frameCount / this.framesPerSecond * 1000.0f);
    }

    private BufferedImage compositeFrame(BufferedImage traceImage, BufferedImage fillImage, BufferedImage shadowImage) {
        if (traceImage == null && shadowImage == null) {
            return fillImage;
        }
        BufferedImage result = new BufferedImage(fillImage.getWidth(), fillImage.getHeight(), 2);
        Graphics2D g = result.createGraphics();
        if (shadowImage != null) {
            g.setComposite(AlphaComposite.getInstance(3, this.shadowAlpha));
            g.drawImage((Image)shadowImage, 0, 0, null);
        }
        g.setComposite(AlphaComposite.SrcOver);
        g.drawImage((Image)fillImage, 0, 0, null);
        if (traceImage != null) {
            g.drawImage((Image)traceImage, 0, 0, null);
        }
        return result;
    }

    public static class Transcoder
    extends LocationLayerGraphic.Transcoder<SpriteSequenceGraphic> {
        private static final String ELEMENT_NAME = "SpriteSequenceGraphic";
        private static final String ATTR_ANIM_NAME = "animationName";
        private static final String ATTR_FPS = "framesPerSecond";
        private static final String ATTR_CROPPED = "isPreCropped";
        private static final String ATTR_SHADOW_ALPHA = "shadowAlpha";
        private static final String ATTR_MAX_SHEET_WIDTH = "maxSheetWidth";

        public Transcoder() {
            super(ELEMENT_NAME, SpriteSequenceGraphic.class);
        }

        @Override
        protected void getAttributes(SpriteSequenceGraphic object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_ANIM_NAME, object.animationName);
            destination.put(ATTR_FPS, Float.toString(object.framesPerSecond));
            destination.put(ATTR_CROPPED, Boolean.toString(object.isPreCropped));
            destination.put(ATTR_SHADOW_ALPHA, Float.toString(object.shadowAlpha));
            destination.put(ATTR_MAX_SHEET_WIDTH, Integer.toString(object.maxSheetWidth));
        }

        @Override
        protected SpriteSequenceGraphic decodeGraphic(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            SpriteSequenceGraphic result = new SpriteSequenceGraphic(id);
            result.animationName = attributes.get(ATTR_ANIM_NAME);
            String fpsStr = attributes.get(ATTR_FPS);
            if (fpsStr != null) {
                result.framesPerSecond = Float.parseFloat(fpsStr);
            }
            if (attributes.containsKey(ATTR_CROPPED)) {
                result.isPreCropped = (boolean)Boolean.valueOf(attributes.get(ATTR_CROPPED));
            }
            if (attributes.containsKey(ATTR_SHADOW_ALPHA)) {
                result.shadowAlpha = Float.valueOf(attributes.get(ATTR_SHADOW_ALPHA)).floatValue();
            }
            if (attributes.containsKey(ATTR_MAX_SHEET_WIDTH)) {
                result.maxSheetWidth = Integer.valueOf(attributes.get(ATTR_MAX_SHEET_WIDTH));
            }
            return result;
        }
    }
}

