/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.graphic;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ReferenceList;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridCoords;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.StringUtils;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class SlideGraphic
extends LocationLayerGraphic {
    public static final Icon ICON = IconLoader.loadIcon("silk/images.png");
    private ReferenceList<LocationLayerGraphic> graphics = new ReferenceList();
    private final Point startOffset = new Point();
    private final Point endOffset = new Point();
    private GridCoords tileSize;
    private int durationInMillis = 1000;
    private BufferedImage currentImage;

    public SlideGraphic(String id) {
        super(id);
    }

    public List<LocationLayerGraphic> getGraphics() {
        return this.graphics.resolve();
    }

    public void addGraphic(LocationLayerGraphic graphic) {
        this.graphics.resolve().add(graphic);
        this.fireModified();
    }

    public void removeGraphic(LocationLayerGraphic graphic) {
        this.graphics.resolve().remove(graphic);
        this.fireModified();
    }

    public Point getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(Point startOffset) {
        this.startOffset.setLocation(startOffset);
        this.fireModified();
    }

    public Point getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(Point endOffset) {
        this.endOffset.setLocation(endOffset);
        this.fireModified();
    }

    public float getDurationSeconds() {
        return (float)this.durationInMillis / 1000.0f;
    }

    public void setDurationSeconds(float fps) {
        this.durationInMillis = (int)(1000.0f * fps);
        this.fireModified();
    }

    public GridCoords getTileSize() {
        if (this.tileSize == null) {
            return GridCoords.UNIT_DIM;
        }
        return this.tileSize;
    }

    public void setTileSize(GridCoords tileSize) {
        this.tileSize = tileSize;
        this.fireModified();
    }

    @Override
    public boolean isAnimated() {
        return this.durationInMillis > 0;
    }

    @Override
    public boolean isEmpty() {
        List<LocationLayerGraphic> graphics = this.getGraphics();
        return graphics.isEmpty();
    }

    @Override
    public BufferedImage getImageImpl(float elapsedFraction, boolean doScale) {
        BufferedImage bottomRightImage;
        List<LocationLayerGraphic> graphics = this.getGraphics();
        if (graphics.isEmpty()) {
            return null;
        }
        Point slideOffset = this.getSlideOffset(elapsedFraction);
        this.updateRenderBounds();
        int w = this.currentImage.getWidth();
        int h = this.currentImage.getHeight();
        GridCoords topLeftGridCoords = this.toTileGridCoords(0, 0, slideOffset);
        Point topLeftPixelCoords = this.toTilePixelCoords(0, 0, slideOffset);
        GridCoords bottomRightGridCoords = this.toTileGridCoords(w - 1, h - 1, slideOffset);
        Point bottomRightPixelCoords = this.toTilePixelCoords(w - 1, h - 1, slideOffset);
        Graphics2D g = this.currentImage.createGraphics();
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(0, 0, this.currentImage.getWidth(), this.currentImage.getHeight());
        g.setComposite(AlphaComposite.SrcOver);
        BufferedImage topLeftImage = this.getTileImage(topLeftGridCoords, elapsedFraction);
        if (topLeftImage != null) {
            AffineTransform transform = new AffineTransform();
            transform.setToTranslation(-topLeftPixelCoords.x, -topLeftPixelCoords.y);
            g.drawImage(topLeftImage, transform, null);
        }
        if (bottomRightGridCoords.getCol() != topLeftGridCoords.getCol() && (bottomRightImage = this.getTileImage(bottomRightGridCoords, elapsedFraction)) != null) {
            AffineTransform transform = new AffineTransform();
            transform.setToTranslation(w - 1 - bottomRightPixelCoords.x, h - 1 - bottomRightPixelCoords.y);
            g.drawImage(bottomRightImage, transform, null);
        }
        g.dispose();
        return this.currentImage;
    }

    @Override
    public int getDurationInMillis() {
        return this.durationInMillis;
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    private GridCoords toTileGridCoords(int x, int y, Point slideOffset) {
        int sourceX = x - slideOffset.x;
        int sourceY = y - slideOffset.y;
        GridCoords tileSize = this.getTileSize();
        int tileWidth = tileSize.getCol() * PatchworkProject.CARD_SIZE;
        int tileHeight = tileSize.getRow() * PatchworkProject.CARD_SIZE;
        int col = sourceX / tileWidth;
        if (sourceX < 0 && sourceX % tileWidth != 0) {
            --col;
        }
        int row = sourceY / tileHeight;
        if (sourceY < 0 && sourceY % tileHeight != 0) {
            --row;
        }
        return new GridCoords(row, col);
    }

    private Point toTilePixelCoords(int x, int y, Point slideOffset) {
        int resultY;
        int sourceX = x - slideOffset.x;
        int sourceY = y - slideOffset.y;
        GridCoords tileSize = this.getTileSize();
        int tileWidth = tileSize.getCol() * PatchworkProject.CARD_SIZE;
        int tileHeight = tileSize.getRow() * PatchworkProject.CARD_SIZE;
        int resultX = sourceX % tileWidth;
        if (resultX < 0) {
            resultX += tileWidth;
        }
        if ((resultY = sourceY % tileHeight) < 0) {
            resultY += tileHeight;
        }
        return new Point(resultX, resultY);
    }

    private BufferedImage getTileImage(GridCoords tileCoords, float elapsedFraction) {
        List<LocationLayerGraphic> graphics = this.getGraphics();
        if (graphics.isEmpty()) {
            return null;
        }
        int tileIndex = Math.abs(tileCoords.getCol() - tileCoords.getRow()) % graphics.size();
        return graphics.get(tileIndex).getImage(elapsedFraction);
    }

    private Point getSlideOffset(float elapsedFraction) {
        Point startOffset = this.getStartOffset();
        Point endOffset = this.getEndOffset();
        double x = MathUtils.interpolate(elapsedFraction, startOffset.x * PatchworkProject.CARD_SIZE, endOffset.x * PatchworkProject.CARD_SIZE);
        double y = MathUtils.interpolate(elapsedFraction, startOffset.y * PatchworkProject.CARD_SIZE, endOffset.y * PatchworkProject.CARD_SIZE);
        return new Point((int)x, (int)y);
    }

    private void updateRenderBounds() {
        Rectangle4d outputBounds = this.getOutputBounds();
        if (this.currentImage == null || (double)this.currentImage.getWidth() != outputBounds.getWidth() || (double)this.currentImage.getHeight() != outputBounds.getHeight()) {
            this.currentImage = new BufferedImage((int)outputBounds.getWidth(), (int)outputBounds.getHeight(), 2);
        }
    }

    public static class Transcoder
    extends LocationLayerGraphic.Transcoder<SlideGraphic> {
        private static final String ELEMENT_NAME = "SlideGraphic";
        private static final String ATTR_GRAPHICS = "graphics";
        private static final String ATTR_TILE_SIZE = "tileSize";
        private static final String ATTR_START_OFFSET = "startOffset";
        private static final String ATTR_END_OFFSET = "endOffset";
        private static final String ATTR_DURATION = "durationInMillis";

        public Transcoder() {
            super(ELEMENT_NAME, SlideGraphic.class);
        }

        @Override
        protected void getAttributes(SlideGraphic object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_GRAPHICS, object.graphics.encode());
            if (object.startOffset != null) {
                destination.put(ATTR_START_OFFSET, StringUtils.encodePoint(object.startOffset));
            }
            if (object.endOffset != null) {
                destination.put(ATTR_END_OFFSET, StringUtils.encodePoint(object.endOffset));
            }
            if (object.tileSize != null) {
                destination.put(ATTR_TILE_SIZE, object.tileSize.encode());
            }
            destination.put(ATTR_DURATION, Integer.toString(object.durationInMillis));
        }

        @Override
        protected SlideGraphic decodeGraphic(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            SlideGraphic result = new SlideGraphic(id);
            result.graphics = new ReferenceList(result, attributes.get(ATTR_GRAPHICS));
            if (attributes.containsKey(ATTR_START_OFFSET)) {
                result.startOffset.setLocation(StringUtils.decodePoint(attributes.get(ATTR_START_OFFSET)));
            }
            if (attributes.containsKey(ATTR_END_OFFSET)) {
                result.endOffset.setLocation(StringUtils.decodePoint(attributes.get(ATTR_END_OFFSET)));
            }
            if (attributes.containsKey(ATTR_DURATION)) {
                result.durationInMillis = Integer.parseInt(attributes.get(ATTR_DURATION));
            }
            if (attributes.containsKey(ATTR_TILE_SIZE)) {
                result.tileSize = new GridCoords(attributes.get(ATTR_TILE_SIZE));
            }
            return result;
        }
    }
}

