/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.graphic;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerProperties;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.HoleGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LayeredImageGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LinkedGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.MotionKeyframesGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.PlayListEntry;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.ShadowGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.SlideGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.SpriteSequenceGraphic;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.Icon;

public class PlayListGraphic
extends LocationLayerGraphic {
    public static final Icon ICON = IconLoader.loadIcon("silk/shape_align_left.png");
    public static final Icon SINGLETON_ICON = IconLoader.loadIcon("custom/shape_align_left_single.png");
    public static final Icon PICTURE_ICON = IconLoader.loadIcon("custom/picture_align_left.png");
    private final List<LocationLayerGraphic> graphics;
    private final List<PlayListEntry> entries;
    private PlaybackMode playbackMode = PlaybackMode.SEQUENTIAL;
    private boolean playbackSampled;
    private float playbackSamplesPerSecond = 12.0f;
    private final List<Range<Float>> fractionalRanges;
    private int totalDurationMillis = 0;
    private boolean updateRangesNeeded = true;
    private BufferedImage currentImage;
    private List<BufferedImage> sampledFrames;

    public PlayListGraphic(String id) {
        this(id, new PlayListEntry(UUID.randomUUID().toString()));
    }

    public List<PlayListEntry> getEntries() {
        return this.entries;
    }

    public void addEntry(PlayListEntry entry) {
        this.addEntry(entry, true);
    }

    public void addEntry(PlayListEntry entry, int index) {
        this.addEntry(entry, index, true);
    }

    public void addEntry() {
        this.addEntry(new PlayListEntry(UUID.randomUUID().toString()));
    }

    public void removeEntry(PlayListEntry entry) {
        this.removeEntry(entry, true);
    }

    public void moveEntry(PlayListEntry entry, int newIndex) {
        if (this.entries.contains(entry)) {
            int oldIndex = this.entries.indexOf(entry);
            if (newIndex == oldIndex) {
                return;
            }
            this.removeEntry(entry);
            this.addEntry(entry, newIndex);
        }
    }

    public PlaybackMode getPlaybackMode() {
        return this.playbackMode;
    }

    public void setPlaybackMode(PlaybackMode playbackMode) {
        this.playbackMode = playbackMode;
        this.fireModified();
    }

    public boolean isPlaybackSampled() {
        return this.playbackSampled;
    }

    public void setPlaybackSampled(boolean playbackSampled) {
        this.playbackSampled = playbackSampled;
        this.fireModified();
    }

    public float getPlaybackSamplesPerSecond() {
        return this.playbackSamplesPerSecond;
    }

    public void setPlaybackSamplesPerSecond(float playbackSamplesPerSecond) {
        this.playbackSamplesPerSecond = playbackSamplesPerSecond;
        this.fireModified();
    }

    public void saveSamples() {
        File snapshotDir = PatchworkComposerProperties.getIODirectory(IOFileType.SNAPSHOT);
        DecimalFormat indexFormat = new DecimalFormat("000");
        List<BufferedImage> samples = this.getSamples();
        int index = 0;
        for (BufferedImage sample : samples) {
            String filename = this.getID() + indexFormat.format(index) + ".png";
            try {
                ImageUtils.saveImage(sample, new File(snapshotDir, filename));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++index;
        }
    }

    @Override
    public void addChildComponent(String id, Class<? extends ProjectComponent> type) {
        LocationLayerGraphic graphic;
        if (LocationLayerGraphic.class.isAssignableFrom(type) && (graphic = LocationLayerGraphic.newInstanceForID(id, type)) != null) {
            this.addGraphic(graphic, true);
        }
    }

    @Override
    public void addChildComponent(ProjectComponent child, int insertIndex) {
        if (child instanceof LocationLayerGraphic) {
            this.addGraphic((LocationLayerGraphic)child, insertIndex, true);
        }
    }

    @Override
    public void removeChildComponent(ProjectComponent child) {
        if (child instanceof LocationLayerGraphic) {
            this.removeGraphic((LocationLayerGraphic)child, true);
        }
    }

    @Override
    public boolean isAnimated() {
        return true;
    }

    @Override
    public BufferedImage getImageImpl(float elapsedFraction, boolean doScale) {
        boolean published;
        this.updateRanges();
        if (this.getDurationInMillis() == 0) {
            elapsedFraction = 0.0f;
        }
        if ((published = this.getAncestorByType(PatchworkProject.class).isPublished()) && this.playbackSampled) {
            if (this.sampledFrames == null) {
                this.sampledFrames = this.getSamples();
            }
            int lastFrameIndex = this.sampledFrames.size() - 1;
            lastFrameIndex = Math.max(lastFrameIndex, 0);
            float frameIndexFloat = elapsedFraction * (float)(lastFrameIndex + 1);
            int frameIndex = (int)MathUtils.clamp(Math.floor(frameIndexFloat), 0.0, (double)lastFrameIndex);
            return this.sampledFrames.get(frameIndex);
        }
        return this.getImageUnsampled(elapsedFraction);
    }

    @Override
    protected Point getAdditionalOffset(float elapsedFraction) {
        this.updateRanges();
        if (this.getDurationInMillis() == 0) {
            elapsedFraction = 0.0f;
        }
        List<PlayListEntry> entries = this.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            Range<Float> fractionalRange = this.fractionalRanges.get(i);
            if (!(elapsedFraction >= fractionalRange.getMin().floatValue()) || !(elapsedFraction <= fractionalRange.getMax().floatValue())) continue;
            PlayListEntry entry = entries.get(i);
            float entryFraction = (float)MathUtils.rangeFraction(elapsedFraction, fractionalRange.getMin().floatValue(), fractionalRange.getMax().floatValue());
            return entry.getAdditionalOffset(entryFraction);
        }
        return null;
    }

    @Override
    public int getDurationInMillis() {
        this.updateRanges();
        return this.totalDurationMillis;
    }

    @Override
    public Rectangle4d getMarginsRegion() {
        Rectangle4d margins = super.getMarginsRegion(false);
        if (margins != null) {
            return margins;
        }
        PlayListEntry entry = CollectionUtils.first(this.entries);
        if (entry == null) {
            return super.getMarginsRegion();
        }
        LocationLayerGraphic graphic = entry.getGraphic();
        if (graphic == null) {
            return super.getMarginsRegion();
        }
        return graphic.getMarginsRegion();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Icon getIcon() {
        if (this.entries.size() == 1) {
            PlayListEntry entry = this.entries.get(0);
            return entry.getStartFraction() == entry.getEndFraction() ? PICTURE_ICON : SINGLETON_ICON;
        }
        return ICON;
    }

    @Override
    protected void descendantModified(List<ProjectComponent> modifiedPath) {
        this.updateRangesNeeded = true;
    }

    @Override
    public void preload() {
        if (this.playbackSampled) {
            this.sampledFrames = this.getSamples();
        }
    }

    private PlayListGraphic(String id, PlayListEntry firstEntry) {
        super(id);
        this.graphics = new ArrayList<LocationLayerGraphic>();
        this.entries = new ArrayList<PlayListEntry>();
        this.fractionalRanges = new ArrayList<Range<Float>>();
        if (firstEntry != null) {
            this.addEntry(firstEntry, false);
        }
    }

    private void addEntry(PlayListEntry entry, boolean notify) {
        this.entries.add(entry);
        this.registerChild(entry, false, notify);
    }

    private void addEntry(PlayListEntry entry, int index, boolean notify) {
        if (index >= this.entries.size()) {
            this.entries.add(entry);
        } else {
            this.entries.add(index, entry);
        }
        this.registerChild(entry, false, notify);
    }

    private void removeEntry(PlayListEntry entry, boolean notify) {
        this.entries.remove(entry);
        this.removeChild(entry, notify);
    }

    private void addGraphic(LocationLayerGraphic graphic, boolean notify) {
        this.graphics.add(graphic);
        this.registerChild(graphic, notify);
    }

    private void addGraphic(LocationLayerGraphic graphic, int index, boolean notify) {
        if (index < 0 || index > this.graphics.size()) {
            this.graphics.add(graphic);
        } else {
            this.graphics.add(index, graphic);
        }
        this.registerChild(graphic, notify);
    }

    private void removeGraphic(LocationLayerGraphic graphic, boolean notify) {
        this.graphics.remove(graphic);
        this.removeChild(graphic, notify);
    }

    private BufferedImage getImageUnsampled(float elapsedFraction) {
        BufferedImage result = null;
        this.updateRenderBounds();
        result = this.currentImage;
        Graphics2D g = (Graphics2D)this.currentImage.getGraphics();
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(0, 0, this.currentImage.getWidth(), this.currentImage.getHeight());
        g.setComposite(AlphaComposite.SrcOver);
        List<PlayListEntry> entries = this.getEntries();
        Rectangle4d outputBounds = this.getOutputBounds();
        for (int i = 0; i < entries.size(); ++i) {
            boolean holdTillEnd;
            Range<Float> fractionalRange = this.fractionalRanges.get(i);
            PlayListEntry entry = entries.get(i);
            Rectangle4d entryBounds = entry.getOutputBounds();
            BufferedImage entryImage = null;
            float alpha = 1.0f;
            boolean bl = holdTillEnd = entry.isHoldIndefinite() && this.playbackMode == PlaybackMode.LAYERED;
            if (elapsedFraction >= fractionalRange.getMin().floatValue() && (elapsedFraction <= fractionalRange.getMax().floatValue() || holdTillEnd)) {
                float entryFraction = (float)MathUtils.rangeFraction(elapsedFraction, fractionalRange.getMin().floatValue(), fractionalRange.getMax().floatValue());
                entryFraction = MathUtils.clamp(entryFraction, 0.0f, 1.0f);
                entryImage = entry.getImage(entryFraction);
                alpha = entry.getAlpha(entryFraction);
            }
            if (entryImage == null) continue;
            AffineTransform entryTransform = new AffineTransform();
            if (entryBounds != null) {
                entryTransform.translate(entryBounds.getX() - outputBounds.getX(), entryBounds.getY() - outputBounds.getY());
            }
            Point currentOffset = entry.getCurrentOffset(elapsedFraction);
            entryTransform.translate(currentOffset.x, currentOffset.y);
            g.setComposite(AlphaComposite.getInstance(3, alpha));
            if (this.playbackMode == PlaybackMode.SEQUENTIAL) {
                g.drawImage(entryImage, entryTransform, null);
                break;
            }
            if (g == null) continue;
            g.drawImage(entryImage, entryTransform, null);
        }
        if (g != null) {
            g.dispose();
        }
        return result;
    }

    private void updateRanges() {
        if (!this.updateRangesNeeded) {
            return;
        }
        this.fractionalRanges.clear();
        this.totalDurationMillis = 0;
        ArrayList<Range<Integer>> rangesInMillis = new ArrayList<Range<Integer>>();
        for (PlayListEntry playListEntry : this.getEntries()) {
            int startTimeMillis = this.playbackMode == PlaybackMode.SEQUENTIAL ? this.totalDurationMillis : 0;
            int endTimeMillis = startTimeMillis + playListEntry.getDurationMillis();
            rangesInMillis.add(new Range<Integer>(startTimeMillis, endTimeMillis));
            this.totalDurationMillis = this.playbackMode == PlaybackMode.SEQUENTIAL ? endTimeMillis : Math.max(this.totalDurationMillis, endTimeMillis);
        }
        for (Range range : rangesInMillis) {
            float startFraction = (float)MathUtils.rangeFraction(((Integer)range.getMin()).intValue(), 0.0, this.totalDurationMillis);
            float endFraction = (float)MathUtils.rangeFraction(((Integer)range.getMax()).intValue(), 0.0, this.totalDurationMillis);
            this.fractionalRanges.add(new Range<Float>(Float.valueOf(startFraction), Float.valueOf(endFraction)));
        }
        this.updateRangesNeeded = false;
    }

    private void updateRenderBounds() {
        Rectangle4d outputBounds = this.getOutputBounds();
        if (this.currentImage == null || (double)this.currentImage.getWidth() != outputBounds.getWidth() || (double)this.currentImage.getHeight() != outputBounds.getHeight()) {
            this.currentImage = new BufferedImage((int)outputBounds.getWidth(), (int)outputBounds.getHeight(), 2);
        }
    }

    private List<BufferedImage> getSamples() {
        ArrayList<BufferedImage> result = new ArrayList<BufferedImage>();
        int durationInMillis = this.getDurationInMillis();
        int sampleFrames = (int)((double)durationInMillis / 1000.0 * (double)this.playbackSamplesPerSecond);
        float sampleStepSize = 1.0f / (float)sampleFrames;
        ArrayList<Float> sampleFractions = new ArrayList<Float>();
        for (float f = 0.0f; f < 1.0f; f += sampleStepSize) {
            sampleFractions.add(Float.valueOf(f));
        }
        sampleFractions.add(Float.valueOf(1.0f));
        Rectangle4d outputBounds = this.getOutputBounds();
        for (int i = 0; i < sampleFractions.size(); ++i) {
            float fraction = ((Float)sampleFractions.get(i)).floatValue();
            BufferedImage frameImage = new BufferedImage((int)outputBounds.getWidth(), (int)outputBounds.getHeight(), 2);
            BufferedImage currentImage = this.getImageUnsampled(fraction);
            Graphics2D g = frameImage.createGraphics();
            g.drawImage((Image)currentImage, 0, 0, null);
            g.dispose();
            result.add(frameImage);
        }
        return result;
    }

    public static class Transcoder
    extends LocationLayerGraphic.Transcoder<PlayListGraphic> {
        private static final String ELEMENT_NAME = "PlayListGraphic";
        private static final String FIELD_ENTRIES = "entries";
        private static final String FIELD_GRAPHICS = "graphics";
        private static final String ATTR_PLAYBACK_MODE = "playbackMode";
        private static final String ATTR_PLAYBACK_SAMPLED = "playbackSampled";
        private static final String ATTR_SAMPLES_PER_SECOND = "samplesPerSecond";

        public Transcoder() {
            super(ELEMENT_NAME, PlayListGraphic.class);
            this.setFieldTranscoder(FIELD_ENTRIES, new PlayListEntry.Transcoder());
            this.setFieldTranscoder(FIELD_GRAPHICS, new SpriteSequenceGraphic.Transcoder(), new MotionKeyframesGraphic.Transcoder(), new LayeredImageGraphic.Transcoder(), new HoleGraphic.Transcoder(), new LinkedGraphic.Transcoder(), new SlideGraphic.Transcoder(), new ShadowGraphic.Transcoder(), this);
        }

        @Override
        protected void getAttributes(PlayListGraphic object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_PLAYBACK_MODE, object.playbackMode.name());
            destination.put(ATTR_PLAYBACK_SAMPLED, Boolean.toString(object.playbackSampled));
            destination.put(ATTR_SAMPLES_PER_SECOND, Float.toString(object.playbackSamplesPerSecond));
        }

        @Override
        protected void getChildren(PlayListGraphic object, MultiMap<String, Object> destination) {
            for (PlayListEntry entry : object.getEntries()) {
                destination.putLast(FIELD_ENTRIES, entry);
            }
            for (LocationLayerGraphic graphic : object.graphics) {
                destination.putLast(FIELD_GRAPHICS, graphic);
            }
        }

        @Override
        protected PlayListGraphic decodeGraphic(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            PlayListGraphic result = new PlayListGraphic(id, null);
            for (Object entry : decodedChildren.getAll(FIELD_ENTRIES)) {
                result.addEntry((PlayListEntry)entry, false);
            }
            List<Object> graphics = decodedChildren.getAll(FIELD_GRAPHICS);
            for (int i = 0; i < graphics.size(); ++i) {
                result.addGraphic((LocationLayerGraphic)graphics.get(i), false);
            }
            if (attributes.containsKey(ATTR_PLAYBACK_MODE)) {
                result.playbackMode = PlaybackMode.valueOf(attributes.get(ATTR_PLAYBACK_MODE));
            }
            if (attributes.containsKey(ATTR_PLAYBACK_SAMPLED)) {
                result.playbackSampled = (boolean)Boolean.valueOf(attributes.get(ATTR_PLAYBACK_SAMPLED));
            }
            if (attributes.containsKey(ATTR_SAMPLES_PER_SECOND)) {
                result.playbackSamplesPerSecond = Float.valueOf(attributes.get(ATTR_SAMPLES_PER_SECOND)).floatValue();
            }
            return result;
        }
    }

    public static enum PlaybackMode {
        SEQUENTIAL{

            public String toString() {
                return "Sequential";
            }
        }
        ,
        LAYERED{

            public String toString() {
                return "Layered";
            }
        };

    }
}

