/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.graphic;

import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.PlayListGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridCoords;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;

public class PlayListEntry
extends ProjectComponent {
    private Reference<LocationLayerGraphic> graphic = new Reference();
    private float startFraction = 0.0f;
    private float endFraction = 1.0f;
    private int startDelayMillis;
    private int holdAtStartMillis;
    private int holdAtEndMillis;
    private float durationScale = 1.0f;
    private float fadeInFraction = 0.0f;
    private float fadeOutFraction = 0.0f;

    public PlayListEntry(String id) {
        super(id);
    }

    public float getStartFraction() {
        return this.startFraction;
    }

    public void setStartFraction(float startFraction) {
        this.startFraction = Math.max(startFraction, 0.0f);
        this.fireModified();
    }

    public float getEndFraction() {
        return this.endFraction;
    }

    public void setEndFraction(float endFraction) {
        this.endFraction = Math.max(endFraction, 0.0f);
        this.fireModified();
    }

    public int getStartDelayMillis() {
        return this.startDelayMillis;
    }

    public float getDurationScale() {
        return this.durationScale;
    }

    public void setDurationScale(float durationScale) {
        this.durationScale = durationScale;
        this.fireModified();
    }

    public void setStartDelayMillis(int startDelayMillis) {
        this.startDelayMillis = startDelayMillis;
        this.fireModified();
    }

    public int getHoldAtStartMillis() {
        return this.holdAtStartMillis;
    }

    public void setHoldAtStartMillis(int holdAtStartMillis) {
        this.holdAtStartMillis = holdAtStartMillis;
        this.fireModified();
    }

    public int getHoldAtEndMillis() {
        return this.holdAtEndMillis;
    }

    public void setHoldAtEndMillis(int holdAtEndMillis) {
        this.holdAtEndMillis = holdAtEndMillis < 0 ? -1 : holdAtEndMillis;
        this.fireModified();
    }

    public boolean isHoldIndefinite() {
        return this.holdAtEndMillis < 0;
    }

    public float getFadeInFraction() {
        return this.fadeInFraction;
    }

    public void setFadeInFraction(float fadeInFraction) {
        this.fadeInFraction = fadeInFraction;
        this.fireModified();
    }

    public float getFadeOutFraction() {
        return this.fadeOutFraction;
    }

    public void setFadeOutFraction(float fadeOutFraction) {
        this.fadeOutFraction = fadeOutFraction;
        this.fireModified();
    }

    public LocationLayerGraphic getGraphic() {
        return this.graphic.resolve();
    }

    public void setGraphic(LocationLayerGraphic graphic) {
        this.graphic = new Reference<LocationLayerGraphic>((ProjectComponent)this, graphic);
        this.fireModified();
    }

    public int getDurationMillis() {
        int intrinsicDurationMillis;
        LocationLayerGraphic graphic = this.getGraphic();
        if (graphic == null) {
            intrinsicDurationMillis = 0;
        } else if (graphic.isAnimated()) {
            int naturalDuration;
            float elapsedCycles = Math.abs(this.getEndFraction() - this.getStartFraction());
            intrinsicDurationMillis = naturalDuration = (int)(elapsedCycles * (float)graphic.getDurationInMillis() * this.durationScale);
        } else {
            intrinsicDurationMillis = 0;
        }
        return this.startDelayMillis + this.holdAtStartMillis + intrinsicDurationMillis + Math.max(this.holdAtEndMillis, 0);
    }

    public BufferedImage getImage(float elapsedFraction) {
        float startDelayFraction;
        LocationLayerGraphic graphic = this.getGraphic();
        if (graphic == null) {
            return null;
        }
        if (this.startDelayMillis > 0 && elapsedFraction < (startDelayFraction = (float)this.startDelayMillis / (float)this.getDurationMillis())) {
            return null;
        }
        float graphicFraction = this.getGraphicFraction(elapsedFraction);
        return graphic.getImage(graphicFraction);
    }

    public float getAlpha(float elapsedFraction) {
        float fraction = elapsedFraction;
        if (this.startDelayMillis > 0) {
            float totalDurationMillis = this.getDurationMillis();
            float startFraction = (float)this.startDelayMillis / totalDurationMillis;
            fraction = (float)MathUtils.clamp(MathUtils.rangeFraction(fraction, startFraction, 1.0), 0.0, 1.0);
        }
        float fadeInFraction = this.getFadeInFraction();
        float fadeOutFraction = this.getFadeOutFraction();
        if (fadeInFraction > 0.0f && fraction < fadeInFraction) {
            return (float)MathUtils.rangeFraction(fraction, 0.0, fadeInFraction);
        }
        if (!this.isHoldIndefinite() && fadeOutFraction > 0.0f && 1.0f - fraction < fadeOutFraction) {
            return (float)MathUtils.clamp(MathUtils.rangeFraction(fraction, 1.0, 1.0f - fadeOutFraction), 0.0, 1.0);
        }
        return 1.0f;
    }

    public Point getAdditionalOffset(float elapsedFraction) {
        LocationLayerGraphic graphic = this.getGraphic();
        if (graphic == null) {
            return null;
        }
        return graphic.getAdditionalOffset(this.getGraphicFraction(elapsedFraction));
    }

    public Point getCurrentOffset(float elapsedFraction) {
        LocationLayerGraphic graphic = this.getGraphic();
        if (graphic == null) {
            return null;
        }
        return graphic.getCurrentOffset(GridCoords.ORIGIN, this.getGraphicFraction(elapsedFraction));
    }

    public Rectangle4d getOutputBounds() {
        LocationLayerGraphic graphic = this.getGraphic();
        if (graphic == null) {
            return null;
        }
        return graphic.getOutputBounds();
    }

    @Override
    public Icon getIcon() {
        return PlayListGraphic.ICON;
    }

    private float getGraphicFraction(float elapsedFraction) {
        float animStartFraction = 0.0f;
        float animEndFraction = 1.0f;
        float totalDurationMillis = this.getDurationMillis();
        if (this.startDelayMillis > 0) {
            float startDelayFraction = (float)this.startDelayMillis / totalDurationMillis;
            if (elapsedFraction < startDelayFraction) {
                return 0.0f;
            }
            animStartFraction = startDelayFraction;
        }
        if (this.holdAtStartMillis > 0) {
            float holdAtStartFraction = (float)(this.startDelayMillis + this.holdAtStartMillis) / totalDurationMillis;
            if (elapsedFraction <= holdAtStartFraction) {
                return this.getWrappedFraction(this.startFraction);
            }
            animStartFraction = holdAtStartFraction;
        }
        if (this.holdAtEndMillis > 0 && elapsedFraction >= (animEndFraction -= (float)this.holdAtEndMillis / totalDurationMillis)) {
            return this.getWrappedFraction(this.endFraction);
        }
        float animFraction = (float)MathUtils.rangeFraction(elapsedFraction, animStartFraction, animEndFraction);
        float unwrappedFraction = (float)MathUtils.interpolate(animFraction, this.startFraction, this.endFraction);
        return this.getWrappedFraction(unwrappedFraction);
    }

    private float getWrappedFraction(float unwrappedFraction) {
        float wrappedFraction = (unwrappedFraction = Math.max(0.0f, unwrappedFraction)) % 1.0f;
        if (wrappedFraction == 0.0f && unwrappedFraction >= 1.0f) {
            return 1.0f;
        }
        return wrappedFraction;
    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<PlayListEntry> {
        private static final String ELEMENT_NAME = "PlayListEntry";
        private static final String ATTR_DEST = "graphic";
        private static final String ATTR_START_FRACTION = "startFraction";
        private static final String ATTR_END_FRACTION = "endFraction";
        private static final String ATTR_DURATION_SCALE = "durationScale";
        private static final String ATTR_START_DELAY = "startDelayMillis";
        private static final String ATTR_HOLD_AT_START = "holdAtStartMillis";
        private static final String ATTR_HOLD_AT_END = "holdAtEndMillis";
        private static final String ATTR_FADE_IN_FRACTION = "fadeInFraction";
        private static final String ATTR_FADE_OUT_FRACTION = "fadeOutFraction";

        public Transcoder() {
            super(ELEMENT_NAME, PlayListEntry.class);
        }

        @Override
        protected void getAttributes(PlayListEntry object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_DEST, object.graphic.encode());
            destination.put(ATTR_START_FRACTION, Float.toString(object.startFraction));
            destination.put(ATTR_END_FRACTION, Float.toString(object.endFraction));
            destination.put(ATTR_DURATION_SCALE, Float.toString(object.durationScale));
            destination.put(ATTR_START_DELAY, Integer.toString(object.startDelayMillis));
            destination.put(ATTR_HOLD_AT_START, Integer.toString(object.holdAtStartMillis));
            destination.put(ATTR_HOLD_AT_END, Integer.toString(object.holdAtEndMillis));
            destination.put(ATTR_FADE_IN_FRACTION, Float.toString(object.fadeInFraction));
            destination.put(ATTR_FADE_OUT_FRACTION, Float.toString(object.fadeOutFraction));
        }

        @Override
        protected final PlayListEntry decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            PlayListEntry result = new PlayListEntry(id);
            result.graphic = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_DEST));
            if (attributes.containsKey(ATTR_START_FRACTION)) {
                result.startFraction = Float.valueOf(attributes.get(ATTR_START_FRACTION)).floatValue();
            }
            if (attributes.containsKey(ATTR_END_FRACTION)) {
                result.endFraction = Float.valueOf(attributes.get(ATTR_END_FRACTION)).floatValue();
            }
            if (attributes.containsKey(ATTR_DURATION_SCALE)) {
                result.durationScale = Float.valueOf(attributes.get(ATTR_DURATION_SCALE)).floatValue();
            }
            if (attributes.containsKey(ATTR_START_DELAY)) {
                result.startDelayMillis = Integer.valueOf(attributes.get(ATTR_START_DELAY));
            }
            if (attributes.containsKey(ATTR_HOLD_AT_START)) {
                result.holdAtStartMillis = Integer.valueOf(attributes.get(ATTR_HOLD_AT_START));
            }
            if (attributes.containsKey(ATTR_HOLD_AT_END)) {
                result.holdAtEndMillis = Integer.valueOf(attributes.get(ATTR_HOLD_AT_END));
            }
            if (attributes.containsKey(ATTR_FADE_IN_FRACTION)) {
                result.fadeInFraction = Float.valueOf(attributes.get(ATTR_FADE_IN_FRACTION)).floatValue();
            }
            if (attributes.containsKey(ATTR_FADE_OUT_FRACTION)) {
                result.fadeOutFraction = Float.valueOf(attributes.get(ATTR_FADE_OUT_FRACTION)).floatValue();
            }
            return result;
        }
    }
}

