/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.graphic;

import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.AnimatableTransform;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraph;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraphNode;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.render.scenegraph.TransformAnimator;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.GeometricAxis;
import com.sodiumarc.patchwork.util.MathUtils;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class MotionKeyframes {
    public static final String KF_NODE_SUFFIX = "KF";
    public static final Pattern KF_NODE_PATTERN = Pattern.compile(".*KF[0-9]*");
    public static final String PIVOT_NODE_SUFFIX = "PVT";
    private AnimatableTransform animatableTransform;
    private final Point3d startingPosition;
    private final Point3d endingPosition;
    private final Map<GeometricAxis, Double> startingAngles;
    private final Map<GeometricAxis, Double> endingAngles;
    private final Vector3d startingScale;
    private final Vector3d endingScale;
    private double maxKeyframe = 0.0;
    private final String animationNodeName;
    private final Point3d pivotGlobalLocation;
    private final PolyMesh3D pivotMesh;
    private final Vector3d pivotMeshScale;
    private static final Logger LOGGER = Logger.getLogger(MotionKeyframes.class);

    public MotionKeyframes(SceneGraph sceneGraph, String animationNodeName) {
        this.animationNodeName = animationNodeName;
        this.startingAngles = new EnumMap<GeometricAxis, Double>(GeometricAxis.class);
        this.endingAngles = new EnumMap<GeometricAxis, Double>(GeometricAxis.class);
        this.startingPosition = new Point3d();
        this.endingPosition = new Point3d();
        this.startingScale = new Vector3d(1.0, 1.0, 1.0);
        this.endingScale = new Vector3d(1.0, 1.0, 1.0);
        this.pivotMeshScale = new Vector3d(1.0, 1.0, 1.0);
        if (sceneGraph == null || animationNodeName == null) {
            this.animatableTransform = null;
        } else {
            Set<SceneGraphNode> nodes = sceneGraph.getNodes(animationNodeName);
            SceneGraphNode node = CollectionUtils.first(nodes);
            AnimatableTransform animatableTransform = this.animatableTransform = node == null ? null : node.getAnimatableTransform();
        }
        if (this.animatableTransform == null) {
            throw new IllegalArgumentException("Invalid animation node name");
        }
        SceneGraphNode pivotNode = this.getPivotNode(sceneGraph, animationNodeName);
        if (pivotNode != null) {
            this.pivotGlobalLocation = new Point3d();
            Transform3D xform = pivotNode.getCumulativeTransform();
            xform.getScale(this.pivotMeshScale);
            xform.transform(this.pivotGlobalLocation);
            Map<String, PolyMesh3D> meshes = pivotNode.getMeshesInGlobalCoords();
            this.pivotMesh = CollectionUtils.first(meshes.values());
        } else {
            this.pivotGlobalLocation = null;
            this.pivotMesh = null;
        }
        this.maxKeyframe = 0.0;
        block5: for (AnimatableTransform.Channel channel : AnimatableTransform.Channel.values()) {
            TransformAnimator animator = this.getKeyframes(channel);
            if (animator == null) continue;
            if (!animator.isNormalized()) {
                this.maxKeyframe = Math.max(this.maxKeyframe, animator.getLastKeyframe());
            }
            switch (channel) {
                case TRANSLATION: {
                    this.startingPosition.set((Vector3d)animator.getValueAt(0.0));
                    this.endingPosition.set((Vector3d)animator.getValueAt(animator.getLastKeyframe()));
                    continue block5;
                }
                case X_ROTATION: 
                case Y_ROTATION: 
                case Z_ROTATION: {
                    this.getRotation(channel, 0.0f, this.startingAngles);
                    this.getRotation(channel, 1.0f, this.endingAngles);
                    continue block5;
                }
                case SCALE: {
                    this.getScale(0.0f, this.startingScale);
                    this.getScale(1.0f, this.endingScale);
                }
            }
        }
    }

    public void printKeyframes(AnimatableTransform.Channel channel) {
        TransformAnimator positionKeyframes = this.getKeyframes(channel);
        if (positionKeyframes != null) {
            for (Double time : positionKeyframes.getKeyframes()) {
                System.out.println(String.format("%f : %s", time, positionKeyframes.getValueAt(time)));
            }
        }
    }

    public double getMaxKeyframe() {
        return this.maxKeyframe;
    }

    public int getPositionKeyframeCount() {
        return this.getKeyframeCount(AnimatableTransform.Channel.TRANSLATION);
    }

    public Point3d getStartingPosition() {
        return this.startingPosition;
    }

    public Point3d getEndingPosition() {
        return this.endingPosition;
    }

    public double getStartingAngle(GeometricAxis axis) {
        return this.startingAngles.get((Object)axis);
    }

    public double getEndingAngle(GeometricAxis axis) {
        return this.endingAngles.get((Object)axis);
    }

    public int getScaleKeyframeCount() {
        return this.getKeyframeCount(AnimatableTransform.Channel.SCALE);
    }

    public Vector3d getStartingScale() {
        return this.startingScale;
    }

    public Vector3d getEndingScale() {
        return this.endingScale;
    }

    public void getPosition(float elapsedFraction, Point3d position) {
        TransformAnimator translationAnimator = this.getKeyframes(AnimatableTransform.Channel.TRANSLATION);
        if (translationAnimator != null) {
            position.set((Tuple3d)this.getValueAt(translationAnimator, elapsedFraction));
        } else {
            position.set(0.0, 0.0, 0.0);
        }
    }

    public void getRotation(float elapsedFraction, Map<GeometricAxis, Double> angles) {
        this.getRotation(AnimatableTransform.Channel.X_ROTATION, elapsedFraction, angles);
        this.getRotation(AnimatableTransform.Channel.Y_ROTATION, elapsedFraction, angles);
        this.getRotation(AnimatableTransform.Channel.Z_ROTATION, elapsedFraction, angles);
    }

    public void getRotation(AnimatableTransform.Channel channel, float elapsedFraction, Map<GeometricAxis, Double> angles) {
        GeometricAxis axis = null;
        switch (channel) {
            case X_ROTATION: {
                axis = GeometricAxis.X;
                break;
            }
            case Y_ROTATION: {
                axis = GeometricAxis.Y;
                break;
            }
            case Z_ROTATION: {
                axis = GeometricAxis.Z;
                break;
            }
        }
        TransformAnimator rotationAnimator = this.getKeyframes(channel);
        if (rotationAnimator == null) {
            angles.put(axis, 0.0);
        } else {
            Double angleInDegrees = (Double)this.getValueAt(rotationAnimator, elapsedFraction);
            if (!LOGGER.isDebugEnabled() || axis == GeometricAxis.Y) {
                // empty if block
            }
            angles.put(axis, Math.toRadians(angleInDegrees));
        }
    }

    public void getScale(float elapsedFraction, Tuple3d destination) {
        TransformAnimator scaleAnimator = this.getKeyframes(AnimatableTransform.Channel.SCALE);
        if (scaleAnimator != null) {
            Vector3d scale = (Vector3d)this.getValueAt(scaleAnimator, elapsedFraction);
            destination.setX(Math.abs(scale.getX()) / this.pivotMeshScale.getX());
            destination.setY(Math.abs(scale.getY()) / this.pivotMeshScale.getY());
            destination.setZ(Math.abs(scale.getZ()) / this.pivotMeshScale.getZ());
        } else {
            destination.set(1.0, 1.0, 1.0);
        }
    }

    public Point3d getPivotGlobalLocation() {
        return this.pivotGlobalLocation;
    }

    public PolyMesh3D getPivotMesh() {
        return this.pivotMesh;
    }

    public int getKeyframeCount(AnimatableTransform.Channel channel) {
        TransformAnimator animator = this.getKeyframes(channel);
        if (animator == null) {
            return 0;
        }
        return animator.getKeyframes().size();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.animationNodeName + "]";
    }

    private SceneGraphNode getPivotNode(SceneGraph sceneGraph, String animationNodeName) {
        String pivotNodeName = this.getPivotNodeName(animationNodeName);
        if (pivotNodeName == null) {
            return null;
        }
        return CollectionUtils.first(sceneGraph.getNodes(pivotNodeName));
    }

    private String getPivotNodeName(String animationNodeName) {
        if (!KF_NODE_PATTERN.matcher(animationNodeName).matches()) {
            return null;
        }
        int suffixStart = animationNodeName.lastIndexOf(KF_NODE_SUFFIX);
        String stem = animationNodeName.substring(0, suffixStart);
        return stem + PIVOT_NODE_SUFFIX;
    }

    private <T> TransformAnimator<T> getKeyframes(AnimatableTransform.Channel channel) {
        if (this.animatableTransform == null) {
            return null;
        }
        return this.animatableTransform.getAnimator(channel);
    }

    private <T> T getValueAt(TransformAnimator<T> animator, float elapsedFraction) {
        if (animator.isNormalized()) {
            return animator.getValueAt(elapsedFraction);
        }
        return animator.getValueAt(MathUtils.interpolate(elapsedFraction, 0.0, this.maxKeyframe));
    }
}

