/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.graphic;

import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerProperties;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.ReferenceList;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.HoleGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.InterpFunction;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LayeredImageGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LinkedGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.MotionKeyframesGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.PlayListGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.ShadowGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.SlideGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.SpriteSequenceGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.AbstractViewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.Viewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridCoords;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class LocationLayerGraphic
extends ProjectComponent {
    private Rectangle4d marginsRegion;
    private boolean isMovingWindow;
    private boolean tracksCamera;
    private final Point sourceGridOffset;
    private final Point sourcePixelOffset;
    private boolean flipHorizontal;
    private boolean flipVertical;
    private Reference<AbstractViewpoint> overrideViewpoint;
    private boolean interactiveWhenAnimating;
    private InterpFunction interpFunction = InterpFunction.NONE;
    private Color hazeColor = Color.WHITE;
    private float hazeAmount = 0.0f;
    private float marginFade = 0.0f;
    private ReferenceList<SceneLayerState> attachedStates = new ReferenceList();
    private float lastElapsedFraction = -1.0f;
    private BufferedImage finalCacheImage;
    private BufferedImage blankImage;

    public static LocationLayerGraphic newInstanceForID(String id, Class<? extends ProjectComponent> type) {
        if (type.equals(SpriteSequenceGraphic.class)) {
            return new SpriteSequenceGraphic(id);
        }
        if (type.equals(MotionKeyframesGraphic.class)) {
            return new MotionKeyframesGraphic(id);
        }
        if (type.equals(LayeredImageGraphic.class)) {
            return new LayeredImageGraphic(id);
        }
        if (type.equals(PlayListGraphic.class)) {
            return new PlayListGraphic(id);
        }
        if (type.equals(HoleGraphic.class)) {
            return new HoleGraphic(id);
        }
        if (type.equals(LinkedGraphic.class)) {
            return new LinkedGraphic(id);
        }
        if (type.equals(SlideGraphic.class)) {
            return new SlideGraphic(id);
        }
        if (type.equals(ShadowGraphic.class)) {
            return new ShadowGraphic(id);
        }
        return null;
    }

    public LocationLayerGraphic(String id) {
        super(id);
        this.sourceGridOffset = new Point();
        this.sourcePixelOffset = new Point();
        this.overrideViewpoint = new Reference();
    }

    public boolean publish() {
        return false;
    }

    public void preload() {
    }

    public AlphaComposite getAlphaComposite() {
        return AlphaComposite.SrcOver;
    }

    public void setMarginsRegion(Rectangle4d renderRegion) {
        this.marginsRegion = renderRegion;
        this.fireModified(this.getPath());
    }

    public Rectangle4d getMarginsRegion() {
        return this.getMarginsRegion(true);
    }

    public Rectangle4d getMarginsRegion(boolean inheritFromScene) {
        if (this.marginsRegion != null) {
            return this.marginsRegion;
        }
        if (!inheritFromScene) {
            return null;
        }
        SceneLocation location = this.getAncestorByType(SceneLocation.class);
        if (location != null) {
            return location.getMarginsRegion();
        }
        return new Rectangle4d(0.0, 0.0, 1.0, 1.0);
    }

    public Rectangle4d getViewport(boolean includeMargins) {
        Rectangle4d baseViewport = this.getViewpoint().getViewport();
        return includeMargins ? baseViewport.fromProportional(this.getMarginsRegion()) : baseViewport;
    }

    public boolean isMovingWindow() {
        return this.isMovingWindow;
    }

    public void setMovingWindow(boolean isMovingWindow) {
        this.isMovingWindow = isMovingWindow;
        this.fireModified();
    }

    public Point getSourceGridOffset() {
        return this.sourceGridOffset;
    }

    public void setSourceGridOffset(Point sourceOffset) {
        this.sourceGridOffset.setLocation(sourceOffset);
        this.fireModified();
    }

    public Point getSourcePixelOffset() {
        return this.sourcePixelOffset;
    }

    public void setSourcePixelOffset(Point sourceOffset) {
        this.sourcePixelOffset.setLocation(sourceOffset);
        this.fireModified();
    }

    public Point getSourceTotalOffset() {
        Point sourceGridOffset = this.getSourceGridOffset();
        Point sourcePixelOffset = this.getSourcePixelOffset();
        return new Point(sourceGridOffset.x * PatchworkProject.CARD_SIZE + sourcePixelOffset.x, sourceGridOffset.y * PatchworkProject.CARD_SIZE + sourcePixelOffset.y);
    }

    public boolean isFlipHorizontal() {
        return this.flipHorizontal;
    }

    public void setFlipHorizontal(boolean flipHorizontal) {
        this.flipHorizontal = flipHorizontal;
        this.fireModified();
    }

    public boolean isFlipVertical() {
        return this.flipVertical;
    }

    public void setFlipVertical(boolean flipVertical) {
        this.flipVertical = flipVertical;
        this.fireModified();
    }

    public AbstractViewpoint getOverrideViewpoint() {
        return this.overrideViewpoint.resolve();
    }

    public void setOverrideViewpoint(AbstractViewpoint overrideViewpoint) {
        this.overrideViewpoint = new Reference<AbstractViewpoint>((ProjectComponent)this, overrideViewpoint);
        this.fireModified();
    }

    public InterpFunction getInterpFunction() {
        return this.interpFunction;
    }

    public void setInterpFunction(InterpFunction interpFunction) {
        this.interpFunction = interpFunction;
        this.fireModified();
    }

    public boolean isInteractiveWhenAnimating() {
        return this.interactiveWhenAnimating;
    }

    public void setInteractiveWhenAnimating(boolean interactiveWhenAnimating) {
        this.interactiveWhenAnimating = interactiveWhenAnimating;
        this.fireModified();
    }

    public Color getHazeColor() {
        return this.hazeColor;
    }

    public Color getHazeBlendColor() {
        int hazeAlpha = (int)(this.hazeAmount * 255.0f);
        return new Color(this.hazeColor.getRed(), this.hazeColor.getGreen(), this.hazeColor.getBlue(), hazeAlpha);
    }

    public void setHazeColor(Color hazeColor) {
        assert (hazeColor != null) : "hazeColor is null";
        this.hazeColor = hazeColor;
        this.fireModified();
    }

    public float getHazeAmount() {
        return this.hazeAmount;
    }

    public void setHazeAmount(float hazeAmount) {
        this.hazeAmount = hazeAmount;
        this.fireModified();
    }

    public float getMarginFade() {
        return this.marginFade;
    }

    public void setMarginFade(float marginFade) {
        this.marginFade = marginFade;
        this.fireModified();
    }

    public boolean tracksCamera() {
        return this.tracksCamera;
    }

    public void setTracksCamera(boolean isTrackCamera) {
        this.tracksCamera = isTrackCamera;
        this.fireModified();
    }

    public List<SceneLayerState> getAttachedStates() {
        return this.attachedStates.resolve();
    }

    public void clearAttachedStates() {
        this.attachedStates.resolve().clear();
        this.fireModified();
    }

    public void addAttachedState(SceneLayerState state) {
        this.attachedStates.resolve().add(state);
        this.fireModified();
    }

    public void removeAttachedState(SceneLayerState state) {
        this.attachedStates.resolve().remove(state);
        this.fireModified();
    }

    public abstract boolean isAnimated();

    public abstract boolean isEmpty();

    public final BufferedImage getImage(float elapsedFraction) {
        BufferedImage result;
        if (!(this.finalCacheImage == null || elapsedFraction != this.lastElapsedFraction && this.isAnimated())) {
            return this.finalCacheImage;
        }
        this.finalCacheImage = result = this.getImage(elapsedFraction, EnumSet.allOf(ImageEffect.class));
        this.lastElapsedFraction = elapsedFraction;
        return result;
    }

    public final BufferedImage getImage(float elapsedFraction, Set<ImageEffect> effects) {
        BufferedImage result = this.getImageImpl(this.interpFunction.getInterpFraction(elapsedFraction), effects.contains((Object)ImageEffect.SCALE_TO_OUTPUT));
        if (result == null) {
            if (this.hazeAmount > 0.0f && effects.contains((Object)ImageEffect.HAZE)) {
                return this.getHazeImage(this.getDestinationImage(), false);
            }
            return null;
        }
        if (effects.contains((Object)ImageEffect.FLIP)) {
            result = this.getFlippedImage(result);
        }
        if (effects.contains((Object)ImageEffect.HAZE)) {
            result = this.getHazeImage(result, true);
        }
        if (effects.contains((Object)ImageEffect.MARGIN_FADE)) {
            result = this.getMarginFadeImage(result);
        }
        return result;
    }

    public Viewpoint getViewpoint() {
        AbstractViewpoint overrideViewpoint = this.getOverrideViewpoint();
        if (overrideViewpoint != null) {
            return overrideViewpoint;
        }
        return this.getAncestorByType(SceneLocation.class).getViewpoint();
    }

    public abstract int getDurationInMillis();

    public final Point getCurrentOffset(GridCoords gridCoords, float elapsedFraction) {
        Point additionalOffset;
        Point result = this.getSourceTotalOffset();
        if (this.isMovingWindow) {
            int mwOffsetX = (int)Math.round((double)PatchworkProject.CARD_SIZE * -gridCoords.getColDouble());
            int mwOffsetY = (int)Math.round((double)PatchworkProject.CARD_SIZE * -gridCoords.getRowDouble());
            result.translate(mwOffsetX, mwOffsetY);
        }
        if ((additionalOffset = this.getAdditionalOffset(this.interpFunction.getInterpFraction(elapsedFraction))) != null) {
            result.translate(additionalOffset.x, additionalOffset.y);
        }
        return result;
    }

    public final Rectangle4d getOutputBounds() {
        return PatchworkProject.CARD_RECT.fromProportional(this.getMarginsRegion());
    }

    public final Dimension getOutputSize() {
        return this.getOutputBounds().getSize();
    }

    public void clearCacheImage() {
        this.finalCacheImage = null;
    }

    @Override
    protected void descendantModified(List<ProjectComponent> modifiedPath) {
        super.descendantModified(modifiedPath);
        this.clearCacheImage();
        this.lastElapsedFraction = -1.0f;
    }

    protected final BufferedImage getImageImpl(float elapsedFraction) {
        return this.getImageImpl(elapsedFraction, true);
    }

    protected abstract BufferedImage getImageImpl(float var1, boolean var2);

    protected Point getAdditionalOffset(float elapsedFraction) {
        return null;
    }

    protected final BufferedImage getDestinationImage() {
        Dimension outputSize = this.getOutputBounds().getSize();
        if (this.blankImage == null || this.blankImage.getWidth() != outputSize.width || this.blankImage.getHeight() != outputSize.height) {
            this.blankImage = new BufferedImage(outputSize.width, outputSize.height, 2);
        }
        return this.blankImage;
    }

    protected final void saveSnapshot(BufferedImage image, String name) {
        File snapshotDir = PatchworkComposerProperties.getIODirectory(IOFileType.SNAPSHOT);
        try {
            ImageUtils.saveImage(image, new File(snapshotDir, name + ".png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private BufferedImage getFlippedImage(BufferedImage source) {
        if (!this.flipHorizontal && !this.flipVertical) {
            return source;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage flipped = new BufferedImage(width, height, source.getType());
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int xAdj = this.flipHorizontal ? width - x - 1 : x;
                int yAdj = this.flipVertical ? height - y - 1 : y;
                flipped.setRGB(x, y, source.getRGB(xAdj, yAdj));
            }
        }
        return flipped;
    }

    private final BufferedImage getHazeImage(BufferedImage clearImage, boolean mask) {
        if (this.hazeAmount == 0.0f) {
            return clearImage;
        }
        BufferedImage result = new BufferedImage(clearImage.getWidth(), clearImage.getHeight(), clearImage.getType());
        Graphics2D g = result.createGraphics();
        g.drawImage((Image)clearImage, 0, 0, null);
        if (this.hazeAmount > 0.0f) {
            Color hazeBlendColor = this.getHazeBlendColor();
            g.setColor(hazeBlendColor);
            g.setComposite(mask ? AlphaComposite.SrcAtop : AlphaComposite.SrcOver);
            g.fillRect(0, 0, result.getWidth(), result.getHeight());
        }
        g.dispose();
        return result;
    }

    private final BufferedImage getMarginFadeImage(BufferedImage image) {
        if (this.marginFade == 0.0f) {
            return image;
        }
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics2D g = result.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        Rectangle4d outputBounds = this.getOutputBounds();
        double solidWidth = MathUtils.interpolate(this.marginFade, outputBounds.getWidth(), PatchworkProject.CARD_SIZE);
        double solidHeight = MathUtils.interpolate(this.marginFade, outputBounds.getHeight(), PatchworkProject.CARD_SIZE);
        Rectangle4d solidImageRect = new Rectangle4d(-outputBounds.getX() * (double)this.marginFade, -outputBounds.getY() * (double)this.marginFade, solidWidth, solidHeight);
        return ImageUtils.fadeMargins(result, solidImageRect);
    }

    public static abstract class Transcoder<T extends LocationLayerGraphic>
    extends ProjectComponent.Transcoder<T> {
        private static final String ATTR_MARGINS_REGION = "marginsRegion";
        private static final String ATTR_IS_MOVING_WINDOW = "attrIsMovingWindow";
        private static final String ATTR_TRACK_CAMERA = "trackCamera";
        private static final String ATTR_SOURCE_GRID_OFFSET = "sourceOffset";
        private static final String ATTR_SOURCE_PIXEL_OFFSET = "sourcePixelOffset";
        private static final String ATTR_FLIP_HORIZONTAL = "flipHorizontal";
        private static final String ATTR_FLIP_VERTICAL = "flipVertical";
        private static final String ATTR_OVERRIDE_VIEWPOINT = "overrideViewpoint";
        private static final String ATTR_INTERP_FUNCTION = "interpFunction";
        private static final String ATTR_INTERACTIVE_WHEN_ANIMATING = "interactiveWhenAnimating";
        private static final String ATTR_HAZE_COLOR = "hazeColor";
        private static final String ATTR_HAZE_AMOUNT = "hazeAmount";
        private static final String ATTR_MARGIN_FADE = "marginFade";
        private static final String ATTR_ATTACHED_STATES = "attachedStates";

        public Transcoder(String elementName, Class<T> decodedType) {
            super(elementName, decodedType);
        }

        public Transcoder(String elementName, String decodeElementName, Class<T> decodedType) {
            super(elementName, decodeElementName, decodedType);
        }

        @Override
        protected void getAttributes(T object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            if (((LocationLayerGraphic)object).marginsRegion != null) {
                destination.put(ATTR_MARGINS_REGION, ((LocationLayerGraphic)object).marginsRegion.encode());
            }
            destination.put(ATTR_IS_MOVING_WINDOW, Boolean.toString(((LocationLayerGraphic)object).isMovingWindow));
            destination.put(ATTR_TRACK_CAMERA, Boolean.toString(((LocationLayerGraphic)object).tracksCamera));
            destination.put(ATTR_ATTACHED_STATES, ((LocationLayerGraphic)object).attachedStates.encode());
            destination.put(ATTR_SOURCE_GRID_OFFSET, StringUtils.encodePoint(((LocationLayerGraphic)object).sourceGridOffset));
            destination.put(ATTR_SOURCE_PIXEL_OFFSET, StringUtils.encodePoint(((LocationLayerGraphic)object).sourcePixelOffset));
            destination.put(ATTR_FLIP_HORIZONTAL, Boolean.toString(((LocationLayerGraphic)object).flipHorizontal));
            destination.put(ATTR_FLIP_VERTICAL, Boolean.toString(((LocationLayerGraphic)object).flipVertical));
            destination.put(ATTR_OVERRIDE_VIEWPOINT, ((LocationLayerGraphic)object).overrideViewpoint.encode());
            destination.put(ATTR_HAZE_COLOR, Integer.toString(ColorUtils.toIntARGB(((LocationLayerGraphic)object).hazeColor)));
            destination.put(ATTR_HAZE_AMOUNT, Float.toString(((LocationLayerGraphic)object).hazeAmount));
            destination.put(ATTR_MARGIN_FADE, Float.toString(((LocationLayerGraphic)object).marginFade));
            destination.put(ATTR_INTERP_FUNCTION, ((LocationLayerGraphic)object).interpFunction.name());
            destination.put(ATTR_INTERACTIVE_WHEN_ANIMATING, Boolean.toString(((LocationLayerGraphic)object).interactiveWhenAnimating));
        }

        @Override
        protected final T decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            T result = this.decodeGraphic(id, attributes, decodedChildren);
            if (attributes.containsKey(ATTR_MARGINS_REGION)) {
                ((LocationLayerGraphic)result).marginsRegion = new Rectangle4d(attributes.get(ATTR_MARGINS_REGION));
            }
            if (attributes.containsKey(ATTR_IS_MOVING_WINDOW)) {
                ((LocationLayerGraphic)result).isMovingWindow = Boolean.valueOf(attributes.get(ATTR_IS_MOVING_WINDOW));
            }
            if (attributes.containsKey(ATTR_TRACK_CAMERA)) {
                ((LocationLayerGraphic)result).tracksCamera = Boolean.valueOf(attributes.get(ATTR_TRACK_CAMERA));
            }
            if (attributes.containsKey(ATTR_SOURCE_GRID_OFFSET)) {
                ((LocationLayerGraphic)result).sourceGridOffset.setLocation(StringUtils.decodePoint(attributes.get(ATTR_SOURCE_GRID_OFFSET)));
            }
            if (attributes.containsKey(ATTR_SOURCE_PIXEL_OFFSET)) {
                ((LocationLayerGraphic)result).sourcePixelOffset.setLocation(StringUtils.decodePoint(attributes.get(ATTR_SOURCE_PIXEL_OFFSET)));
            }
            if (attributes.containsKey(ATTR_FLIP_HORIZONTAL)) {
                ((LocationLayerGraphic)result).flipHorizontal = Boolean.valueOf(attributes.get(ATTR_FLIP_HORIZONTAL));
            }
            if (attributes.containsKey(ATTR_FLIP_VERTICAL)) {
                ((LocationLayerGraphic)result).flipVertical = Boolean.valueOf(attributes.get(ATTR_FLIP_VERTICAL));
            }
            ((LocationLayerGraphic)result).overrideViewpoint = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_OVERRIDE_VIEWPOINT));
            if (attributes.containsKey(ATTR_INTERP_FUNCTION)) {
                ((LocationLayerGraphic)result).interpFunction = InterpFunction.valueOf(attributes.get(ATTR_INTERP_FUNCTION));
            }
            if (attributes.containsKey(ATTR_HAZE_COLOR)) {
                ((LocationLayerGraphic)result).hazeColor = ColorUtils.toColor(Integer.valueOf(attributes.get(ATTR_HAZE_COLOR)));
            }
            if (attributes.containsKey(ATTR_HAZE_AMOUNT)) {
                ((LocationLayerGraphic)result).hazeAmount = Float.valueOf(attributes.get(ATTR_HAZE_AMOUNT)).floatValue();
            }
            if (attributes.containsKey(ATTR_MARGIN_FADE)) {
                ((LocationLayerGraphic)result).marginFade = Float.valueOf(attributes.get(ATTR_MARGIN_FADE)).floatValue();
            }
            ((LocationLayerGraphic)result).attachedStates = new ReferenceList((ProjectComponent)result, attributes.get(ATTR_ATTACHED_STATES));
            if (attributes.containsKey(ATTR_INTERACTIVE_WHEN_ANIMATING)) {
                ((LocationLayerGraphic)result).interactiveWhenAnimating = Boolean.valueOf(attributes.get(ATTR_INTERACTIVE_WHEN_ANIMATING));
            }
            return result;
        }

        protected abstract T decodeGraphic(String var1, Map<String, String> var2, MultiMap<String, Object> var3);
    }

    public static enum ImageEffect {
        SCALE_TO_OUTPUT,
        HAZE,
        FLIP,
        MARGIN_FADE;

    }
}

