/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.graphic;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scanimport.OffsetImage;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.Viewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.parallax.ParallaxedImage;
import com.sodiumarc.patchwork.app.scenecomposer.resource.ResourceManager;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class LinkedGraphic
extends LocationLayerGraphic {
    public static final Icon ICON = IconLoader.loadIcon("silk/photo_link.png");
    private Reference<LocationLayerGraphic> graphic = new Reference();
    private boolean useRemoteCamera;
    private boolean prescaleGraphic = false;
    private BufferedImage publishedImage;
    private static final Logger LOGGER = Logger.getLogger(LinkedGraphic.class);

    public LinkedGraphic(String id) {
        super(id);
    }

    public LocationLayerGraphic getGraphic() {
        return this.graphic.resolve();
    }

    public void setGraphic(LocationLayerGraphic graphic) {
        this.graphic = new Reference<LocationLayerGraphic>((ProjectComponent)this, graphic);
        this.fireModified();
    }

    public boolean getUseRemoteCamera() {
        return this.useRemoteCamera;
    }

    public void setUseRemoteCamera(boolean useRemoteCamera) {
        this.useRemoteCamera = useRemoteCamera;
        this.fireModified();
    }

    public boolean isPrescaleGraphic() {
        return this.prescaleGraphic;
    }

    public void setPrescaleGraphic(boolean preScaleGraphic) {
        this.prescaleGraphic = preScaleGraphic;
        this.fireModified();
    }

    @Override
    public boolean isAnimated() {
        LocationLayerGraphic graphic = this.getGraphic();
        if (graphic == null) {
            return false;
        }
        return graphic.isAnimated();
    }

    @Override
    public boolean isEmpty() {
        LocationLayerGraphic graphic = this.getGraphic();
        if (graphic == null) {
            return true;
        }
        return graphic.isEmpty();
    }

    @Override
    public BufferedImage getImageImpl(float elapsedFraction, boolean doScale) {
        BufferedImage sourceImage;
        BufferedImage publishedImage = this.getPublishedImage();
        if (publishedImage != null) {
            return publishedImage;
        }
        LocationLayerGraphic graphic = this.getGraphic();
        if (graphic == null) {
            return null;
        }
        SceneLocationLayer sourceLayer = graphic.getAncestorByType(SceneLocationLayer.class);
        if (sourceLayer.isBackground()) {
            return graphic.getImage(elapsedFraction);
        }
        EnumSet<LocationLayerGraphic.ImageEffect> effects = EnumSet.of(LocationLayerGraphic.ImageEffect.FLIP);
        if (this.prescaleGraphic || !this.useRemoteCamera) {
            effects.add(LocationLayerGraphic.ImageEffect.SCALE_TO_OUTPUT);
        }
        if ((sourceImage = graphic.getImage(elapsedFraction, effects)) == null) {
            return null;
        }
        if (this.useRemoteCamera) {
            Point sourceOffset = graphic.getSourceTotalOffset();
            final OffsetImage sourceOffsetImage = new OffsetImage(sourceImage, sourceOffset.x, sourceOffset.y);
            ParallaxedImage parallaxedImage = new ParallaxedImage(graphic.getViewpoint().getCamera(), graphic.getViewport(true), graphic.getOutputSize(), sourceLayer.getRefPoint()){

                @Override
                protected OffsetImage getHomeImage() {
                    return sourceOffsetImage;
                }
            };
            Viewpoint myViewpoint = this.getViewpoint();
            OffsetImage offsetResult = new OffsetImage(this.getDestinationImage(), 0, 0);
            parallaxedImage.getTransformedImage(myViewpoint.getCamera(), this.getViewport(true), this.getOutputSize(), offsetResult, null, true);
            return offsetResult.getImage();
        }
        Rectangle4d sourceBounds = graphic.getOutputBounds();
        Rectangle4d destBounds = this.getOutputBounds();
        BufferedImage result = this.getDestinationImage();
        Graphics2D g = (Graphics2D)result.getGraphics();
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(0, 0, result.getWidth(), result.getHeight());
        g.setComposite(AlphaComposite.SrcOver);
        AffineTransform entryTransform = new AffineTransform();
        entryTransform.translate(sourceBounds.getX() - destBounds.getX(), sourceBounds.getY() - destBounds.getY());
        g.drawImage(sourceImage, entryTransform, null);
        g.dispose();
        return result;
    }

    @Override
    public int getDurationInMillis() {
        LocationLayerGraphic graphic = this.getGraphic();
        if (graphic == null) {
            return 0;
        }
        return graphic.getDurationInMillis();
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public Rectangle4d getMarginsRegion() {
        SceneLocationLayer sourceLayer;
        LocationLayerGraphic graphic = this.getGraphic();
        if (graphic != null && (sourceLayer = graphic.getAncestorByType(SceneLocationLayer.class)).isBackground()) {
            return graphic.getMarginsRegion();
        }
        return super.getMarginsRegion();
    }

    @Override
    public boolean publish() {
        BufferedImage image;
        long fileLastModified;
        if (!this.canPublish()) {
            return false;
        }
        long lastModified = this.getLastModified();
        if (lastModified > (fileLastModified = ResourceManager.getLastModification(this.getGUID() + ".png")) && (image = this.getImageImpl(0.0f)) != null) {
            try {
                ResourceManager.publishImageResource(image, this.getGUID());
            }
            catch (IOException e) {
                LOGGER.warn("Failed to publish " + this.getID() + ": " + e.getMessage());
            }
            return true;
        }
        return false;
    }

    @Override
    public void preload() {
        this.getPublishedImage();
    }

    private BufferedImage getPublishedImage() {
        BufferedImage result = null;
        PatchworkProject project = (PatchworkProject)this.getPath().get(0);
        if (project.isPublished() && this.canPublish()) {
            if (this.publishedImage == null) {
                this.publishedImage = ResourceManager.getImageResourceByID(this.getGUID());
            }
            result = this.publishedImage;
        }
        return result;
    }

    private boolean canPublish() {
        return this.useRemoteCamera && !this.prescaleGraphic && !this.isAnimated();
    }

    public static class Transcoder
    extends LocationLayerGraphic.Transcoder<LinkedGraphic> {
        private static final String ELEMENT_NAME = "LinkedGraphic";
        private static final String ATTR_GRAPHIC = "graphic";
        private static final String ATTR_USE_REMOTE_CAMERA = "useRemoteCamera";
        private static final String ATTR_PRESCALE_GRAPHIC = "prescaleGraphic";

        public Transcoder() {
            super(ELEMENT_NAME, LinkedGraphic.class);
        }

        @Override
        protected void getAttributes(LinkedGraphic object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_GRAPHIC, object.graphic.encode());
            destination.put(ATTR_USE_REMOTE_CAMERA, Boolean.toString(object.useRemoteCamera));
            destination.put(ATTR_PRESCALE_GRAPHIC, Boolean.toString(object.prescaleGraphic));
        }

        @Override
        protected LinkedGraphic decodeGraphic(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            LinkedGraphic result = new LinkedGraphic(id);
            result.graphic = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_GRAPHIC));
            if (attributes.containsKey(ATTR_USE_REMOTE_CAMERA)) {
                result.useRemoteCamera = (boolean)Boolean.valueOf(attributes.get(ATTR_USE_REMOTE_CAMERA));
            }
            if (attributes.containsKey(ATTR_PRESCALE_GRAPHIC)) {
                result.prescaleGraphic = (boolean)Boolean.valueOf(attributes.get(ATTR_PRESCALE_GRAPHIC));
            }
            return result;
        }
    }
}

