/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.graphic;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.layeredimage.ImageLayer;
import com.sodiumarc.patchwork.app.layeredimage.LayeredImage;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerApp;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.resource.ResourceManager;
import com.sodiumarc.patchwork.render.mesh.MeshUtils;
import com.sodiumarc.patchwork.render.scenegraph.COLLADALoader;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraph;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraphNode;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.StringUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Point3d;
import org.apache.log4j.Logger;

public class LayeredImageGraphic
extends LocationLayerGraphic {
    public static final String PIVOT_NODE_PREFIX = "PIVOT";
    public static final Icon ICON = IconLoader.loadIcon("silk/photo.png");
    public static final Icon EMPTY_ICON = IconLoader.loadIcon("silk/shape_handles.png");
    private final ChangeListener imageChangeListener;
    private LayeredImage image;
    private File pivotColladaFile;
    private String pivotNodeName;
    private final Point pivotPoint;
    private final Point manualPivotPoint;
    private SceneGraph sceneGraph;
    private static final Logger LOGGER = Logger.getLogger(LayeredImageGraphic.class);

    public LayeredImageGraphic(String id) {
        this(id, null);
    }

    public LayeredImage getLayeredImage() {
        return this.image;
    }

    @Override
    public boolean isEmpty() {
        PatchworkProject project = this.getAncestorByType(PatchworkProject.class);
        if (project != null && project.isPublished()) {
            return this.getImage(0.0f) == null;
        }
        if (this.getHazeAmount() > 0.0f) {
            return false;
        }
        return this.image.isEmpty();
    }

    public String getPivotFilename() {
        File file = this.getInputFile();
        return file == null ? null : file.getName();
    }

    public void setPivotFilename(String inputFilename) {
        this.pivotColladaFile = inputFilename == null ? null : new File(this.getIODirectory(IOFileType.COLLADA), inputFilename);
        this.sceneGraph = null;
        this.fireModified();
    }

    public String getPivotNodeName() {
        return this.pivotNodeName;
    }

    public void setPivotNodeName(String pivotNodeName) {
        this.pivotNodeName = pivotNodeName;
        this.updatePivotPoint();
        this.fireModified();
    }

    public List<String> getPivotNodeNames() {
        ArrayList<String> result = new ArrayList<String>();
        SceneGraph sceneGraph = this.getSceneGraph();
        if (sceneGraph != null) {
            Pattern namePattern = Pattern.compile("PIVOT.*");
            for (SceneGraphNode node : sceneGraph.getNodes(namePattern)) {
                result.add(node.getName());
            }
        }
        return result;
    }

    public void updatePivotPoint() {
        this.pivotPoint.setLocation(0, 0);
        SceneGraphNode pivotNode = this.getPivotNode();
        if (pivotNode != null) {
            Point3d globalPosition = new Point3d();
            pivotNode.getCumulativeTransform().transform(globalPosition);
            SceneLocation location = this.getAncestorByType(SceneLocation.class);
            Point3d pixelPos = location.getCamera().globalToDisplay(globalPosition, this.getViewport(true), this.getOutputBounds().getSize());
            this.pivotPoint.setLocation((int)pixelPos.x, (int)pixelPos.y);
        }
        this.fireModified();
    }

    public Point getPivotPointBeforeOffset() {
        return this.pivotPoint;
    }

    public Point getManualPivotPoint() {
        return this.manualPivotPoint;
    }

    public void setManualPivotPoint(Point point) {
        this.manualPivotPoint.setLocation(point);
        this.fireModified();
    }

    public void autoLoadImages(IOFileType type, String filenameFormat, File[] files) {
        String layerFilename = String.format(filenameFormat, this.getAncestorByType(Scene.class).getID(), this.getAncestorByType(SceneLocation.class).getID(), this.getAncestorByType(SceneLocationLayer.class).getID());
        File layerFile = null;
        for (File file : files) {
            if (!file.getName().equals(layerFilename)) continue;
            layerFile = file;
            break;
        }
        if (layerFile != null) {
            String name = type.name();
            List<ImageLayer> existing = this.image.getLayersByName(name);
            if (existing.isEmpty()) {
                ImageLayer imageLayer = new ImageLayer(name, layerFile);
                this.image.addLayer(imageLayer);
            } else {
                for (ImageLayer existingLayer : existing) {
                    existingLayer.setSourceImageFile(layerFile);
                }
            }
        }
        this.fireModified();
    }

    public void updateImages() {
        this.image.removeChangeListener(this.imageChangeListener);
        for (ImageLayer layer : this.image.getLayers()) {
            if (this.isCroppedToViewport(layer)) {
                layer.setSourceImageRect(null, false);
                continue;
            }
            Rectangle4d sourceRect = this.getViewport(true);
            sourceRect = PatchworkComposerApp.BLENDER_VIEWPORT.toProportional(sourceRect);
            layer.setSourceImageRect(sourceRect, true);
        }
        Rectangle4d outputRect = this.getOutputBounds();
        this.image.setOutputSize(outputRect.getSize());
        this.image.addChangeListener(this.imageChangeListener);
    }

    @Override
    public void setMovingWindow(boolean isMovingWindow) {
        super.setMovingWindow(isMovingWindow);
        this.updateImages();
    }

    @Override
    public Icon getIcon() {
        return this.isEmpty() ? EMPTY_ICON : ICON;
    }

    @Override
    public boolean isAnimated() {
        return false;
    }

    @Override
    public BufferedImage getImageImpl(float elapsedFraction, boolean doScale) {
        Point pivotLoc;
        PatchworkProject project = (PatchworkProject)this.getPath().get(0);
        if (project.isPublished()) {
            return ResourceManager.getImageResourceByID(this.getGUID());
        }
        BufferedImage result = null;
        if (!this.image.isEmpty()) {
            if (doScale) {
                if (!this.image.getOutputSize().equals(this.getOutputSize())) {
                    this.updateImages();
                }
                result = this.image.getCompositeImage();
            } else {
                result = this.image.getCompositeUnscaled();
            }
        }
        if (LOGGER.isDebugEnabled() && result != null && (pivotLoc = this.getPivotLocation()) != null) {
            BufferedImage debugResult = new BufferedImage(result.getWidth(), result.getHeight(), 2);
            Graphics2D graphics = debugResult.createGraphics();
            graphics.drawImage((Image)result, 0, 0, null);
            MeshUtils.drawVertex(graphics, new Point3d(pivotLoc.x, pivotLoc.y, 0.0), Color.BLUE, 5, null);
            graphics.dispose();
            result = debugResult;
        }
        return result;
    }

    @Override
    public int getDurationInMillis() {
        return 0;
    }

    @Override
    public Point getAdditionalOffset(float elapsedFraction) {
        return this.getPivotOffset();
    }

    @Override
    public boolean publish() {
        BufferedImage image;
        long fileLastModified;
        long lastModified = this.getLastModified();
        if (lastModified > (fileLastModified = ResourceManager.getLastModification(this.getGUID() + ".png")) && (image = this.getImageImpl(0.0f)) != null) {
            try {
                ResourceManager.publishImageResource(image, this.getGUID());
            }
            catch (IOException e) {
                LOGGER.warn("Failed to publish " + this.getID() + ": " + e.getMessage());
            }
            return true;
        }
        return false;
    }

    @Override
    public void preload() {
        this.getImage(0.0f);
    }

    private LayeredImageGraphic(String id, LayeredImage image) {
        super(id);
        this.image = image == null ? new LayeredImage() : image;
        this.image.setCacheDir(this.getIODirectory(IOFileType.TEMP));
        this.image.setImageLoader(new ImageLayer.ImageLoader(){

            @Override
            public BufferedImage loadImage(ImageLayer layer, File file) {
                try {
                    return ImageIO.read(LayeredImageGraphic.this.getAdjustedImageFile(layer, file));
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to read image: " + file.getName());
                    return null;
                }
            }

            @Override
            public boolean imageExists(ImageLayer layer, File file) {
                return LayeredImageGraphic.this.getAdjustedImageFile(layer, file).exists();
            }
        });
        this.imageChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LayeredImageGraphic.this.updateImages();
                LayeredImageGraphic.this.fireModified();
            }
        };
        this.manualPivotPoint = new Point();
        this.pivotPoint = new Point();
        this.image.addChangeListener(this.imageChangeListener);
    }

    private File getInputFile() {
        if (this.pivotColladaFile != null) {
            return this.pivotColladaFile;
        }
        Scene scene = this.getAncestorByType(Scene.class);
        if (scene == null) {
            return null;
        }
        return scene.getInputFile();
    }

    private Point getPivotOffset() {
        Point pivotLoc = this.getPivotLocation();
        if (pivotLoc == null) {
            return null;
        }
        return new Point(-pivotLoc.x, -pivotLoc.y);
    }

    private Point getPivotLocation() {
        return this.pivotPoint;
    }

    private SceneGraphNode getPivotNode() {
        if (this.pivotNodeName == null) {
            return null;
        }
        SceneGraph sceneGraph = this.getSceneGraph();
        if (sceneGraph == null) {
            return null;
        }
        return CollectionUtils.first(sceneGraph.getNodes(this.pivotNodeName));
    }

    private SceneGraph getSceneGraph() {
        File inputFile = this.getInputFile();
        if (inputFile == null) {
            return this.getAncestorByType(Scene.class).getSceneGraph();
        }
        if (this.sceneGraph == null) {
            inputFile = new File(this.getIODirectory(IOFileType.COLLADA), inputFile.getName());
            this.sceneGraph = new COLLADALoader().load(inputFile);
        }
        return this.sceneGraph;
    }

    private File getAdjustedImageFile(ImageLayer layer, File file) {
        for (IOFileType type : IOFileType.values()) {
            if (!type.name().equals(layer.getName())) continue;
            File directory = this.getIODirectory(type);
            return new File(directory, file.getName());
        }
        return file;
    }

    private boolean isCroppedToViewport(ImageLayer layer) {
        return !IOFileType.LAYER_RENDERS.name().equals(layer.getName());
    }

    public static class Transcoder
    extends LocationLayerGraphic.Transcoder<LayeredImageGraphic> {
        private static final String ELEMENT_NAME = "LayeredImageGraphic";
        private static final String ATTR_PIVOT_FILENAME = "pivotFilename";
        private static final String ATTR_PIVOT_NODE_NAME = "pivotNodeName";
        private static final String ATTR_MANUAL_PIVOT = "manualPivotPoint";
        private static final String ATTR_PIVOT_POINT = "pivotPoint";
        private static final String FIELD_IMAGE = "layeredImage";

        public Transcoder() {
            super(ELEMENT_NAME, LayeredImageGraphic.class);
            this.setFieldTranscoder(FIELD_IMAGE, new LayeredImage.Transcoder());
        }

        @Override
        protected void getAttributes(LayeredImageGraphic object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            if (object.pivotColladaFile != null) {
                destination.put(ATTR_PIVOT_FILENAME, object.pivotColladaFile.toString());
            }
            if (object.pivotNodeName != null) {
                destination.put(ATTR_PIVOT_NODE_NAME, object.pivotNodeName);
            }
            destination.put(ATTR_MANUAL_PIVOT, StringUtils.encodePoint(object.manualPivotPoint));
            destination.put(ATTR_PIVOT_POINT, StringUtils.encodePoint(object.pivotPoint));
        }

        @Override
        protected void getChildren(LayeredImageGraphic object, MultiMap<String, Object> destination) {
            destination.putLast(FIELD_IMAGE, object.image);
        }

        @Override
        protected LayeredImageGraphic decodeGraphic(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            LayeredImageGraphic result = new LayeredImageGraphic(id, (LayeredImage)decodedChildren.getFirst(FIELD_IMAGE));
            if (attributes.containsKey(ATTR_PIVOT_FILENAME)) {
                result.pivotColladaFile = new File(attributes.get(ATTR_PIVOT_FILENAME));
            }
            if (attributes.containsKey(ATTR_PIVOT_NODE_NAME)) {
                result.pivotNodeName = attributes.get(ATTR_PIVOT_NODE_NAME);
            }
            if (attributes.containsKey(ATTR_MANUAL_PIVOT)) {
                result.manualPivotPoint.setLocation(StringUtils.decodePoint(attributes.get(ATTR_MANUAL_PIVOT)));
            }
            if (attributes.containsKey(ATTR_PIVOT_POINT)) {
                result.pivotPoint.setLocation(StringUtils.decodePoint(attributes.get(ATTR_PIVOT_POINT)));
            }
            return result;
        }
    }
}

