/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.behavior;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.Predicate;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class StateTransition
extends ProjectComponent {
    public static final Icon ICON = IconLoader.loadIcon("silk/bullet_go.png");
    public static final Icon BI_ICON = IconLoader.loadIcon("silk/arrow_refresh_small.png");
    private Reference<SceneLayerState> destinationState;
    private boolean unstackedOnly;
    private boolean bidirectional;
    private Predicate.Operator predicateOperator = Predicate.Operator.ALL;
    private String predicateFormula = null;
    private final List<Predicate> predicates;

    public StateTransition(String id) {
        super(id);
        this.destinationState = new Reference();
        this.predicates = new ArrayList<Predicate>();
        this.registerChildType(Predicate.class, Predicate.ICON, true);
    }

    public SceneLayerState getDestinationState() {
        return this.destinationState.resolve();
    }

    public void setDestinationState(SceneLayerState destinationState) {
        this.destinationState = new Reference<SceneLayerState>((ProjectComponent)this, destinationState);
        this.fireModified();
    }

    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    public boolean isUnstackedOnly() {
        return this.unstackedOnly;
    }

    public void setUnstackedOnly(boolean onGridOnly) {
        this.unstackedOnly = onGridOnly;
        this.fireModified();
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    public void setBidirectional(boolean bidirectional) {
        this.bidirectional = bidirectional;
        this.fireModified();
    }

    public Predicate.Operator getPredicateOperator() {
        return this.predicateOperator;
    }

    public void setPredicateOperator(Predicate.Operator predicateOperator) {
        this.predicateOperator = predicateOperator;
        this.fireModified();
    }

    public String getPredicateFormula() {
        return this.predicateFormula;
    }

    public void setPredicateFormula(String booleanFormula) {
        this.predicateFormula = booleanFormula;
        this.fireModified();
    }

    @Override
    public Icon getIcon() {
        return this.isBidirectional() ? BI_ICON : ICON;
    }

    @Override
    public String getDisplayName(boolean htmlOK) {
        SceneLayerState dest = this.getDestinationState();
        String result = String.format("to %s", dest == null ? "(none)" : dest);
        if (this.getPredicateOperator() == Predicate.Operator.ANY) {
            result = result + " (match any)";
        } else if (this.getPredicateOperator() == Predicate.Operator.FORMULA) {
            result = result + String.format(" (f = '%s')", this.predicateFormula);
        }
        return result;
    }

    @Override
    public void addChildComponent(String id, Class<? extends ProjectComponent> type) {
        if (type.equals(Predicate.class)) {
            this.addPredicate(new Predicate(id), true);
        }
    }

    @Override
    public void removeChildComponent(ProjectComponent child) {
        if (child instanceof Predicate) {
            this.removePredicate((Predicate)child, true);
        }
    }

    private void addPredicate(Predicate predicate, boolean notify) {
        this.predicates.add(predicate);
        this.registerChild(predicate, notify);
    }

    private void removePredicate(Predicate predicate, boolean notify) {
        this.predicates.remove(predicate);
        this.removeChild(predicate, notify);
    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<StateTransition> {
        private static final String ELEMENT_NAME = "StateTransition";
        private static final String ATTR_DEST = "destinationState";
        private static final String ATTR_UNSTACKED_ONLY = "onGridOnly";
        private static final String ATTR_BIDIRECTIONAL = "bidirectional";
        private static final String ATTR_PREDICATE_OPERATOR = "predicateOperator";
        private static final String ATTR_PREDICATE_FORMULA = "predicateFormula";
        private static final String FIELD_PREDICATES = "predicates";

        public Transcoder() {
            super(ELEMENT_NAME, StateTransition.class);
            this.setFieldTranscoder(FIELD_PREDICATES, new Predicate.Transcoder());
        }

        @Override
        protected StateTransition decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            StateTransition result = new StateTransition(id);
            result.destinationState = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_DEST));
            for (Object predicate : decodedChildren.getAll(FIELD_PREDICATES)) {
                result.addPredicate((Predicate)predicate, false);
            }
            if (attributes.containsKey(ATTR_UNSTACKED_ONLY)) {
                result.unstackedOnly = Boolean.valueOf(attributes.get(ATTR_UNSTACKED_ONLY));
            }
            if (attributes.containsKey(ATTR_BIDIRECTIONAL)) {
                result.bidirectional = Boolean.valueOf(attributes.get(ATTR_BIDIRECTIONAL));
            }
            if (attributes.containsKey(ATTR_PREDICATE_OPERATOR)) {
                result.predicateOperator = Predicate.Operator.valueOf(attributes.get(ATTR_PREDICATE_OPERATOR));
            }
            result.predicateFormula = attributes.get(ATTR_PREDICATE_FORMULA);
            return result;
        }

        @Override
        protected void getAttributes(StateTransition object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_DEST, object.destinationState.encode());
            destination.put(ATTR_UNSTACKED_ONLY, Boolean.toString(object.unstackedOnly));
            destination.put(ATTR_BIDIRECTIONAL, Boolean.toString(object.bidirectional));
            destination.put(ATTR_PREDICATE_OPERATOR, object.predicateOperator.name());
            if (object.predicateFormula != null) {
                destination.put(ATTR_PREDICATE_FORMULA, object.predicateFormula);
            }
        }

        @Override
        protected void getChildren(StateTransition object, MultiMap<String, Object> destination) {
            for (Predicate predicate : object.getPredicates()) {
                destination.putLast(FIELD_PREDICATES, predicate);
            }
        }
    }
}

