/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.behavior;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.StateTransition;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequence;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class SceneLayerState
extends ProjectComponent {
    public static final Icon ICON = IconLoader.loadIcon("silk/flag_blue.png");
    private final List<StateTransition> transitions = new ArrayList<StateTransition>();
    private Reference<SoundSequence> soundSequence = new Reference();

    public SceneLayerState(String id) {
        super(id);
        this.registerChildType(StateTransition.class, StateTransition.ICON, true);
    }

    public SoundSequence getSoundSequence() {
        return this.soundSequence.resolve();
    }

    public void setSoundSequence(SoundSequence soundClip) {
        this.soundSequence = new Reference<SoundSequence>((ProjectComponent)this, soundClip);
        this.fireModified();
    }

    public List<StateTransition> getTransitions() {
        return this.transitions;
    }

    public List<StateTransition> getInverseTransitions() {
        ArrayList<StateTransition> result = new ArrayList<StateTransition>();
        for (SceneLayerState state : this.getParentComponent().getStates()) {
            if (state == this) continue;
            for (StateTransition transition : state.getTransitions()) {
                if (!transition.isBidirectional() || !this.equals(transition.getDestinationState())) continue;
                result.add(transition);
            }
        }
        return result;
    }

    public boolean hasForwardTransitions() {
        for (StateTransition transition : this.getTransitions()) {
            if (transition.getDestinationState() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public SceneLayer getParentComponent() {
        return (SceneLayer)super.getParentComponent();
    }

    @Override
    public void addChildComponent(String id, Class<? extends ProjectComponent> type) {
        if (type.equals(StateTransition.class)) {
            this.addTransition(new StateTransition(this.newUniqueChildID(id)), true);
        }
    }

    @Override
    public void removeChildComponent(ProjectComponent child) {
        if (child instanceof StateTransition) {
            this.removeTransition((StateTransition)child, true);
        }
    }

    private void addTransition(StateTransition transition, boolean notify) {
        this.transitions.add(transition);
        this.registerChild(transition, notify);
    }

    private void removeTransition(StateTransition transition, boolean notify) {
        this.transitions.remove(transition);
        this.removeChild(transition, notify);
    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<SceneLayerState> {
        private static final String ELEMENT_NAME = "StateFlag";
        private static final String FIELD_TRANSITIONS = "transitions";
        private static final String ATTR_AUDIO_SEQUENCE = "soundSequence";

        public Transcoder() {
            super(ELEMENT_NAME, SceneLayerState.class);
            this.setFieldTranscoder(FIELD_TRANSITIONS, new StateTransition.Transcoder());
        }

        @Override
        protected SceneLayerState decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            SceneLayerState result = new SceneLayerState(id);
            for (Object transition : decodedChildren.getAll(FIELD_TRANSITIONS)) {
                result.addTransition((StateTransition)transition, false);
            }
            result.soundSequence = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_AUDIO_SEQUENCE));
            return result;
        }

        @Override
        protected void getAttributes(SceneLayerState object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_AUDIO_SEQUENCE, object.soundSequence.encode());
        }

        @Override
        protected void getChildren(SceneLayerState object, MultiMap<String, Object> destination) {
            for (StateTransition transition : object.getTransitions()) {
                destination.putLast(FIELD_TRANSITIONS, transition);
            }
        }
    }
}

