/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.behavior;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.CardLink;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.LocationTransition;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridCoords;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.CompareUtilities;
import java.util.Map;
import javax.swing.Icon;

public class Predicate
extends ProjectComponent {
    public static final Icon ICON = IconLoader.loadIcon("silk/contrast.png");
    public static final String DEFAULT_ID = "predicate";
    private boolean negated;
    private Reference<ProjectComponent> predicateSubject;
    private CardStatus cardStatus = CardStatus.IN_PLAY;
    private GridCoords requiredCoords;
    private boolean mouseOverOnly;

    public Predicate(String id) {
        super(id);
        this.predicateSubject = new Reference();
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
        this.fireModified();
    }

    public ProjectComponent getPredicateSubject() {
        ProjectComponent subject = this.predicateSubject.resolve();
        if (subject == null) {
            return this.getAncestorByType(Card.class);
        }
        return subject;
    }

    public void setPredicateSubject(ProjectComponent subject) {
        this.predicateSubject = new Reference<ProjectComponent>((ProjectComponent)this, subject);
        this.fireModified();
    }

    public CardStatus getCardStatus() {
        return this.cardStatus;
    }

    public void setCardStatus(CardStatus cardStatus) {
        this.cardStatus = cardStatus;
        this.fireModified();
    }

    public GridCoords getRequiredCoords() {
        if (this.requiredCoords == null) {
            return new GridCoords(0, 0);
        }
        return this.requiredCoords;
    }

    public void setRequiredCoords(GridCoords requiredCoords) {
        this.requiredCoords = requiredCoords;
        this.fireModified();
    }

    public boolean isMouseOverOnly() {
        return this.mouseOverOnly;
    }

    public void setMouseOverOnly(boolean mouseOverOnly) {
        this.mouseOverOnly = mouseOverOnly;
        this.fireModified();
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public String getDisplayName(boolean htmlOK) {
        ProjectComponent subject = this.getPredicateSubject();
        String result = !this.getID().equals(DEFAULT_ID) ? String.format(htmlOK ? "<b>%s: </b>" : "%s: ", this.getID()) : "";
        if (subject == null) {
            return "auto";
        }
        String verb = this.negated ? "is not" : "is";
        String subjectString = subject.getID();
        boolean foreign = !CompareUtilities.equals(this.getAncestorByType(Card.class), subject.getAncestorByType(Card.class));
        String format = "true";
        if (subject instanceof Card) {
            foreign = true;
            format = "Card %s %s in play";
        } else if (subject instanceof SceneLocation) {
            subjectString = subject.getIDPath(1, ".");
            format = "Location %2$s %1$s";
        } else if (subject instanceof SceneLayerState) {
            subjectString = subject.getIDPath(2, ".");
            format = "State %s %s active";
        } else if (subject instanceof CardLink) {
            subjectString = subject.getIDPath(2, ".");
            format = "Link %s %s active";
        } else if (subject instanceof LocationTransition) {
            subjectString = subject.getIDPath(2, ".");
            format = "Transition %s %s active";
        }
        if (htmlOK) {
            subjectString = "<i>" + subjectString + "</i>";
            if (foreign) {
                subjectString = "<font color=#BB7700>" + subjectString + "</font>";
            }
        }
        result = result + String.format(format, subjectString, verb);
        if (this.cardStatus == CardStatus.ON_GRID) {
            result = result + " (on grid)";
        } else if (this.cardStatus == CardStatus.AT_COORDS) {
            GridCoords coords = this.getRequiredCoords();
            result = result + String.format(" (row = %d, col = %d)", coords.getRow(), coords.getCol());
        }
        if (this.mouseOverOnly) {
            result = result + " (m)";
        }
        return htmlOK ? "<html>" + result + "</html>" : result;
    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<Predicate> {
        private static final String ELEMENT_NAME = "Predicate";
        private static final String ATTR_NEGATED = "negated";
        private static final String ATTR_MOUSE_OVER_ONLY = "mouseOverOnly";
        private static final String ATTR_SUBJECT = "subject";
        private static final String ATTR_CARD_STATUS = "cardStatus";
        private static final String ATTR_COORDS = "requiredCoords";

        public Transcoder() {
            super(ELEMENT_NAME, Predicate.class);
        }

        @Override
        protected void getAttributes(Predicate object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_NEGATED, Boolean.toString(object.negated));
            destination.put(ATTR_MOUSE_OVER_ONLY, Boolean.toString(object.mouseOverOnly));
            destination.put(ATTR_SUBJECT, object.predicateSubject.encode());
            destination.put(ATTR_CARD_STATUS, object.cardStatus.name());
            if (object.requiredCoords != null) {
                destination.put(ATTR_COORDS, object.requiredCoords.encode());
            }
        }

        @Override
        protected final Predicate decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            Predicate result = new Predicate(id);
            if (attributes.containsKey(ATTR_NEGATED)) {
                result.negated = Boolean.valueOf(attributes.get(ATTR_NEGATED));
            }
            if (attributes.containsKey(ATTR_MOUSE_OVER_ONLY)) {
                result.mouseOverOnly = Boolean.valueOf(attributes.get(ATTR_MOUSE_OVER_ONLY));
            }
            result.predicateSubject = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_SUBJECT));
            if (attributes.containsKey(ATTR_CARD_STATUS)) {
                result.cardStatus = CardStatus.valueOf(attributes.get(ATTR_CARD_STATUS));
            }
            if (attributes.containsKey(ATTR_COORDS)) {
                result.requiredCoords = new GridCoords(attributes.get(ATTR_COORDS));
            }
            return result;
        }
    }

    public static enum CardStatus {
        NONE{

            public String toString() {
                return "None";
            }
        }
        ,
        IN_PLAY{

            public String toString() {
                return "In Play";
            }
        }
        ,
        ON_GRID{

            public String toString() {
                return "On Grid";
            }
        }
        ,
        AT_COORDS{

            public String toString() {
                return "At Coords:";
            }
        };

    }

    public static enum Operator {
        ANY{

            public String toString() {
                return "Match Any";
            }
        }
        ,
        ALL{

            public String toString() {
                return "Match All";
            }
        }
        ,
        FORMULA{

            public String toString() {
                return "Use Formula";
            }
        };

    }
}

