/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundClip;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.InterpolatedViewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.StandardViewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.Viewpoint;
import com.sodiumarc.patchwork.collada.COLLADA;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.COLLADALoader;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraph;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Scene
extends ProjectComponent {
    public static final Icon SCENE_ICON = IconLoader.loadIcon("silk/world.png");
    public static final String REFERENCE_MESH_PREFIX = "REF";
    private File inputColladaFile;
    private SceneGraph sceneGraph;
    private final List<SceneLocation> locations;
    private final List<SceneLayer> sceneLayers;
    private Reference<SoundClip> ambientSound;

    public Scene(String id) {
        this(id, null);
        this.ambientSound = new Reference();
    }

    public List<SceneLocation> getLocations() {
        return this.locations;
    }

    public List<SceneLayer> getSceneLayers() {
        return this.sceneLayers;
    }

    public List<String> getSceneLayerIDs() {
        ArrayList<String> result = new ArrayList<String>();
        for (SceneLayer sceneLayer : this.sceneLayers) {
            result.add(sceneLayer.getID());
        }
        return result;
    }

    public SceneLayer getSceneLayer(String id) {
        for (SceneLayer sceneLayer : this.sceneLayers) {
            if (!sceneLayer.getID().equals(id)) continue;
            return sceneLayer;
        }
        return null;
    }

    public List<SceneLocationLayer> getLocationLayers(SceneLayer sceneLayer) {
        ArrayList<SceneLocationLayer> result = new ArrayList<SceneLocationLayer>();
        for (SceneLocation location : this.getLocations()) {
            result.addAll(location.getLocationLayers(sceneLayer));
        }
        return result;
    }

    public List<SceneLocation> getInterpLocations(final SceneLocation fromLocation, SceneLocation toLocation) {
        ArrayList<SceneLocation> result = new ArrayList<SceneLocation>();
        for (SceneLocation location : this.getLocations()) {
            boolean reverseInterp;
            Viewpoint viewpoint = location.getViewpoint();
            if (!(viewpoint instanceof InterpolatedViewpoint)) continue;
            InterpolatedViewpoint interpViewpoint = (InterpolatedViewpoint)viewpoint;
            boolean forwardInterp = fromLocation.equals(interpViewpoint.getFromLocation()) && toLocation.equals(interpViewpoint.getToLocation());
            boolean bl = reverseInterp = fromLocation.equals(interpViewpoint.getToLocation()) && toLocation.equals(interpViewpoint.getFromLocation());
            if (!forwardInterp && !reverseInterp) continue;
            result.add(location);
        }
        Collections.sort(result, new Comparator<SceneLocation>(){

            @Override
            public int compare(SceneLocation o1, SceneLocation o2) {
                InterpolatedViewpoint iv1 = (InterpolatedViewpoint)o1.getViewpoint();
                InterpolatedViewpoint iv2 = (InterpolatedViewpoint)o1.getViewpoint();
                double f1 = iv1.getInterpFraction();
                double f2 = iv2.getInterpFraction();
                if (iv1.getFromLocation().equals(fromLocation)) {
                    return Double.compare(f1, f2);
                }
                return Double.compare(f2, f1);
            }
        });
        result.add(0, fromLocation);
        result.add(toLocation);
        return result;
    }

    public void addLocation(SceneLocation location) {
        this.addLocation(location, true);
        location.updateFromScene();
    }

    public void removeLocation(SceneLocation location) {
        this.removeLocation(location, true);
    }

    public void setAmbientSound(SoundClip clip) {
        this.ambientSound = new Reference<SoundClip>((ProjectComponent)this, clip);
        this.fireModified();
    }

    public SoundClip getAmbientSound() {
        return this.ambientSound.resolve();
    }

    public File getInputFile() {
        return this.inputColladaFile;
    }

    public String getInputFilename() {
        File file = this.getInputFile();
        return file == null ? null : file.getName();
    }

    public void setInputFilename(String inputFilename) {
        this.inputColladaFile = inputFilename == null ? null : new File(this.getIODirectory(IOFileType.COLLADA), inputFilename);
        this.sceneGraph = null;
        this.fireModified();
    }

    public void reloadSceneGraph() {
        this.sceneGraph = null;
    }

    public SceneGraph getSceneGraph() {
        if (this.sceneGraph == null) {
            if (this.inputColladaFile == null) {
                return null;
            }
            COLLADA inputRoot = null;
            try {
                File colladaDir = this.getIODirectory(IOFileType.COLLADA);
                inputRoot = COLLADA.fromFile(new File(colladaDir, this.inputColladaFile.getName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            if (inputRoot != null) {
                this.sceneGraph = new COLLADALoader().load(inputRoot);
            }
        }
        return this.sceneGraph;
    }

    public List<String> getRefMeshIDs() {
        ArrayList<String> result = new ArrayList<String>();
        SceneGraph sceneGraph = this.getSceneGraph();
        if (sceneGraph != null) {
            Pattern idPattern = Pattern.compile("REF[^;]*");
            for (String meshID : this.getSceneGraph().getMeshIDs()) {
                if (!idPattern.matcher(meshID).matches()) continue;
                result.add(meshID);
            }
        }
        return result;
    }

    public List<String> getCameraIDs() {
        ArrayList<String> result = new ArrayList<String>();
        SceneGraph sceneGraph = this.getSceneGraph();
        if (sceneGraph != null) {
            for (Camera camera : sceneGraph.getCameras().values()) {
                result.add(camera.getId());
            }
        }
        return result;
    }

    public List<String> getFrameMeshIDs(String cameraID) {
        Camera camera;
        ArrayList<String> result = new ArrayList<String>();
        SceneGraph sceneGraph = this.getSceneGraph();
        if (sceneGraph != null && (camera = sceneGraph.getCamera(cameraID)) != null) {
            Set<PolyMesh3D> frameMeshes = camera.getDescendantMeshesMatching(StandardViewpoint.getFrameMeshPattern(camera.getId()));
            for (PolyMesh3D mesh : frameMeshes) {
                result.add(mesh.getIdentifier());
            }
        }
        return result;
    }

    public final void autoLoadImages() {
        for (SceneLocation location : this.getLocations()) {
            location.autoLoadImages();
        }
    }

    public void updateFromSceneGraph() {
        for (String cameraID : this.getCameraIDs()) {
            for (String frameMeshID : this.getFrameMeshIDs(cameraID)) {
                if (this.containsSceneGraphLocation(cameraID, frameMeshID)) continue;
                String id = StandardViewpoint.toLocationID(cameraID, frameMeshID);
                SceneLocation location = new SceneLocation(id);
                location.setViewpoint(new StandardViewpoint("viewpoint", cameraID, frameMeshID));
                this.addLocation(location, true);
            }
        }
        for (String meshID : this.getRefMeshIDs()) {
            SceneLayer layer = this.getLayerByRefMeshID(meshID);
            if (layer == null) {
                layer = new SceneLayer(SceneLayer.toSceneLayerID(meshID));
                this.addLayer(layer, true);
                layer.setRefMeshID(meshID);
            }
            layer.updateFromSceneGraph();
        }
        for (SceneLocation location : this.locations) {
            location.updateFromScene();
        }
        this.fireModified();
    }

    @Override
    public Icon getIcon() {
        return SCENE_ICON;
    }

    @Override
    public Card getParentComponent() {
        return (Card)super.getParentComponent();
    }

    @Override
    public void addChildComponent(ProjectComponent child, int insertIndex) {
        if (child instanceof SceneLocation) {
            this.addLocation((SceneLocation)child, true);
        } else if (child instanceof SceneLayer) {
            this.addLayer((SceneLayer)child, true);
        }
    }

    @Override
    public void addChildComponent(String id, Class<? extends ProjectComponent> type) {
        if (type.equals(SceneLocation.class)) {
            this.addLocation(new SceneLocation(id));
        } else if (type.equals(SceneLayer.class)) {
            this.addLayer(new SceneLayer(id), true);
        }
    }

    @Override
    public void removeChildComponent(ProjectComponent child) {
        if (child instanceof SceneLocation) {
            this.removeLocation((SceneLocation)child);
        } else if (child instanceof SceneLayer) {
            this.removeLayer((SceneLayer)child, true);
        }
    }

    @Override
    public String toString() {
        return this.getID();
    }

    private Scene(String id, File inputColladaFile) {
        super(id);
        this.inputColladaFile = inputColladaFile;
        this.locations = new ArrayList<SceneLocation>();
        this.sceneLayers = new ArrayList<SceneLayer>();
        this.registerChildType(SceneLocation.class, SceneLocation.LOCATION_ICON, true);
        this.registerChildType(SceneLayer.class, SceneLayer.ICON, true);
    }

    private SceneLayer getLayerByRefMeshID(String refMeshID) {
        for (SceneLayer sceneLayer : this.sceneLayers) {
            if (!sceneLayer.getRefMeshID().equals(refMeshID)) continue;
            return sceneLayer;
        }
        return null;
    }

    private void addLocation(SceneLocation location, boolean notify) {
        this.locations.add(location);
        this.registerChild(location, notify);
    }

    private void removeLocation(SceneLocation location, boolean notify) {
        this.locations.remove(location);
        this.removeChild(location, notify);
    }

    private void addLayer(SceneLayer layer, boolean notify) {
        this.sceneLayers.add(layer);
        this.registerChild(layer, notify);
    }

    private void removeLayer(SceneLayer layer, boolean notify) {
        this.sceneLayers.remove(layer);
        this.removeChild(layer, notify);
    }

    private boolean containsSceneGraphLocation(String cameraID, String frameMeshID) {
        for (SceneLocation location : this.locations) {
            StandardViewpoint sgViewpoint;
            Viewpoint viewpoint = location.getViewpoint();
            if (!(viewpoint instanceof StandardViewpoint) || !(sgViewpoint = (StandardViewpoint)viewpoint).getCameraID().equals(cameraID) || !sgViewpoint.getFrameMeshID().equals(frameMeshID)) continue;
            return true;
        }
        return false;
    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<Scene> {
        private static final String ELEMENT_NAME = "Scene";
        private static final String ATTR_INPUT_FILENAME = "inputFilename";
        private static final String FIELD_SCENE_LAYERS = "sceneLayers";
        private static final String FIELD_SCENE_LOCATIONS = "sceneLocations";
        private static final String ATTR_AMBIENT_SOUND = "ambientSound";

        public Transcoder() {
            super(ELEMENT_NAME, Scene.class);
            this.setFieldTranscoder(FIELD_SCENE_LOCATIONS, new SceneLocation.Transcoder());
            this.setFieldTranscoder(FIELD_SCENE_LAYERS, new SceneLayer.Transcoder());
        }

        @Override
        protected Scene decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            File inputFile = null;
            if (attributes.containsKey(ATTR_INPUT_FILENAME)) {
                inputFile = new File(attributes.get(ATTR_INPUT_FILENAME));
            }
            Scene result = new Scene(id, inputFile);
            for (Object location : decodedChildren.getAll(FIELD_SCENE_LOCATIONS)) {
                result.addLocation((SceneLocation)location, false);
            }
            for (Object layer : decodedChildren.getAll(FIELD_SCENE_LAYERS)) {
                result.addLayer((SceneLayer)layer, false);
            }
            result.ambientSound = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_AMBIENT_SOUND));
            return result;
        }

        @Override
        protected void getAttributes(Scene object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            if (object.inputColladaFile != null) {
                destination.put(ATTR_INPUT_FILENAME, object.inputColladaFile.toString());
            }
            destination.put(ATTR_AMBIENT_SOUND, object.ambientSound.encode());
        }

        @Override
        protected void getChildren(Scene object, MultiMap<String, Object> destination) {
            for (SceneLocation location : object.getLocations()) {
                destination.putLast(FIELD_SCENE_LOCATIONS, location);
            }
            for (SceneLayer layer : object.getSceneLayers()) {
                destination.putLast(FIELD_SCENE_LAYERS, layer);
            }
        }
    }
}

