/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model;

import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReferenceList<T extends ProjectComponent> {
    private final ProjectComponent owner;
    private final List<String> guids;
    private List<T> referentList;
    private static final String DELIMITER = ",";

    public ReferenceList() {
        this.owner = null;
        this.guids = new ArrayList<String>();
    }

    public ReferenceList(ProjectComponent owner, String encodedForm) {
        this.owner = owner;
        this.guids = encodedForm == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(encodedForm.split(DELIMITER)));
    }

    public List<T> resolve() {
        if (this.referentList != null) {
            return this.referentList;
        }
        if (this.guids == null) {
            return null;
        }
        this.referentList = new ArrayList<T>();
        for (String guid : this.guids) {
            CollectionUtils.addIfNotNull(this.referentList, this.owner.getPath().get(0).getDescendant(guid));
        }
        return this.referentList;
    }

    public String encode() {
        this.resolve();
        if (this.referentList != null) {
            this.guids.clear();
            for (ProjectComponent referent : this.referentList) {
                this.guids.add(referent.getGUID());
            }
        }
        return StringUtils.toDelimitedList(this.guids, DELIMITER);
    }
}

