/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model;

import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;

public class Reference<T extends ProjectComponent> {
    private final ProjectComponent owner;
    private final String guid;
    private T referent;

    public Reference() {
        this.owner = null;
        this.guid = null;
    }

    public Reference(ProjectComponent owner, String guid) {
        this.owner = owner;
        this.guid = guid;
    }

    public Reference(ProjectComponent owner, T referent) {
        this(owner, referent == null ? null : ((ProjectComponent)referent).getGUID());
        this.referent = referent;
    }

    public T resolve() {
        if (this.referent != null) {
            return this.referent;
        }
        if (this.guid == null) {
            return null;
        }
        this.referent = this.owner.getPath().get(0).getDescendant(this.guid);
        return this.referent;
    }

    public String encode() {
        this.resolve();
        if (this.referent != null) {
            return ((ProjectComponent)this.referent).getGUID();
        }
        return this.guid;
    }
}

