/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model;

import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponentListener;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.CompareUtilities;
import com.sodiumarc.patchwork.util.xml.SimpleTranscoder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.Icon;

public abstract class ProjectComponent
implements Comparable<ProjectComponent> {
    private String id;
    private String guid;
    private long lastModified;
    private ProjectComponent parentComponent;
    private final List<ProjectComponent> childComponents;
    private final List<ProjectComponent> treeChildComponents;
    private Comparator<ProjectComponent> childComparator = DEFAULT_CHILD_COMPARATOR;
    private final List<ProjectComponentListener> listeners;
    private final Map<Class<? extends ProjectComponent>, Icon> childTypes;
    private final Set<Class<? extends ProjectComponent>> mutableChildTypes;
    private static final Comparator<ProjectComponent> DEFAULT_CHILD_COMPARATOR = new Comparator<ProjectComponent>(){

        @Override
        public int compare(ProjectComponent o1, ProjectComponent o2) {
            return o1.compareTo(o2);
        }
    };

    public ProjectComponent(String id) {
        assert (id != null) : "null id not allowed";
        this.id = id;
        this.childComponents = new ArrayList<ProjectComponent>();
        this.treeChildComponents = new ArrayList<ProjectComponent>();
        this.listeners = new ArrayList<ProjectComponentListener>();
        this.childTypes = new HashMap<Class<? extends ProjectComponent>, Icon>();
        this.mutableChildTypes = new HashSet<Class<? extends ProjectComponent>>();
        this.guid = id + "-" + UUID.randomUUID();
    }

    public final void setID(String id) {
        assert (id != null) : "null id not allowed";
        if (!CompareUtilities.equals(this.id, id)) {
            this.fireModified(this.getPath());
            this.id = id;
        }
    }

    public final String getID() {
        return this.id;
    }

    public final String getIDPath(int ancestorLevels) {
        return this.getIDPath(ancestorLevels, ".");
    }

    public final String getIDPath(int ancestorLevels, String separator) {
        String result = this.getID();
        ProjectComponent component = this;
        for (int i = 0; i < ancestorLevels; ++i) {
            result = component.getParentComponent() + separator + result;
            if ((component = component.getParentComponent()) == null) break;
        }
        return result;
    }

    public String getGUID() {
        return this.guid;
    }

    public boolean isUniqueSiblingID(String id) {
        for (ProjectComponent sibling : this.getSiblingComponents()) {
            if (!sibling.getID().equals(id)) continue;
            return false;
        }
        return true;
    }

    public boolean isUniqueChildID(String id) {
        for (ProjectComponent child : this.getChildComponents()) {
            if (!child.getID().equals(id)) continue;
            return false;
        }
        return true;
    }

    public String newUniqueChildID(String desiredID) {
        String id = desiredID;
        int index = 1;
        while (!this.isUniqueChildID(id)) {
            id = desiredID + " " + index;
            ++index;
        }
        return id;
    }

    public String getDisplayName(boolean htmlOK) {
        return this.getID();
    }

    public abstract Icon getIcon();

    public File getIODirectory(IOFileType key) {
        if (this.parentComponent != null) {
            return this.parentComponent.getIODirectory(key);
        }
        return key.getDefaultInputDir();
    }

    public ProjectComponent getParentComponent() {
        return this.parentComponent;
    }

    public ProjectComponent getDescendant(String guid) {
        if (this.guid.equals(guid)) {
            return this;
        }
        for (ProjectComponent child : this.getChildComponents()) {
            ProjectComponent childResult = child.getDescendant(guid);
            if (childResult == null) continue;
            return childResult;
        }
        return null;
    }

    public <T extends ProjectComponent> T getAncestorByType(Class<T> type) {
        List<ProjectComponent> path = this.getPath();
        for (int i = path.size() - 1; i >= 0; --i) {
            ProjectComponent ancestor = path.get(i);
            if (!type.isAssignableFrom(ancestor.getClass())) continue;
            return (T)ancestor;
        }
        return null;
    }

    public <T extends ProjectComponent> Collection<T> getDescendantsByType(Class<T> type, Collection<T> result) {
        for (ProjectComponent child : this.getChildComponents()) {
            if (type.isAssignableFrom(child.getClass())) {
                result.add(child);
            }
            child.getDescendantsByType(type, result);
        }
        return result;
    }

    public <T extends ProjectComponent> Collection<T> getDescendantsByType(Class<T> type) {
        ArrayList result = new ArrayList();
        return this.getDescendantsByType(type, result);
    }

    public List<ProjectComponent> getSiblingComponents() {
        ArrayList<ProjectComponent> result = new ArrayList<ProjectComponent>();
        ProjectComponent parent = this.getParentComponent();
        if (parent == null) {
            return Collections.emptyList();
        }
        for (ProjectComponent sibling : parent.getChildComponents()) {
            if (sibling == this) continue;
            result.add(sibling);
        }
        return result;
    }

    public final void setParentComponent(ProjectComponent parentComponent) {
        this.parentComponent = parentComponent;
    }

    public List<ProjectComponent> getChildComponents() {
        return this.childComponents;
    }

    public List<ProjectComponent> getTreeChildComponents() {
        return this.treeChildComponents;
    }

    public void addChildComponent(String id, Class<? extends ProjectComponent> type) {
    }

    public void addChildComponent(ProjectComponent child, int insertIndex) {
    }

    public void removeChildComponent(ProjectComponent child) {
    }

    public List<ProjectComponent> getPath() {
        ProjectComponent parent = this.getParentComponent();
        if (parent == null) {
            return Collections.singletonList(this);
        }
        ArrayList<ProjectComponent> result = new ArrayList<ProjectComponent>(parent.getPath());
        result.add(this);
        return result;
    }

    public final Map<Class<? extends ProjectComponent>, Icon> getAddableChildTypes() {
        HashMap<Class<? extends ProjectComponent>, Icon> result = new HashMap<Class<? extends ProjectComponent>, Icon>();
        for (Class<? extends ProjectComponent> childType : this.mutableChildTypes) {
            result.put(childType, this.childTypes.get(childType));
        }
        return result;
    }

    public final boolean isChildRemovable(Class<? extends ProjectComponent> childType) {
        return this.mutableChildTypes.contains(childType);
    }

    public final boolean isRemovable() {
        ProjectComponent parent = this.getParentComponent();
        if (parent == null) {
            return false;
        }
        return parent.isChildRemovable(this.getClass());
    }

    public ProjectComponent resolveGUID(String guid) {
        return this.getPath().get(0).getDescendant(guid);
    }

    public final void addListener(ProjectComponentListener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(ProjectComponentListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int compareTo(ProjectComponent o) {
        if (!o.getClass().equals(this.getClass())) {
            return this.getClass().getSimpleName().compareTo(o.getClass().getSimpleName());
        }
        return this.getID().compareTo(o.getID());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectComponent other = (ProjectComponent)obj;
        return CompareUtilities.equals(this.guid, other.guid);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.guid == null ? 0 : this.guid.hashCode());
        return result;
    }

    public String toString() {
        return this.getID();
    }

    protected void descendantModified(List<ProjectComponent> modifiedPath) {
    }

    protected final void registerChildType(Class<? extends ProjectComponent> type, Icon icon, boolean mutable) {
        this.childTypes.put(type, icon);
        if (mutable) {
            this.mutableChildTypes.add(type);
        }
    }

    protected final void registerChild(ProjectComponent child, boolean notify) {
        this.registerChild(child, true, notify);
    }

    protected final void registerChild(ProjectComponent child, boolean isTreeChild, boolean notify) {
        child.setParentComponent(this);
        this.childComponents.add(child);
        if (isTreeChild) {
            int index;
            for (index = 0; index < this.treeChildComponents.size() && this.childComparator.compare(child, this.treeChildComponents.get(index)) > 0; ++index) {
            }
            this.treeChildComponents.add(index, child);
            if (notify) {
                this.fireChildAdded(this.getPath(), child, index);
            }
        }
    }

    protected final void removeChild(ProjectComponent child, boolean notify) {
        child.setParentComponent(null);
        this.childComponents.remove(child);
        int index = this.treeChildComponents.indexOf(child);
        this.treeChildComponents.remove(child);
        if (notify) {
            this.fireChildRemoved(this.getPath(), child, index);
        }
    }

    protected final void removeAllChildren(boolean notify) {
        ArrayList<ProjectComponent> formerChildren = new ArrayList<ProjectComponent>(this.getChildComponents());
        for (ProjectComponent child : formerChildren) {
            this.removeChild(child, notify);
        }
    }

    protected void setChildComparator(Comparator<ProjectComponent> comparator) {
        this.childComparator = comparator == null ? DEFAULT_CHILD_COMPARATOR : comparator;
    }

    protected final void fireModified(List<ProjectComponent> modifiedPath) {
        if (modifiedPath.get(modifiedPath.size() - 1) == this) {
            this.lastModified = System.currentTimeMillis();
        }
        this.descendantModified(modifiedPath);
        for (ProjectComponentListener listener : this.listeners) {
            listener.modified(modifiedPath);
        }
        ProjectComponent parent = this.getParentComponent();
        if (parent != null) {
            parent.fireModified(modifiedPath);
        }
    }

    protected final void fireModified() {
        this.fireModified(this.getPath());
    }

    protected final void fireChildAdded(List<ProjectComponent> parentPath, ProjectComponent child, int index) {
        for (ProjectComponentListener listener : this.listeners) {
            listener.childComponentAdded(parentPath, child, index);
        }
        ProjectComponent parent = this.getParentComponent();
        if (parent != null) {
            parent.fireChildAdded(parentPath, child, index);
        }
    }

    protected final void fireChildRemoved(List<ProjectComponent> parentPath, ProjectComponent child, int index) {
        for (ProjectComponentListener listener : this.listeners) {
            listener.childComponentRemoved(parentPath, child, index);
        }
        ProjectComponent parent = this.getParentComponent();
        if (parent != null) {
            parent.fireChildRemoved(parentPath, child, index);
        }
    }

    protected long getLastModified() {
        return this.lastModified;
    }

    public static abstract class Transcoder<T extends ProjectComponent>
    extends SimpleTranscoder<T> {
        private static final String ATTR_ID = "id";
        private static final String ATTR_GUID = "guid";
        private static final String ATTR_LAST_MODIFIED = "lastModified";

        protected Transcoder(String elementName, Class<T> decodedType) {
            super(elementName, decodedType);
        }

        protected Transcoder(String elementName, String decodeElementName, Class<T> decodedType) {
            super(elementName, decodeElementName, decodedType);
        }

        @Override
        protected void getAttributes(T object, Map<String, String> destination) {
            destination.put(ATTR_ID, ((ProjectComponent)object).getID());
            destination.put(ATTR_GUID, ((ProjectComponent)object).guid);
            destination.put(ATTR_LAST_MODIFIED, Long.toString(((ProjectComponent)object).lastModified));
        }

        @Override
        protected T decode(Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            T result = this.decode(attributes.get(ATTR_ID), attributes, decodedChildren);
            String guid = attributes.get(ATTR_GUID);
            if (guid != null) {
                ((ProjectComponent)result).guid = guid;
            }
            if (attributes.containsKey(ATTR_LAST_MODIFIED)) {
                ((ProjectComponent)result).lastModified = Long.parseLong(attributes.get(ATTR_LAST_MODIFIED));
            }
            return result;
        }

        protected abstract T decode(String var1, Map<String, String> var2, MultiMap<String, Object> var3);
    }
}

