/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model;

import com.sodiumarc.patchwork.animation.AbstractAnimation;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.InterpFunction;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.SimpleViewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.Viewpoint;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.TransformAnimator;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.VectorUtils;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Vector3d;

public class LocationTransitionAnimation
extends AbstractAnimation {
    private final String id;
    private SceneLocation fromLocation;
    private SceneLocation toLocation;
    private float pseudoInertia = 1.0f;
    private Viewpoint fromViewpoint;
    private Viewpoint toViewpoint;
    private final SimpleViewpoint vp;
    private TransformAnimator<Vector3d> positionKeyframes;
    private int startKeyframe;

    public LocationTransitionAnimation(String id) {
        this.id = id;
        this.vp = new SimpleViewpoint();
    }

    public LocationTransitionAnimation(String id, SceneLocation fromLocation, SceneLocation toLocation) {
        this(id);
        this.setFromLocation(fromLocation);
        this.setToLocation(toLocation);
    }

    public Viewpoint getViewPoint() {
        return this.vp;
    }

    public SceneLocation getFromLocation() {
        return this.fromLocation;
    }

    public void setFromLocation(SceneLocation location) {
        this.fromLocation = location;
    }

    public SceneLocation getToLocation() {
        return this.toLocation;
    }

    public void setToLocation(SceneLocation location) {
        this.toLocation = location;
    }

    public Viewpoint getFromViewpoint() {
        if (this.fromViewpoint != null) {
            return this.fromViewpoint;
        }
        if (this.fromLocation != null) {
            return this.fromLocation.getViewpoint();
        }
        return null;
    }

    public void setFromViewpoint(Viewpoint fromViewpoint) {
        this.fromViewpoint = fromViewpoint;
    }

    public Viewpoint getToViewpoint() {
        if (this.toViewpoint != null) {
            return this.toViewpoint;
        }
        if (this.toLocation != null) {
            return this.toLocation.getViewpoint();
        }
        return null;
    }

    public void setToViewpoint(Viewpoint toViewpoint) {
        this.toViewpoint = toViewpoint;
    }

    public List<SceneLocation> getTransitionLocations() {
        if (this.fromLocation == null || this.toLocation == null) {
            return Collections.emptyList();
        }
        Scene scene = this.fromLocation.getParentComponent();
        return scene.getInterpLocations(this.fromLocation, this.toLocation);
    }

    public void setPositionKeyframes(TransformAnimator<Vector3d> positionKeyframes) {
        this.positionKeyframes = positionKeyframes;
    }

    public void setStartKeyframe(int startKeyframe) {
        this.startKeyframe = startKeyframe;
    }

    public void setPseudoInertia(float pseudoInertia) {
        this.pseudoInertia = MathUtils.clamp(pseudoInertia, 0.0f, 1.0f);
    }

    public LocationTransitionAnimation getBackgroundAnimation() {
        SceneLocation fromBG = this.fromLocation.getBackgroundLocation();
        SceneLocation toBG = this.toLocation.getBackgroundLocation();
        if (fromBG == null || toBG == null) {
            return null;
        }
        return new LocationTransitionAnimation(this.id + "-BG", fromBG, toBG);
    }

    @Override
    protected void elapsedFractionChanged(float elapsedFraction) {
        Camera camera;
        float adjustedFaction = this.getInertiaAdjustedFraction(elapsedFraction);
        Viewpoint fromViewpoint = this.getFromViewpoint();
        Viewpoint toViewpoint = this.getToViewpoint();
        if (fromViewpoint == null || toViewpoint == null) {
            return;
        }
        Rectangle4d viewport = fromViewpoint.getViewport().interpolate(toViewpoint.getViewport(), adjustedFaction);
        this.vp.setViewport(viewport);
        Camera fromCamera = fromViewpoint.getCamera();
        Camera toCamera = toViewpoint.getCamera();
        Vector3d keyframeOffset = this.getKeyframeOffset(adjustedFaction);
        if (keyframeOffset != null) {
            camera = fromCamera.createOffsetCamera(this.id, keyframeOffset, false);
        } else {
            Vector3d deltaVector = VectorUtils.scaledDelataVector(fromCamera.getGlobalPosition(), toCamera.getGlobalPosition(), adjustedFaction);
            camera = fromCamera.createOffsetCamera(this.id, deltaVector, false);
        }
        this.vp.setCamera(camera);
    }

    private Vector3d getKeyframeOffset(float elapsedFraction) {
        if (this.positionKeyframes == null) {
            return null;
        }
        Vector3d absolute = this.positionKeyframes.getValueAt(MathUtils.interpolate(elapsedFraction, this.startKeyframe, this.positionKeyframes.getLastKeyframe()));
        Vector3d result = new Vector3d(absolute);
        result.sub(this.positionKeyframes.getValueAt(this.startKeyframe));
        return result;
    }

    private float getInertiaAdjustedFraction(float elapsedFraction) {
        if (this.pseudoInertia == 0.0f) {
            return elapsedFraction;
        }
        return (float)MathUtils.interpolate(this.pseudoInertia, elapsedFraction, InterpFunction.SINE.getInterpFraction(elapsedFraction));
    }
}

