/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.as3;

import com.sodiumarc.patchwork.generate.GeneratorResourceIO;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TemplateLibrary {
    public static String TEMPLATE_ELEMENT_NAME = "template";
    public static String TEMPLATE_ID_ATTR_NAME = "id";
    private final Map<String, StringTemplate> templatesByID = new HashMap<String, StringTemplate>();
    private static DocumentNodeDecoder<StringTemplate> TEMPLATE_DECODER = new DocumentNodeDecoder<StringTemplate>(){

        @Override
        public StringTemplate decode(Node node) {
            Set<String> parameterNames;
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(TEMPLATE_ELEMENT_NAME)) {
                return null;
            }
            String id = XMLUtils.getAttribute(node, TEMPLATE_ID_ATTR_NAME);
            List<StringTemplate> subtemplates = XMLUtils.decodeChildren(node, TEMPLATE_DECODER);
            String templateText = CollectionUtils.first(XMLUtils.getChildText(node));
            StringTemplate result = new StringTemplate(id, templateText);
            try {
                parameterNames = result.getParameterNames();
            }
            catch (ParseException e) {
                Logger.getLogger(TemplateLibrary.class).warn("Failed to decode template", e);
                return null;
            }
            for (StringTemplate subtemplate : subtemplates) {
                if (!parameterNames.contains(subtemplate.getId())) continue;
                result.addSubtemplate(subtemplate.getId(), subtemplate);
            }
            return result;
        }
    };

    public TemplateLibrary(String filename) throws IOException, ParserConfigurationException, SAXException {
        Document document = GeneratorResourceIO.getInstance().getXMLDocument(filename);
        List<StringTemplate> templates = XMLUtils.decodeChildren((Node)document.getDocumentElement(), TEMPLATE_DECODER);
        for (StringTemplate template : templates) {
            this.templatesByID.put(template.getId(), template);
        }
    }

    public TemplateLibrary(File file) throws IOException, ParserConfigurationException, SAXException {
        Document document = XMLUtils.getXMLDocument(file, true);
        List<StringTemplate> templates = XMLUtils.decodeChildren((Node)document.getDocumentElement(), TEMPLATE_DECODER);
        for (StringTemplate template : templates) {
            this.templatesByID.put(template.getId(), template);
        }
    }

    public StringTemplate getTemplate(String id) {
        return this.templatesByID.get(id);
    }

    public StringTemplate getTemplate(Class<?> clazz) {
        return this.getTemplate(clazz, null);
    }

    public StringTemplate getTemplate(Class<?> clazz, String name) {
        String id = clazz.getSimpleName();
        if (name != null) {
            id = id + "." + name;
        }
        return this.templatesByID.get(id);
    }
}

