/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.as3;

import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3Converter;
import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3Convertible;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.util.StringUtils;
import java.awt.Point;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class AS3ConversionUtils {
    public static final String AS3_EXTENSION = "as";

    public static <T> String toAS3String(List<T> objects, AS3Converter<T> converter) {
        StringBuilder result = new StringBuilder();
        for (T obj : objects) {
            String converted = converter.convert(obj);
            if (converted == null) continue;
            result.append(converted);
        }
        return result.toString();
    }

    public static List<String> toAS3String(List<? extends AS3Convertible> convertibles, TemplateLibrary templates) throws ParseException {
        ArrayList<String> result = new ArrayList<String>();
        for (AS3Convertible aS3Convertible : convertibles) {
            result.add(aS3Convertible.toAS3String(templates));
        }
        return result;
    }

    public static String toDelimitedList(List<? extends AS3Convertible> convertibles, TemplateLibrary templates, String delimiter) throws ParseException {
        ArrayList<String> result = new ArrayList<String>();
        for (AS3Convertible aS3Convertible : convertibles) {
            result.add(aS3Convertible.toAS3String(templates));
        }
        return StringUtils.toDelimitedList(AS3ConversionUtils.toAS3String(convertibles, templates), delimiter);
    }

    public static String toArrayLiteral(Iterable<?> elements) {
        if (elements == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        String delimList = StringUtils.toDelimitedList(elements, ",");
        if (delimList != null) {
            sb.append(delimList);
        }
        sb.append("]");
        return sb.toString();
    }

    public static String createPointDeclaration(Point point) {
        return String.format("new Point(%1$d,%2$d)", point.x, point.y);
    }

    public static String format(String as3String) {
        Pattern openBlockPattern = Pattern.compile(".*\\{");
        Pattern closeBlockPattern = Pattern.compile("\\s*\\}");
        Pattern lineTermPattern = Pattern.compile(".*;");
        Pattern commentLinePattern = Pattern.compile("(/*\\*.*\\*/|//.*)");
        StringBuilder sb = new StringBuilder();
        String[] lines = as3String.split("[\n\r]+");
        String lastLineNoComment = "";
        int indentLevel = 0;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.isEmpty()) continue;
            String lineNoComment = line.split("//")[0].trim();
            boolean newline = false;
            if (sb.length() > 0) {
                if (commentLinePattern.matcher(line).matches()) {
                    sb.append("\n");
                    newline = true;
                }
                if (lineTermPattern.matcher(lastLineNoComment).matches() || closeBlockPattern.matcher(lastLineNoComment).matches() || commentLinePattern.matcher(lastLineNoComment).matches()) {
                    newline = true;
                } else if (openBlockPattern.matcher(lastLineNoComment).matches()) {
                    ++indentLevel;
                    newline = true;
                }
                if (closeBlockPattern.matcher(lineNoComment).matches()) {
                    --indentLevel;
                }
                if (newline) {
                    sb.append("\n");
                    for (int s = 0; s < indentLevel; ++s) {
                        sb.append("   ");
                    }
                } else {
                    sb.append(" ");
                }
            }
            sb.append(line);
            lastLineNoComment = lineNoComment;
        }
        return sb.toString();
    }

    private AS3ConversionUtils() {
    }
}

