/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.MarginsPanel;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerApp;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentPanel;
import com.sodiumarc.patchwork.app.scenecomposer.Tuple3dPanel;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.StandardViewpoint;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.vecmath.Vector3d;

public class StandardViewpointPanel
extends ProjectComponentPanel<StandardViewpoint> {
    private JComboBox cameraIDCombo;
    private ActionListener cameraIDComboListener;
    private JComboBox frameMeshIDCombo;
    private ActionListener frameMeshIDComboListener;
    private Tuple3dPanel camLocationPanel;
    private JSpinner scaleSpinner;
    private Tuple3dPanel camOffsetPanel;
    private MarginsPanel viewportMarginsPanel;

    @Override
    protected JComponent getMainArea() {
        this.cameraIDCombo = new JComboBox();
        this.cameraIDComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardViewpoint target = (StandardViewpoint)StandardViewpointPanel.this.getTarget();
                if (target != null) {
                    target.setCameraID((String)StandardViewpointPanel.this.cameraIDCombo.getSelectedItem());
                    StandardViewpointPanel.this.updateFrameMeshIDCombo();
                    StandardViewpointPanel.this.updateViewportPanels();
                    StandardViewpointPanel.this.fireTargetModified();
                }
            }
        };
        this.frameMeshIDCombo = new JComboBox();
        this.frameMeshIDComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardViewpoint target = (StandardViewpoint)StandardViewpointPanel.this.getTarget();
                if (target != null) {
                    target.setFrameMeshID((String)StandardViewpointPanel.this.frameMeshIDCombo.getSelectedItem());
                    StandardViewpointPanel.this.updateViewportPanels();
                    StandardViewpointPanel.this.fireTargetModified();
                }
            }
        };
        JButton updateButton = new JButton("Update");
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardViewpoint target = (StandardViewpoint)StandardViewpointPanel.this.getTarget();
                if (target != null) {
                    target.getAncestorByType(Scene.class).reloadSceneGraph();
                    target.updateFromSceneGraph();
                    StandardViewpointPanel.this.targetSet();
                    StandardViewpointPanel.this.fireTargetModified();
                }
            }
        });
        this.camLocationPanel = new Tuple3dPanel(){

            @Override
            protected void valueChanged() {
                StandardViewpoint target = (StandardViewpoint)StandardViewpointPanel.this.getTarget();
                if (target != null) {
                    Vector3d translation = StandardViewpointPanel.this.camLocationPanel.getValue(new Vector3d());
                    target.setCameraLocation(translation);
                    StandardViewpointPanel.this.fireTargetModified();
                }
            }
        };
        this.camLocationPanel.setEnabled(false);
        this.scaleSpinner = this.makeSpinner();
        this.scaleSpinner.setEnabled(false);
        this.camOffsetPanel = new Tuple3dPanel(){

            @Override
            protected void valueChanged() {
                StandardViewpoint target = (StandardViewpoint)StandardViewpointPanel.this.getTarget();
                if (target != null) {
                    Vector3d translation = StandardViewpointPanel.this.camOffsetPanel.getValue(new Vector3d());
                    target.setCameraOffset(translation);
                    StandardViewpointPanel.this.fireTargetModified();
                }
            }
        };
        this.viewportMarginsPanel = new MarginsPanel("Viewport (Blender Relative)"){

            @Override
            protected void marginsChanged() {
                StandardViewpoint target = (StandardViewpoint)StandardViewpointPanel.this.getTarget();
                if (target != null) {
                    Rectangle4d marginsRegion = StandardViewpointPanel.this.viewportMarginsPanel.getMarginsRegion();
                    target.setViewport(PatchworkComposerApp.BLENDER_VIEWPORT.fromProportional(marginsRegion));
                    StandardViewpointPanel.this.fireTargetModified();
                }
            }

            @Override
            protected void marginsCleared() {
            }
        };
        this.viewportMarginsPanel.setEnabled(false);
        ArrayList<LabeledRowPanel.LabeledRow> colladaRows = new ArrayList<LabeledRowPanel.LabeledRow>();
        colladaRows.add(new LabeledRowPanel.LabeledRow("Camera ID:", (Component)this.cameraIDCombo, true));
        colladaRows.add(new LabeledRowPanel.LabeledRow("Frame Mesh ID:", (Component)this.frameMeshIDCombo, true));
        colladaRows.add(new LabeledRowPanel.LabeledRow((String)null, (Component)updateButton));
        ArrayList<LabeledRowPanel.LabeledRow> cameraRows = new ArrayList<LabeledRowPanel.LabeledRow>();
        cameraRows.add(new LabeledRowPanel.LabeledRow("Camera Position:", (Component)this.camLocationPanel));
        cameraRows.add(new LabeledRowPanel.LabeledRow("Camera Scale:", (Component)this.scaleSpinner));
        cameraRows.add(new LabeledRowPanel.LabeledRow("Camera Offset:", (Component)this.camOffsetPanel));
        JPanel result = new JPanel(new BorderLayout(0, 10));
        result.add((Component)new LabeledRowPanel("COLLADA link", colladaRows), "North");
        result.add((Component)new LabeledRowPanel(cameraRows), "Center");
        result.add((Component)this.viewportMarginsPanel, "South");
        return result;
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        StandardViewpoint target = (StandardViewpoint)this.getTarget();
        if (target != null) {
            this.scaleSpinner.setValue(target.getCamera().getGlobalScale());
        } else {
            this.scaleSpinner.setValue(0);
        }
        this.updateCameraIDCombo();
        this.updateFrameMeshIDCombo();
        this.updateViewportPanels();
    }

    private JSpinner makeSpinner() {
        JSpinner result = new JSpinner(new SpinnerNumberModel(0.0, -100000.0, 100000.0, 0.1));
        ((JSpinner.DefaultEditor)result.getEditor()).getTextField().setColumns(5);
        return result;
    }

    private void updateCameraIDCombo() {
        StandardViewpoint target = (StandardViewpoint)this.getTarget();
        this.cameraIDCombo.removeActionListener(this.cameraIDComboListener);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel();
        String selectedItem = null;
        if (target != null) {
            Scene scene = target.getAncestorByType(Scene.class);
            List<String> cameraIDs = scene.getCameraIDs();
            cameraIDs.add(0, null);
            model = new DefaultComboBoxModel<Object>(cameraIDs.toArray());
            selectedItem = target.getCameraID();
        }
        this.cameraIDCombo.setModel(model);
        this.cameraIDCombo.setSelectedItem(selectedItem);
        this.cameraIDCombo.addActionListener(this.cameraIDComboListener);
    }

    private void updateFrameMeshIDCombo() {
        String cameraID;
        StandardViewpoint target = (StandardViewpoint)this.getTarget();
        this.frameMeshIDCombo.removeActionListener(this.frameMeshIDComboListener);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel();
        String selectedItem = null;
        if (target != null && (cameraID = target.getCameraID()) != null) {
            Scene scene = target.getAncestorByType(Scene.class);
            List<String> frameMeshIDs = scene.getFrameMeshIDs(cameraID);
            frameMeshIDs.add(0, null);
            model = new DefaultComboBoxModel<Object>(frameMeshIDs.toArray());
            selectedItem = target.getFrameMeshID();
        }
        this.frameMeshIDCombo.setModel(model);
        this.frameMeshIDCombo.setSelectedItem(selectedItem);
        this.frameMeshIDCombo.addActionListener(this.frameMeshIDComboListener);
        this.frameMeshIDCombo.setEnabled(target != null && target.getCameraID() != null);
    }

    private void updateViewportPanels() {
        StandardViewpoint target = (StandardViewpoint)this.getTarget();
        if (target != null) {
            this.camLocationPanel.setValue(target.getCamera().getGlobalPosition());
            this.camOffsetPanel.setValue(target.getCameraOffset());
            Rectangle4d viewport = target.getViewport();
            this.viewportMarginsPanel.setMarginsRegion(PatchworkComposerApp.BLENDER_VIEWPORT.toProportional(viewport));
        } else {
            this.camLocationPanel.setValue(null);
            this.camOffsetPanel.setValue(null);
            this.viewportMarginsPanel.setMarginsRegion(new Rectangle4d(0.0, 0.0, 1.0, 1.0));
        }
        boolean enabled = target != null && (target.getCameraID() == null || target.getFrameMeshID() == null);
        this.camLocationPanel.setEnabled(enabled);
        this.viewportMarginsPanel.setEnabled(enabled);
    }
}

