/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.animation.SpriteSheet;
import com.sodiumarc.patchwork.app.scanimport.ScanImportPanel;
import com.sodiumarc.patchwork.app.scenecomposer.LocationLayerGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerProperties;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.SpriteSequenceGraphic;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpriteSequenceGraphicPanel
extends LocationLayerGraphicPanel<SpriteSequenceGraphic> {
    private JComboBox sequenceNameCombo;
    private JCheckBox croppedCheckBox;
    private ActionListener croppedListener;
    private JCheckBox tracksCameraCheckBox;
    private ActionListener tracksCameraListener;
    private JSpinner fpsSpinner;
    private JSpinner sheetWidthSpinner;
    private JSpinner shadowAlphaSpinner;
    private ActionListener comboListener;
    private JTextField durationField;
    private ChangeListener fpsSpinnerListener;
    private ChangeListener sheetWidthSpinnerListener;
    private ChangeListener shadowAlphaSpinnerListener;

    @Override
    protected JComponent getMainArea() {
        this.sequenceNameCombo = new JComboBox();
        this.comboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpriteSequenceGraphic target = (SpriteSequenceGraphic)SpriteSequenceGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setAnimationName((String)SpriteSequenceGraphicPanel.this.sequenceNameCombo.getSelectedItem());
                    SpriteSequenceGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.croppedCheckBox = new JCheckBox();
        this.croppedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpriteSequenceGraphic target = (SpriteSequenceGraphic)SpriteSequenceGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setPreCropped(SpriteSequenceGraphicPanel.this.croppedCheckBox.isSelected());
                    SpriteSequenceGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.tracksCameraCheckBox = new JCheckBox();
        this.tracksCameraListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpriteSequenceGraphic target = (SpriteSequenceGraphic)SpriteSequenceGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setTracksCamera(SpriteSequenceGraphicPanel.this.tracksCameraCheckBox.isSelected());
                    SpriteSequenceGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.fpsSpinner = new JSpinner(new SpinnerNumberModel(12.0, 1.0, 30.0, 1.0));
        this.fpsSpinnerListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((SpriteSequenceGraphic)SpriteSequenceGraphicPanel.this.getTarget()).setFramesPerSecond(((Double)SpriteSequenceGraphicPanel.this.fpsSpinner.getValue()).floatValue());
                SpriteSequenceGraphicPanel.this.fireTargetModified();
            }
        };
        this.durationField = new JTextField(5);
        this.durationField.setEnabled(false);
        this.shadowAlphaSpinner = new JSpinner(new SpinnerNumberModel(0.3f, 0.0, 1.0, 0.1));
        ((JSpinner.DefaultEditor)this.shadowAlphaSpinner.getEditor()).getTextField().setColumns(4);
        this.shadowAlphaSpinnerListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((SpriteSequenceGraphic)SpriteSequenceGraphicPanel.this.getTarget()).setShadowAlpha(((Double)SpriteSequenceGraphicPanel.this.shadowAlphaSpinner.getValue()).floatValue());
                SpriteSequenceGraphicPanel.this.fireTargetModified();
            }
        };
        this.sheetWidthSpinner = new JSpinner(new SpinnerNumberModel(650, 300, 1000, 50));
        this.sheetWidthSpinnerListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((SpriteSequenceGraphic)SpriteSequenceGraphicPanel.this.getTarget()).setMaxSheetWidth((Integer)SpriteSequenceGraphicPanel.this.sheetWidthSpinner.getValue());
                SpriteSequenceGraphicPanel.this.fireTargetModified();
            }
        };
        JButton updateFromFramesButton = new JButton("Update From Frames");
        updateFromFramesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpriteSequenceGraphic target = (SpriteSequenceGraphic)SpriteSequenceGraphicPanel.this.getTarget();
                if (target != null) {
                    target.updateFromFrameImages();
                }
            }
        });
        JButton publishButton = new JButton("Publish");
        publishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpriteSequenceGraphic target = (SpriteSequenceGraphic)SpriteSequenceGraphicPanel.this.getTarget();
                if (target != null) {
                    target.publish();
                }
            }
        });
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        ArrayList<LabeledRowPanel.LabeledRow> animRows = new ArrayList<LabeledRowPanel.LabeledRow>();
        animRows.add(new LabeledRowPanel.LabeledRow("Sequence Name:", (Component)this.sequenceNameCombo));
        animRows.add(new LabeledRowPanel.LabeledRow("Frames per Second:", (Component)this.fpsSpinner));
        animRows.add(new LabeledRowPanel.LabeledRow("Duration:", (Component)this.durationField));
        animRows.add(new LabeledRowPanel.LabeledRow("Pre-Cropped:", (Component)this.croppedCheckBox));
        animRows.add(new LabeledRowPanel.LabeledRow("Tracks Camera:", (Component)this.tracksCameraCheckBox));
        animRows.add(new LabeledRowPanel.LabeledRow("Shadow Alpha:", (Component)this.shadowAlphaSpinner));
        animRows.add(new LabeledRowPanel.LabeledRow("Max Sheet Width:", (Component)this.sheetWidthSpinner));
        JPanel southPanel = new JPanel(new FlowLayout(2));
        southPanel.add(updateFromFramesButton);
        southPanel.add(publishButton);
        this.add((Component)southPanel, "South");
        JPanel animPanel = new JPanel(new BorderLayout());
        animPanel.add((Component)new LabeledRowPanel(animRows), "Center");
        animPanel.add((Component)southPanel, "South");
        TitledBorder titleBorder = BorderFactory.createTitledBorder("Animation");
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        animPanel.setBorder(BorderFactory.createCompoundBorder(titleBorder, emptyBorder));
        result.add(animPanel);
        result.add(this.getMarginsPanel());
        result.add(this.getCommonSettingsPanel());
        return result;
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        SpriteSequenceGraphic target = (SpriteSequenceGraphic)this.getTarget();
        this.sequenceNameCombo.removeActionListener(this.comboListener);
        this.fpsSpinner.removeChangeListener(this.fpsSpinnerListener);
        this.shadowAlphaSpinner.removeChangeListener(this.shadowAlphaSpinnerListener);
        this.sheetWidthSpinner.removeChangeListener(this.sheetWidthSpinnerListener);
        this.croppedCheckBox.removeActionListener(this.croppedListener);
        this.tracksCameraCheckBox.removeActionListener(this.tracksCameraListener);
        if (target != null) {
            File animParentDir = target.getIODirectory(IOFileType.ANIMATION_ROOT);
            File[] files = animParentDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && !pathname.getName().startsWith(".");
                }
            });
            ArrayList<String> names = new ArrayList<String>(files.length);
            for (File file : files) {
                names.add(file.getName());
            }
            this.sequenceNameCombo.setModel(new DefaultComboBoxModel<Object>(names.toArray()));
            this.sequenceNameCombo.setSelectedItem(target.getAnimationName());
            this.fpsSpinner.setValue(Float.valueOf(target.getFramesPerSecond()));
            this.durationField.setText(Integer.toString(target.getDurationInMillis()));
            this.croppedCheckBox.setSelected(target.isPreCropped());
            this.tracksCameraCheckBox.setSelected(target.tracksCamera());
            this.shadowAlphaSpinner.setValue(Float.valueOf(target.getShadowAlpha()));
            this.sheetWidthSpinner.setValue(target.getMaxSheetWidth());
        }
        this.sequenceNameCombo.addActionListener(this.comboListener);
        this.fpsSpinner.addChangeListener(this.fpsSpinnerListener);
        this.shadowAlphaSpinner.addChangeListener(this.shadowAlphaSpinnerListener);
        this.sheetWidthSpinner.addChangeListener(this.sheetWidthSpinnerListener);
        this.croppedCheckBox.addActionListener(this.croppedListener);
        this.tracksCameraCheckBox.addActionListener(this.tracksCameraListener);
    }

    @Override
    protected void saveACopy() {
        SpriteSequenceGraphic target = (SpriteSequenceGraphic)this.getTarget();
        if (target == null) {
            return;
        }
        File snapshotDir = PatchworkComposerProperties.getIODirectory(IOFileType.SNAPSHOT);
        target.saveFrameImages(snapshotDir);
    }

    @Override
    protected ScanImportPanel getScanImportPanel() {
        ScanImportPanel result = new ScanImportPanel();
        result.setFitScanToFill(true);
        return result;
    }

    @Override
    protected Printable getTracePrintable(float alpha) {
        SpriteSequenceGraphic target = (SpriteSequenceGraphic)this.getTarget();
        if (target == null) {
            return null;
        }
        SpriteSheet printable = target.getSpriteSheet();
        printable.setPrintAlpha(alpha);
        return printable;
    }

    @Override
    protected BufferedImage getTraceFillImage() {
        SpriteSequenceGraphic target = (SpriteSequenceGraphic)this.getTarget();
        if (target == null) {
            return null;
        }
        SpriteSheet spriteSheet = target.getSpriteSheet();
        return spriteSheet == null ? null : spriteSheet.getSheetImage();
    }
}

