/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundClip;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequence;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequenceEntry;
import com.sodiumarc.patchwork.app.scenecomposer.sound.LayeredAudioPlayer;
import com.sodiumarc.patchwork.app.scenecomposer.table.ProjectComponentTableCellRenderer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.SimulationClock;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class SoundSequencePanel
extends ProjectComponentPanel<SoundSequence> {
    private JTable table;
    private SequenceEntryTableModel tableModel;
    private JButton addButton;
    private JButton deleteButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton playButton;
    private SimulationClock simulationClock = new SimulationClock(20);
    private LayeredAudioPlayer audioPlayer;
    public static final Icon PLAY_ICON = IconLoader.loadIcon("openiconlibrary/media-playback-start-7.png");
    public static final Icon STOP_ICON = IconLoader.loadIcon("openiconlibrary/media-playback-stop-7.png");

    @Override
    protected JComponent getMainArea() {
        this.simulationClock = new SimulationClock(20);
        this.simulationClock.start();
        this.audioPlayer = new LayeredAudioPlayer(this.simulationClock);
        this.audioPlayer.start();
        this.tableModel = new SequenceEntryTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setRowHeight(25);
        this.table.setRowMargin(2);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SoundSequencePanel.this.updateButtonEnabling();
            }
        });
        ProjectComponentTableCellRenderer renderer = new ProjectComponentTableCellRenderer();
        this.table.setDefaultRenderer(ProjectComponent.class, renderer);
        this.table.getColumnModel().getColumn(2).setCellEditor(new EntryCellEditor());
        TableColumn layerColumn = this.table.getColumnModel().getColumn(1);
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("Score Background");
        comboBox.addItem("Score Foreground");
        comboBox.addItem("Ambient");
        comboBox.addItem("SFX");
        layerColumn.setCellEditor(new DefaultCellEditor(comboBox));
        JScrollPane scroller = new JScrollPane(this.table);
        scroller.getViewport().setBackground(Color.WHITE);
        scroller.setBorder(BorderFactory.createEtchedBorder(1));
        scroller.setPreferredSize(new Dimension(400, 200));
        JPanel result = new JPanel(new BorderLayout(5, 5));
        result.add((Component)scroller, "Center");
        result.add(this.makeListButtonsPanel(), "South");
        return result;
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        this.audioPlayer.stopAllLayers();
        this.playButton.setIcon(PLAY_ICON);
        this.tableModel.fireTableDataChanged();
    }

    private Component makeListButtonsPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 4, 2, 2));
        this.addButton = new JButton(IconLoader.loadIcon("silk/add.png"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SoundSequencePanel.this.onAddEntry();
            }
        });
        buttonPanel.add(this.addButton);
        this.deleteButton = new JButton(IconLoader.loadIcon("silk/cross.png"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SoundSequencePanel.this.onDeleteEntry();
            }
        });
        buttonPanel.add(this.deleteButton);
        this.moveUpButton = new JButton(IconLoader.loadIcon("silk/arrow_up.png"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SoundSequencePanel.this.onMoveUpEntry();
            }
        });
        buttonPanel.add(this.moveUpButton);
        this.moveDownButton = new JButton(IconLoader.loadIcon("silk/arrow_down.png"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SoundSequencePanel.this.onMoveDownEntry();
            }
        });
        buttonPanel.add(this.moveDownButton);
        this.playButton = new JButton();
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundSequencePanel.this.playOrStop();
            }
        });
        buttonPanel.add(this.playButton);
        return buttonPanel;
    }

    private void playOrStop() {
        SoundSequence target = (SoundSequence)this.getTarget();
        if (target != null) {
            if (this.audioPlayer.isPlaying()) {
                this.audioPlayer.stopAllLayers();
            } else {
                this.audioPlayer.playSequence(target, true);
            }
            if (this.audioPlayer.isPlaying()) {
                this.playButton.setIcon(STOP_ICON);
            } else {
                this.playButton.setIcon(PLAY_ICON);
            }
        }
    }

    private void onAddEntry() {
        SoundSequence target = (SoundSequence)this.getTarget();
        if (target != null) {
            target.addEntry();
            this.tableModel.fireTableDataChanged();
        }
    }

    private void onDeleteEntry() {
        SoundSequence target = (SoundSequence)this.getTarget();
        if (target != null) {
            int index = this.table.getSelectionModel().getLeadSelectionIndex();
            target.removeEntry(target.getEntries().get(index));
            this.tableModel.fireTableDataChanged();
        }
    }

    private void onMoveDownEntry() {
        SoundSequence target = (SoundSequence)this.getTarget();
        if (target != null) {
            int index = this.table.getSelectionModel().getLeadSelectionIndex();
            target.moveEntry(target.getEntries().get(index), index + 1);
            this.tableModel.fireTableDataChanged();
        }
    }

    private void onMoveUpEntry() {
        SoundSequence target = (SoundSequence)this.getTarget();
        if (target != null) {
            int index = this.table.getSelectionModel().getLeadSelectionIndex();
            target.moveEntry(target.getEntries().get(index), index - 1);
            this.tableModel.fireTableDataChanged();
        }
    }

    private void updateButtonEnabling() {
        int index = this.table.getSelectionModel().getLeadSelectionIndex();
        this.deleteButton.setEnabled(index >= 0);
        this.moveUpButton.setEnabled(index > 0);
        this.moveDownButton.setEnabled(index >= 0 && index < this.tableModel.getRowCount() - 1);
    }

    private class EntryCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TreeChooserButton button;
        private ProjectComponent currentSelection;

        public EntryCellEditor() {
            this.button = new TreeChooserButton(){

                @Override
                protected void selectionChanged(ProjectComponent selection) {
                    EntryCellEditor.this.currentSelection = selection;
                    EntryCellEditor.this.fireEditingStopped();
                }

                @Override
                protected void canceled() {
                    EntryCellEditor.this.fireEditingStopped();
                }
            };
            this.button.setEnabledType(SoundClip.class);
            this.button.setBorderPainted(false);
            this.button.setBackground(Color.WHITE);
        }

        @Override
        public Object getCellEditorValue() {
            ProjectComponent result = this.currentSelection;
            this.currentSelection = null;
            return result;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            SoundSequence target = (SoundSequence)SoundSequencePanel.this.getTarget();
            SoundSequenceEntry entry = target.getEntries().get(row);
            this.button.setChoiceRoot(entry.getAncestorByType(PatchworkProject.class));
            this.button.setExpandRoot(entry.getAncestorByType(Scene.class));
            this.currentSelection = entry.getSoundClip();
            this.button.setSelected(this.currentSelection);
            return this.button;
        }
    }

    private class SequenceEntryTableModel
    extends AbstractTableModel {
        private SequenceEntryTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Index";
                }
                case 1: {
                    return "Layer";
                }
                case 2: {
                    return "Clip";
                }
                case 3: {
                    return "Loop";
                }
                case 4: {
                    return "Volume";
                }
                case 5: {
                    return "Start Delay";
                }
                case 6: {
                    return "Fade In";
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return SoundClip.class;
                }
                case 3: {
                    return Boolean.class;
                }
                case 4: {
                    return Float.class;
                }
                case 5: {
                    return Float.class;
                }
                case 6: {
                    return Float.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public int getRowCount() {
            SoundSequence target = (SoundSequence)SoundSequencePanel.this.getTarget();
            return target == null ? 0 : target.getEntries().size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SoundSequence target = (SoundSequence)SoundSequencePanel.this.getTarget();
            if (target == null) {
                return null;
            }
            SoundSequenceEntry entry = target.getEntries().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return rowIndex;
                }
                case 1: {
                    return entry.getLayerID();
                }
                case 2: {
                    return entry.getSoundClip();
                }
                case 3: {
                    return entry.isLoop();
                }
                case 4: {
                    return Float.valueOf(entry.getVolume());
                }
                case 5: {
                    return Float.valueOf((float)entry.getStartDelayMillis() / 1000.0f);
                }
                case 6: {
                    return Float.valueOf((float)entry.getTransitionMillis() / 1000.0f);
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            SoundSequence target = (SoundSequence)SoundSequencePanel.this.getTarget();
            SoundSequenceEntry entry = target.getEntries().get(rowIndex);
            switch (columnIndex) {
                case 1: {
                    entry.setLayerID((String)aValue);
                    break;
                }
                case 2: {
                    entry.setSoundClip((SoundClip)aValue);
                    break;
                }
                case 3: {
                    entry.setLoop((Boolean)aValue);
                    break;
                }
                case 4: {
                    entry.setVolume(((Float)aValue).floatValue());
                    break;
                }
                case 5: {
                    entry.setStartDelayMillis((int)(((Float)aValue).floatValue() * 1000.0f));
                    break;
                }
                case 6: {
                    entry.setTransitionMillis((int)(((Float)aValue).floatValue() * 1000.0f));
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
            SoundSequencePanel.this.fireTargetModified();
        }
    }
}

