/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentPanel;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundClip;
import com.sodiumarc.patchwork.app.scenecomposer.sound.AudioPlayer;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SoundClipPanel
extends ProjectComponentPanel<SoundClip> {
    private final AudioPlayer audioPlayer = new AudioPlayer();
    private SoundFileComboBox filenameCombo;
    private ActionListener filenameComboListener;
    private JButton playButton;
    private JCheckBox muteCheckbox;
    private JSpinner volumeSpinner;
    public static final Icon PLAY_ICON = IconLoader.loadIcon("openiconlibrary/media-playback-start-7.png");
    public static final Icon STOP_ICON = IconLoader.loadIcon("openiconlibrary/media-playback-stop-7.png");

    public SoundClipPanel() {
        this.audioPlayer.start();
    }

    @Override
    protected JComponent getMainArea() {
        this.filenameCombo = new SoundFileComboBox();
        this.filenameComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundClip target = (SoundClip)SoundClipPanel.this.getTarget();
                if (target != null) {
                    target.setInputFilename((String)SoundClipPanel.this.filenameCombo.getSelectedItem());
                    SoundClipPanel.this.volumeSpinner.setValue(target.getBaseVolume());
                    SoundClipPanel.this.fireTargetModified();
                }
            }
        };
        this.volumeSpinner = new JSpinner(new SpinnerNumberModel(0.5, 0.0, 1.0, 0.1));
        ((JSpinner.DefaultEditor)this.volumeSpinner.getEditor()).getTextField().setColumns(4);
        this.volumeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SoundClip target = (SoundClip)SoundClipPanel.this.getTarget();
                if (target != null) {
                    float volume = ((Double)SoundClipPanel.this.volumeSpinner.getValue()).floatValue();
                    target.setBaseVolume(volume);
                    SoundClipPanel.this.audioPlayer.setTrackVolume(target.getGUID(), volume);
                }
            }
        });
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("Input Filename:", (Component)this.filenameCombo, true));
        rows.add(new LabeledRowPanel.LabeledRow("Base Volume:", (Component)this.volumeSpinner, false));
        this.playButton = new JButton();
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundClipPanel.this.playOrStop();
            }
        });
        this.muteCheckbox = new JCheckBox("Mute");
        this.muteCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundClip target = (SoundClip)SoundClipPanel.this.getTarget();
                if (target != null) {
                    target.setMuted(SoundClipPanel.this.muteCheckbox.isSelected());
                }
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.muteCheckbox);
        buttonPanel.add(this.playButton);
        rows.add(new LabeledRowPanel.LabeledRow("", (Component)buttonPanel, true));
        return new LabeledRowPanel(rows);
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        SoundClip target = (SoundClip)this.getTarget();
        this.playButton.setIcon(PLAY_ICON);
        this.filenameCombo.removeActionListener(this.filenameComboListener);
        if (target != null) {
            this.filenameCombo.setParentDir(target.getIODirectory(IOFileType.SOUND));
            this.filenameCombo.setSelectedItem(target.getInputFilename());
            if (this.audioPlayer.getTrackIDs().contains(target.getGUID())) {
                this.playButton.setIcon(STOP_ICON);
            }
            this.muteCheckbox.setSelected(target.isMuted());
            this.volumeSpinner.setValue(target.getBaseVolume());
        }
        this.filenameCombo.addActionListener(this.filenameComboListener);
    }

    private void playOrStop() {
        SoundClip target = (SoundClip)this.getTarget();
        if (target != null) {
            String id = target.getGUID();
            if (this.audioPlayer.getTrackIDs().contains(id)) {
                this.audioPlayer.stopTrack(id, 1000);
                this.playButton.setIcon(PLAY_ICON);
            } else {
                target.setFadeLevel(1.0f);
                this.audioPlayer.playTrack(target.getGUID(), target.getSoundData(), target.getAudioFormat(), -1, target.getBaseVolume(), 1000);
                this.playButton.setIcon(STOP_ICON);
            }
        }
    }

    private static class SoundFileComboBox
    extends JComboBox {
        private SoundFileComboBox() {
        }

        void setParentDir(File dir) {
            if (dir == null) {
                this.setModel(new DefaultComboBoxModel());
                return;
            }
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.isDirectory()) {
                        return false;
                    }
                    return FileUtils.hasFileExtension(pathname.getName(), "wav");
                }
            });
            ArrayList<String> names = new ArrayList<String>(files.length);
            for (File file : files) {
                names.add(file.getName());
            }
            this.setModel(new DefaultComboBoxModel<Object>(names.toArray()));
        }
    }
}

