/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.ColladaFileComboBox;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundClip;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ScenePanel
extends ProjectComponentPanel<Scene> {
    private ColladaFileComboBox filenameCombo;
    private ActionListener filenameComboListener;
    private TreeChooserButton ambientSoundButton;
    private JButton autoLoadButton;
    private JButton updateButton;

    public ScenePanel() {
        this.setTarget(null);
    }

    @Override
    protected JComponent getMainArea() {
        this.filenameCombo = new ColladaFileComboBox();
        this.filenameComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Scene target = (Scene)ScenePanel.this.getTarget();
                if (target != null) {
                    target.setInputFilename((String)ScenePanel.this.filenameCombo.getSelectedItem());
                    ScenePanel.this.updateEnabling();
                    ScenePanel.this.fireTargetModified();
                }
            }
        };
        this.ambientSoundButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((Scene)ScenePanel.this.getTarget()).setAmbientSound((SoundClip)selection);
                ScenePanel.this.fireTargetModified();
            }
        };
        this.ambientSoundButton.setEnabledType(SoundClip.class);
        this.autoLoadButton = new JButton("Auto-load Images");
        this.autoLoadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ScenePanel.this.getTarget() != null) {
                    ((Scene)ScenePanel.this.getTarget()).autoLoadImages();
                    ScenePanel.this.fireTargetModified();
                }
            }
        });
        this.updateButton = new JButton("Update from File");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ScenePanel.this.getTarget() != null) {
                    ((Scene)ScenePanel.this.getTarget()).updateFromSceneGraph();
                    ScenePanel.this.fireTargetModified();
                }
            }
        });
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("COLLADA file:", (Component)this.filenameCombo, true));
        rows.add(new LabeledRowPanel.LabeledRow("AmbientSound:", (Component)this.ambientSoundButton, true));
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.updateButton);
        buttonPanel.add(this.autoLoadButton);
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)new LabeledRowPanel(rows), "Center");
        result.add((Component)buttonPanel, "South");
        return result;
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        Scene target = (Scene)this.getTarget();
        this.filenameCombo.removeActionListener(this.filenameComboListener);
        if (target != null) {
            this.filenameCombo.setColladaParentDir(target.getIODirectory(IOFileType.COLLADA));
            this.filenameCombo.setSelectedItem(target.getInputFilename());
            this.ambientSoundButton.setChoiceRoot(target.getAncestorByType(PatchworkProject.class));
            this.ambientSoundButton.setExpandRoot(target.getAncestorByType(Scene.class));
            this.ambientSoundButton.setSelected(target.getAmbientSound());
        }
        this.filenameCombo.addActionListener(this.filenameComboListener);
        this.updateEnabling();
    }

    private void updateEnabling() {
        Scene target = (Scene)this.getTarget();
        this.updateButton.setEnabled(target != null && target.getInputFilename() != null);
    }
}

