/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.Tuple3dPanel;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.table.StateTransitionTable;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import com.sodiumarc.patchwork.util.TargetablePanel;
import com.sodiumarc.patchwork.util.TargetablePanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class SceneLayerPanel
extends ProjectComponentPanel<SceneLayer> {
    private JCheckBox backgroundCheckbox;
    private ActionListener backgroundListener;
    private Tuple3dPanel refPointPanel;
    private Tuple3dPanel offsetPanel;
    private JComboBox refMeshIDCombo;
    private JButton updateButton;
    private ActionListener refMeshIDComboListener;
    private TreeChooserButton initialStateButton;
    private StateTransitionTable transitionTable;

    @Override
    protected JComponent getMainArea() {
        this.refMeshIDCombo = new JComboBox();
        this.refMeshIDComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SceneLayer target = (SceneLayer)SceneLayerPanel.this.getTarget();
                if (target != null) {
                    target.setRefMeshID((String)SceneLayerPanel.this.refMeshIDCombo.getSelectedItem());
                    SceneLayerPanel.this.updateRefPointPanel();
                    SceneLayerPanel.this.updateEnabling();
                    SceneLayerPanel.this.fireTargetModified();
                }
            }
        };
        this.updateButton = new JButton("Update");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SceneLayer target = (SceneLayer)SceneLayerPanel.this.getTarget();
                if (target != null) {
                    target.updateFromSceneGraph();
                    SceneLayerPanel.this.targetSet();
                    SceneLayerPanel.this.fireTargetModified();
                }
            }
        });
        this.backgroundCheckbox = new JCheckBox();
        this.backgroundListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SceneLayer target = (SceneLayer)SceneLayerPanel.this.getTarget();
                if (target != null) {
                    target.setIsBackground(SceneLayerPanel.this.backgroundCheckbox.isSelected());
                    SceneLayerPanel.this.updateEnabling();
                    SceneLayerPanel.this.fireTargetModified();
                }
            }
        };
        this.refPointPanel = new Tuple3dPanel(){

            @Override
            protected void valueChanged() {
                SceneLayer target = (SceneLayer)SceneLayerPanel.this.getTarget();
                if (target != null) {
                    target.setRefPoint(SceneLayerPanel.this.refPointPanel.getValue(new Point3d()));
                    SceneLayerPanel.this.fireTargetModified();
                }
            }
        };
        this.refPointPanel.setEnabled(false);
        this.offsetPanel = new Tuple3dPanel(){

            @Override
            protected void valueChanged() {
                SceneLayer target = (SceneLayer)SceneLayerPanel.this.getTarget();
                if (target != null) {
                    target.setOffset(SceneLayerPanel.this.offsetPanel.getValue(new Vector3d()));
                    SceneLayerPanel.this.fireTargetModified();
                }
            }
        };
        this.initialStateButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((SceneLayer)SceneLayerPanel.this.getTarget()).setInitialState((SceneLayerState)selection);
                SceneLayerPanel.this.fireTargetModified();
            }
        };
        this.initialStateButton.setEnabledType(SceneLayerState.class);
        this.transitionTable = new StateTransitionTable();
        this.transitionTable.addListener(new TargetablePanelListener(){

            @Override
            public void targetModified(TargetablePanel<?> source) {
                SceneLayerPanel.this.fireTargetModified();
            }

            @Override
            public void targetChanged(TargetablePanel<?> source) {
            }
        });
        ArrayList<LabeledRowPanel.LabeledRow> linkRows = new ArrayList<LabeledRowPanel.LabeledRow>();
        linkRows.add(new LabeledRowPanel.LabeledRow("Reference Mesh ID:", (Component)this.refMeshIDCombo, true));
        linkRows.add(new LabeledRowPanel.LabeledRow((String)null, (Component)this.updateButton));
        ArrayList<LabeledRowPanel.LabeledRow> geomRows = new ArrayList<LabeledRowPanel.LabeledRow>();
        geomRows.add(new LabeledRowPanel.LabeledRow("Background:", (Component)this.backgroundCheckbox));
        geomRows.add(new LabeledRowPanel.LabeledRow("Reference Point:", (Component)this.refPointPanel));
        geomRows.add(new LabeledRowPanel.LabeledRow("Offset:", (Component)this.offsetPanel));
        ArrayList<LabeledRowPanel.LabeledRow> bottomRows = new ArrayList<LabeledRowPanel.LabeledRow>();
        bottomRows.add(new LabeledRowPanel.LabeledRow("Initial State:", (Component)this.initialStateButton, true));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        topPanel.add(new LabeledRowPanel("COLLADA link", linkRows));
        topPanel.add(new LabeledRowPanel("Geometry", geomRows));
        JPanel result = new JPanel(new BorderLayout(0, 10));
        result.add((Component)topPanel, "North");
        result.add((Component)this.transitionTable, "Center");
        result.add((Component)new LabeledRowPanel(bottomRows), "South");
        return result;
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        SceneLayer target = (SceneLayer)this.getTarget();
        this.backgroundCheckbox.removeActionListener(this.backgroundListener);
        if (target != null) {
            this.initialStateButton.setChoiceRoot(target);
            this.initialStateButton.setExpandRoot(target);
            this.initialStateButton.setSelected(target.getInitialState());
            this.backgroundCheckbox.setSelected(target.isBackground());
            this.refPointPanel.setValue(target.getRefPoint());
            this.offsetPanel.setValue(target.getOffset());
        }
        this.backgroundCheckbox.addActionListener(this.backgroundListener);
        this.transitionTable.setTarget(target);
        this.updateRefMeshIDCombo();
        this.updateRefPointPanel();
        this.updateEnabling();
    }

    private void updateRefPointPanel() {
        SceneLayer target = (SceneLayer)this.getTarget();
        if (target != null) {
            this.refPointPanel.setValue(target.getRefPoint());
        } else {
            this.refPointPanel.setValue(null);
        }
    }

    private void updateEnabling() {
        SceneLayer target = (SceneLayer)this.getTarget();
        boolean isBackground = target != null && !target.isBackground();
        this.refPointPanel.setEnabled(target != null && target.getRefMeshID() == null && !isBackground);
        this.offsetPanel.setEnabled(isBackground);
        this.refMeshIDCombo.setEnabled(isBackground);
        this.updateButton.setEnabled(isBackground);
    }

    private void updateRefMeshIDCombo() {
        SceneLayer target = (SceneLayer)this.getTarget();
        this.refMeshIDCombo.removeActionListener(this.refMeshIDComboListener);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel();
        String selectedItem = null;
        if (target != null) {
            List<String> nodeIDs = target.getParentComponent().getRefMeshIDs();
            nodeIDs.add(0, null);
            model = new DefaultComboBoxModel<Object>(nodeIDs.toArray());
            selectedItem = target.getRefMeshID();
        }
        this.refMeshIDCombo.setModel(model);
        this.refMeshIDCombo.setSelectedItem(selectedItem);
        this.refMeshIDCombo.addActionListener(this.refMeshIDComboListener);
    }
}

