/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentContextLabel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class ProjectComponentList<T extends ProjectComponent>
extends JPanel {
    private final boolean mutable;
    private final JList list;
    private final DefaultListModel stateListModel;
    private final ListSelectionListener stateListListener;
    private TreeChooserButton addButton;
    private JButton deleteButton;
    private static final Color SELECT_COLOR = new Color(205, 225, 255);

    public ProjectComponentList(String title, Class<T> type, int generations, boolean mutable) {
        super(new BorderLayout());
        this.mutable = mutable;
        this.list = new JList();
        this.list.setVisibleRowCount(4);
        this.list.setCellRenderer(new StateListCellRenderer(generations));
        this.list.setFixedCellHeight(20);
        this.stateListListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                List selected = ProjectComponentList.this.getSelection();
                ProjectComponentList.this.updateButtons();
                ProjectComponentList.this.selectionChanged(selected);
            }
        };
        this.stateListModel = new DefaultListModel();
        this.list.setModel(this.stateListModel);
        JScrollPane scroller = new JScrollPane(this.list);
        this.add((Component)scroller, "Center");
        if (mutable) {
            this.add(this.makeButtonPanel(type), "South");
        }
        TitledBorder titleBorder = BorderFactory.createTitledBorder(title);
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        CompoundBorder outerBorder = BorderFactory.createCompoundBorder(titleBorder, emptyBorder);
        this.setBorder(outerBorder);
        this.updateButtons();
    }

    public void clear() {
        this.list.getSelectionModel().removeListSelectionListener(this.stateListListener);
        this.stateListModel.clear();
        this.list.getSelectionModel().addListSelectionListener(this.stateListListener);
    }

    public void update() {
        this.list.getSelectionModel().removeListSelectionListener(this.stateListListener);
        this.stateListModel.clear();
        List<T> contents = this.getContents();
        if (contents != null) {
            for (ProjectComponent component : contents) {
                this.stateListModel.addElement(component);
            }
        }
        this.list.getSelectionModel().addListSelectionListener(this.stateListListener);
        this.updateButtons();
    }

    public void setSelection(List<T> selected) {
        this.list.getSelectionModel().removeListSelectionListener(this.stateListListener);
        this.stateListModel.clear();
        this.list.getSelectionModel().clearSelection();
        for (ProjectComponent selectedComponent : selected) {
            int index = this.stateListModel.indexOf(selectedComponent);
            if (index < 0) continue;
            this.list.getSelectionModel().addSelectionInterval(index, index);
        }
        this.list.getSelectionModel().addListSelectionListener(this.stateListListener);
    }

    public void setContents(List<T> contents, List<T> selected) {
        this.list.getSelectionModel().removeListSelectionListener(this.stateListListener);
        this.stateListModel.clear();
        for (ProjectComponent component : contents) {
            this.stateListModel.addElement(component);
        }
        this.list.getSelectionModel().clearSelection();
        for (ProjectComponent selectedComponent : selected) {
            int index = this.stateListModel.indexOf(selectedComponent);
            if (index < 0) continue;
            this.list.getSelectionModel().addSelectionInterval(index, index);
        }
        this.list.getSelectionModel().addListSelectionListener(this.stateListListener);
    }

    public void setChoiceRoot(ProjectComponent choiceRoot) {
        if (this.mutable) {
            this.addButton.setChoiceRoot(choiceRoot);
        }
    }

    public void setExpandRoot(ProjectComponent expandRoot) {
        if (this.mutable) {
            this.addButton.setExpandRoot(expandRoot);
        }
    }

    protected List<T> getContents() {
        return Collections.emptyList();
    }

    protected abstract void selectionChanged(List<T> var1);

    protected void onAdd(T toAdd) {
    }

    protected void onDelete(List<T> toDelete) {
    }

    private List<T> getSelection() {
        ArrayList<ProjectComponent> selected = new ArrayList<ProjectComponent>();
        for (int i = 0; i < this.stateListModel.size(); ++i) {
            if (!this.list.getSelectionModel().isSelectedIndex(i)) continue;
            selected.add((ProjectComponent)this.stateListModel.elementAt(i));
        }
        return selected;
    }

    private Component makeButtonPanel(Class<T> type) {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 5, 2, 2));
        this.addButton = new TreeChooserButton(IconLoader.loadIcon("silk/add.png")){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ProjectComponentList.this.onAdd(selection);
                ProjectComponentList.this.update();
            }
        };
        this.addButton.setHorizontalAlignment(0);
        this.addButton.setEnabledType(type);
        buttonPanel.add(this.addButton);
        this.deleteButton = new JButton(IconLoader.loadIcon("silk/cross.png"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectComponentList.this.onDelete(ProjectComponentList.this.getSelection());
                ProjectComponentList.this.update();
            }
        });
        buttonPanel.add(this.deleteButton);
        return buttonPanel;
    }

    private void updateButtons() {
        if (this.mutable) {
            this.deleteButton.setEnabled(!this.getSelection().isEmpty());
        }
    }

    private class StateListCellRenderer
    extends ProjectComponentContextLabel<ProjectComponent>
    implements ListCellRenderer {
        public StateListCellRenderer(int generations) {
            super(generations);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(isSelected ? SELECT_COLOR : Color.WHITE);
            this.setTarget(value instanceof ProjectComponent ? (ProjectComponent)value : null);
            return this;
        }
    }
}

