/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.GridCoordsPanel;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.CardLink;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.LocationTransition;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.Predicate;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class PredicatePanel
extends ProjectComponentPanel<Predicate> {
    private TreeChooserButton subjectButton;
    private JComboBox cardStatusCombo;
    private ActionListener cardStatusListener;
    private GridCoordsPanel requiredCoordsSpinners;
    private JCheckBox negatedCheckbox;
    private ActionListener negatedListener;
    private JCheckBox mouseOverCheckbox;
    private ActionListener mouseOverListener;

    @Override
    protected JComponent getMainArea() {
        this.subjectButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((Predicate)PredicatePanel.this.getTarget()).setPredicateSubject(selection);
                PredicatePanel.this.fireTargetModified();
            }
        };
        HashSet types = new HashSet();
        types.add(Card.class);
        types.add(SceneLocation.class);
        types.add(SceneLayerState.class);
        types.add(CardLink.class);
        types.add(LocationTransition.class);
        this.subjectButton.setEnabledTypes(types);
        this.negatedCheckbox = new JCheckBox();
        this.negatedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Predicate target = (Predicate)PredicatePanel.this.getTarget();
                if (target != null) {
                    target.setNegated(PredicatePanel.this.negatedCheckbox.isSelected());
                    PredicatePanel.this.fireTargetModified();
                }
            }
        };
        this.mouseOverCheckbox = new JCheckBox();
        this.mouseOverListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Predicate target = (Predicate)PredicatePanel.this.getTarget();
                if (target != null) {
                    target.setMouseOverOnly(PredicatePanel.this.mouseOverCheckbox.isSelected());
                    PredicatePanel.this.fireTargetModified();
                }
            }
        };
        this.cardStatusCombo = new JComboBox<Predicate.CardStatus>(Predicate.CardStatus.values());
        this.cardStatusListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Predicate target = (Predicate)PredicatePanel.this.getTarget();
                if (target != null) {
                    target.setCardStatus((Predicate.CardStatus)((Object)PredicatePanel.this.cardStatusCombo.getSelectedItem()));
                    PredicatePanel.this.updateEnabling();
                    PredicatePanel.this.fireTargetModified();
                }
            }
        };
        this.requiredCoordsSpinners = new GridCoordsPanel(){

            @Override
            protected void valueChanged() {
                Predicate target = (Predicate)PredicatePanel.this.getTarget();
                if (target != null) {
                    target.setRequiredCoords(PredicatePanel.this.requiredCoordsSpinners.getValue());
                    PredicatePanel.this.fireTargetModified();
                }
            }
        };
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("Subject:", (Component)this.subjectButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("Card Requirement:", (Component)this.cardStatusCombo));
        rows.add(new LabeledRowPanel.LabeledRow("Required Coords:", (Component)this.requiredCoordsSpinners));
        rows.add(new LabeledRowPanel.LabeledRow("Negated:", (Component)this.negatedCheckbox));
        rows.add(new LabeledRowPanel.LabeledRow("Mouse-Over Only:", (Component)this.mouseOverCheckbox));
        return new LabeledRowPanel(rows);
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        Predicate target = (Predicate)this.getTarget();
        this.negatedCheckbox.removeActionListener(this.negatedListener);
        this.mouseOverCheckbox.removeActionListener(this.mouseOverListener);
        this.cardStatusCombo.removeActionListener(this.cardStatusListener);
        if (target != null) {
            this.subjectButton.setChoiceRoot(target.getAncestorByType(PatchworkProject.class));
            this.subjectButton.setExpandRoot(target.getAncestorByType(Card.class));
            this.subjectButton.setSelected(target.getPredicateSubject());
            this.negatedCheckbox.setSelected(target.isNegated());
            this.mouseOverCheckbox.setSelected(target.isMouseOverOnly());
            this.cardStatusCombo.setSelectedItem((Object)target.getCardStatus());
            this.requiredCoordsSpinners.setValue(target.getRequiredCoords());
        }
        this.negatedCheckbox.addActionListener(this.negatedListener);
        this.mouseOverCheckbox.addActionListener(this.mouseOverListener);
        this.cardStatusCombo.addActionListener(this.cardStatusListener);
        this.updateEnabling();
    }

    private void updateEnabling() {
        Predicate target = (Predicate)this.getTarget();
        if (target != null) {
            this.requiredCoordsSpinners.setEnabled(target.getCardStatus() == Predicate.CardStatus.AT_COORDS);
        } else {
            this.requiredCoordsSpinners.setEnabled(false);
        }
    }
}

