/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.util.Collection.Range;
import java.awt.GridLayout;
import java.awt.Point;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class PointPanel
extends JPanel {
    private JSpinner xSpinner = this.makeSpinner();
    private JSpinner ySpinner = this.makeSpinner();
    private ChangeListener spinnerListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            PointPanel.this.valueChanged();
        }
    };

    public PointPanel() {
        super(new GridLayout(1, 2, 5, 5));
        this.add(this.xSpinner);
        this.add(this.ySpinner);
    }

    public void setValue(Point value) {
        Range<Integer> range = this.getRange();
        int min = range.getMin();
        this.setSpinner(this.xSpinner, value == null ? min : value.x);
        this.setSpinner(this.ySpinner, value == null ? min : value.y);
    }

    public Point getValue() {
        Point result = new Point();
        result.x = (Integer)this.xSpinner.getValue();
        result.y = (Integer)this.ySpinner.getValue();
        return result;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.xSpinner.setEnabled(enabled);
        this.ySpinner.setEnabled(enabled);
    }

    protected abstract Range<Integer> getRange();

    protected abstract void valueChanged();

    private JSpinner makeSpinner() {
        Range<Integer> range = this.getRange();
        int min = range.getMin();
        int max = range.getMax();
        JSpinner result = new JSpinner(new SpinnerNumberModel(min, min, max, 1));
        ((JSpinner.DefaultEditor)result.getEditor()).getTextField().setColumns(4);
        result.addChangeListener(this.spinnerListener);
        return result;
    }

    private void setSpinner(JSpinner spinner, int value) {
        spinner.removeChangeListener(this.spinnerListener);
        spinner.setValue(value);
        spinner.addChangeListener(this.spinnerListener);
    }
}

