/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.LocationLayerGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.PlayListEntry;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.PlayListGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.SpriteSequenceGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.table.ProjectComponentTableCellRenderer;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class PlayListGraphicPanel
extends LocationLayerGraphicPanel<PlayListGraphic> {
    private JComboBox playbackModeCombo;
    private ActionListener playbackListener;
    private JCheckBox sampledCheckBox;
    private ActionListener sampledCheckBoxListener;
    private JSpinner fpsSpinner;
    private ChangeListener fpsSpinnerListener;
    private JTable table;
    private PlayListEntryTableModel tableModel;
    private JButton addButton;
    private JButton deleteButton;
    private JButton moveUpButton;
    private JButton moveDownButton;

    @Override
    protected JComponent getMainArea() {
        this.playbackModeCombo = new JComboBox<PlayListGraphic.PlaybackMode>(PlayListGraphic.PlaybackMode.values());
        this.playbackListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayListGraphic target = (PlayListGraphic)PlayListGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setPlaybackMode((PlayListGraphic.PlaybackMode)((Object)PlayListGraphicPanel.this.playbackModeCombo.getSelectedItem()));
                    PlayListGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.sampledCheckBox = new JCheckBox();
        this.sampledCheckBoxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayListGraphic target = (PlayListGraphic)PlayListGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setPlaybackSampled(PlayListGraphicPanel.this.sampledCheckBox.isSelected());
                    PlayListGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.fpsSpinner = new JSpinner(new SpinnerNumberModel(12.0, 1.0, 30.0, 1.0));
        this.fpsSpinnerListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((PlayListGraphic)PlayListGraphicPanel.this.getTarget()).setPlaybackSamplesPerSecond(((Double)PlayListGraphicPanel.this.fpsSpinner.getValue()).floatValue());
                PlayListGraphicPanel.this.fireTargetModified();
            }
        };
        JButton saveSamplesButton = new JButton("Save Samples");
        saveSamplesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayListGraphic target = (PlayListGraphic)PlayListGraphicPanel.this.getTarget();
                if (target != null) {
                    target.saveSamples();
                }
            }
        });
        this.tableModel = new PlayListEntryTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setRowHeight(25);
        this.table.setRowMargin(2);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PlayListGraphicPanel.this.updateButtonEnabling();
            }
        });
        ProjectComponentTableCellRenderer renderer = new ProjectComponentTableCellRenderer();
        this.table.setDefaultRenderer(LocationLayerGraphic.class, renderer);
        this.table.getColumnModel().getColumn(1).setCellEditor(new EntryCellEditor());
        JScrollPane scroller = new JScrollPane(this.table);
        scroller.getViewport().setBackground(Color.WHITE);
        scroller.setBorder(BorderFactory.createEtchedBorder(1));
        scroller.setPreferredSize(new Dimension(400, 200));
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("Playback Mode: ", (Component)this.playbackModeCombo));
        rows.add(new LabeledRowPanel.LabeledRow("Playback Sampled (when Published): ", (Component)this.sampledCheckBox));
        rows.add(new LabeledRowPanel.LabeledRow("Samples per Second: ", (Component)this.fpsSpinner));
        rows.add(new LabeledRowPanel.LabeledRow("", (Component)saveSamplesButton));
        JPanel tablePanel = new JPanel(new BorderLayout(5, 5));
        tablePanel.add((Component)scroller, "Center");
        tablePanel.add(this.makeListButtonsPanel(), "South");
        JPanel result = new JPanel(new BorderLayout(5, 5));
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        top.add(new LabeledRowPanel("General", rows));
        top.add(this.getMarginsPanel());
        result.add((Component)top, "North");
        result.add((Component)tablePanel, "Center");
        result.add((Component)this.getCommonSettingsPanel(), "South");
        this.updateButtonEnabling();
        return result;
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        PlayListGraphic target = (PlayListGraphic)this.getTarget();
        this.playbackModeCombo.removeActionListener(this.playbackListener);
        this.sampledCheckBox.removeActionListener(this.sampledCheckBoxListener);
        this.fpsSpinner.removeChangeListener(this.fpsSpinnerListener);
        if (target != null) {
            this.playbackModeCombo.setSelectedItem((Object)target.getPlaybackMode());
            this.sampledCheckBox.setSelected(target.isPlaybackSampled());
            this.fpsSpinner.setValue(Float.valueOf(target.getPlaybackSamplesPerSecond()));
        }
        this.playbackModeCombo.addActionListener(this.playbackListener);
        this.sampledCheckBox.addActionListener(this.sampledCheckBoxListener);
        this.fpsSpinner.addChangeListener(this.fpsSpinnerListener);
        this.tableModel.fireTableDataChanged();
    }

    private Component makeListButtonsPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 4, 2, 2));
        this.addButton = new JButton(IconLoader.loadIcon("silk/add.png"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PlayListGraphicPanel.this.onAddEntry();
            }
        });
        buttonPanel.add(this.addButton);
        this.deleteButton = new JButton(IconLoader.loadIcon("silk/cross.png"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PlayListGraphicPanel.this.onDeleteEntry();
            }
        });
        buttonPanel.add(this.deleteButton);
        this.moveUpButton = new JButton(IconLoader.loadIcon("silk/arrow_up.png"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PlayListGraphicPanel.this.onMoveUpEntry();
            }
        });
        buttonPanel.add(this.moveUpButton);
        this.moveDownButton = new JButton(IconLoader.loadIcon("silk/arrow_down.png"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PlayListGraphicPanel.this.onMoveDownEntry();
            }
        });
        buttonPanel.add(this.moveDownButton);
        return buttonPanel;
    }

    private void onAddEntry() {
        PlayListGraphic target = (PlayListGraphic)this.getTarget();
        if (target != null) {
            target.addEntry();
            this.tableModel.fireTableDataChanged();
        }
    }

    private void onDeleteEntry() {
        PlayListGraphic target = (PlayListGraphic)this.getTarget();
        if (target != null) {
            int index = this.table.getSelectionModel().getLeadSelectionIndex();
            target.removeEntry(target.getEntries().get(index));
            this.tableModel.fireTableDataChanged();
        }
    }

    private void onMoveDownEntry() {
        PlayListGraphic target = (PlayListGraphic)this.getTarget();
        if (target != null) {
            int index = this.table.getSelectionModel().getLeadSelectionIndex();
            target.moveEntry(target.getEntries().get(index), index + 1);
            this.tableModel.fireTableDataChanged();
        }
    }

    private void onMoveUpEntry() {
        PlayListGraphic target = (PlayListGraphic)this.getTarget();
        if (target != null) {
            int index = this.table.getSelectionModel().getLeadSelectionIndex();
            target.moveEntry(target.getEntries().get(index), index - 1);
            this.tableModel.fireTableDataChanged();
        }
    }

    private void updateButtonEnabling() {
        int index = this.table.getSelectionModel().getLeadSelectionIndex();
        this.deleteButton.setEnabled(index >= 0);
        this.moveUpButton.setEnabled(index > 0);
        this.moveDownButton.setEnabled(index >= 0 && index < this.tableModel.getRowCount() - 1);
    }

    private class EntryCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TreeChooserButton button;
        private ProjectComponent currentSelection;

        public EntryCellEditor() {
            this.button = new TreeChooserButton(){

                @Override
                protected void selectionChanged(ProjectComponent selection) {
                    EntryCellEditor.this.currentSelection = selection;
                    EntryCellEditor.this.fireEditingStopped();
                }

                @Override
                protected void canceled() {
                    EntryCellEditor.this.fireEditingStopped();
                }
            };
            HashSet types = new HashSet();
            types.add(LocationLayerGraphic.class);
            this.button.setEnabledTypes(types);
            this.button.setBorderPainted(false);
            this.button.setBackground(Color.WHITE);
        }

        @Override
        public Object getCellEditorValue() {
            ProjectComponent result = this.currentSelection;
            this.currentSelection = null;
            return result;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            PlayListGraphic target = (PlayListGraphic)PlayListGraphicPanel.this.getTarget();
            PlayListEntry entry = target.getEntries().get(row);
            this.button.setChoiceRoot(entry.getAncestorByType(PatchworkProject.class));
            this.button.setExpandRoot(entry.getAncestorByType(SceneLocationLayer.class));
            this.currentSelection = entry.getGraphic();
            this.button.setSelected(this.currentSelection);
            return this.button;
        }
    }

    private class PlayListEntryTableModel
    extends AbstractTableModel {
        private PlayListEntryTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Index";
                }
                case 1: {
                    return "Graphic";
                }
                case 2: {
                    return "Start";
                }
                case 3: {
                    return "End";
                }
                case 4: {
                    return "Scale";
                }
                case 5: {
                    return "Start Delay";
                }
                case 6: {
                    return "Hold at Start";
                }
                case 7: {
                    return "Hold at End";
                }
                case 8: {
                    return "Fade In";
                }
                case 9: {
                    return "Fade Out";
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return LocationLayerGraphic.class;
                }
                case 2: {
                    return Float.class;
                }
                case 3: {
                    return Float.class;
                }
                case 4: {
                    return Float.class;
                }
                case 5: {
                    return Float.class;
                }
                case 6: {
                    return Float.class;
                }
                case 7: {
                    return Float.class;
                }
                case 8: {
                    return Float.class;
                }
                case 9: {
                    return Float.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public int getRowCount() {
            PlayListGraphic target = (PlayListGraphic)PlayListGraphicPanel.this.getTarget();
            return target == null ? 0 : target.getEntries().size();
        }

        @Override
        public int getColumnCount() {
            return 10;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            PlayListGraphic target = (PlayListGraphic)PlayListGraphicPanel.this.getTarget();
            if (target == null) {
                return null;
            }
            PlayListEntry entry = target.getEntries().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return rowIndex;
                }
                case 1: {
                    return entry.getGraphic();
                }
                case 2: {
                    return Float.valueOf(this.targetRangeToTableRange(entry, entry.getStartFraction()));
                }
                case 3: {
                    return Float.valueOf(this.targetRangeToTableRange(entry, entry.getEndFraction()));
                }
                case 4: {
                    return Float.valueOf(entry.getDurationScale());
                }
                case 5: {
                    return Float.valueOf((float)entry.getStartDelayMillis() / 1000.0f);
                }
                case 6: {
                    return Float.valueOf((float)entry.getHoldAtStartMillis() / 1000.0f);
                }
                case 7: {
                    float value = entry.getHoldAtEndMillis();
                    return Float.valueOf(value < 0.0f ? -1.0f : value / 1000.0f);
                }
                case 8: {
                    return Float.valueOf(entry.getFadeInFraction());
                }
                case 9: {
                    return Float.valueOf(entry.getFadeOutFraction());
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            PlayListGraphic target = (PlayListGraphic)PlayListGraphicPanel.this.getTarget();
            PlayListEntry entry = target.getEntries().get(rowIndex);
            switch (columnIndex) {
                case 1: {
                    entry.setGraphic((LocationLayerGraphic)aValue);
                    break;
                }
                case 2: {
                    this.tableRangeToTargetRange(entry, ((Float)aValue).floatValue());
                    entry.setStartFraction(this.tableRangeToTargetRange(entry, ((Float)aValue).floatValue()));
                    break;
                }
                case 3: {
                    this.tableRangeToTargetRange(entry, ((Float)aValue).floatValue());
                    entry.setEndFraction(this.tableRangeToTargetRange(entry, ((Float)aValue).floatValue()));
                    break;
                }
                case 4: {
                    entry.setDurationScale(((Float)aValue).floatValue());
                    break;
                }
                case 5: {
                    entry.setStartDelayMillis((int)(((Float)aValue).floatValue() * 1000.0f));
                    break;
                }
                case 6: {
                    entry.setHoldAtStartMillis((int)(((Float)aValue).floatValue() * 1000.0f));
                    break;
                }
                case 7: {
                    entry.setHoldAtEndMillis((int)(((Float)aValue).floatValue() * 1000.0f));
                    break;
                }
                case 8: {
                    entry.setFadeInFraction(((Float)aValue).floatValue());
                    break;
                }
                case 9: {
                    entry.setFadeOutFraction(((Float)aValue).floatValue());
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
            PlayListGraphicPanel.this.fireTargetModified();
        }

        private float tableRangeToTargetRange(PlayListEntry entry, float tableRange) {
            LocationLayerGraphic graphic = entry.getGraphic();
            if (graphic instanceof SpriteSequenceGraphic) {
                int maxFrame = ((SpriteSequenceGraphic)graphic).getFramesCount() - 1;
                return maxFrame == 0 ? 0.0f : tableRange / (float)maxFrame;
            }
            return tableRange;
        }

        private float targetRangeToTableRange(PlayListEntry entry, float targetRange) {
            LocationLayerGraphic graphic = entry.getGraphic();
            if (graphic instanceof SpriteSequenceGraphic) {
                int maxFrame = ((SpriteSequenceGraphic)graphic).getFramesCount() - 1;
                return targetRange * (float)maxFrame;
            }
            return targetRange;
        }
    }
}

