/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.common.ProgressObserver;
import com.sodiumarc.patchwork.app.common.SimpleApp;
import com.sodiumarc.patchwork.app.scenecomposer.CreditsDialog;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerProperties;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.resource.ResourceManager;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.AudioPlayerControlDialog;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridViewerPanel;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.LoadGameAction;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.RedoAction;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.SaveGameAction;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.UndoAction;
import com.sodiumarc.patchwork.util.LoggerStream;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class PatchworkPlayerApp
extends SimpleApp {
    public static final String TITLE = "Gorogoa";
    public static final BufferedImage APP_ICON = ResourceManager.getImageResource("system/player_icon_16.png");
    public static final int GRID_SIZE = 800;
    public static final Dimension PREFERRED_SIZE = new Dimension(880, 900);
    private MouseListener startMouseListener;
    private GridViewerPanel gridViewer;
    private AudioPlayerControlDialog audioDialog;
    private CreditsDialog creditsDialog;
    private AbstractAction restartGameAction;
    private PatchworkProject project;
    private boolean readyToStart = false;
    private static PatchworkPlayerApp INSTANCE;
    private static final Logger LOGGER;

    public static void main(String[] args) {
        PatchworkPlayerApp.loadProperties();
        PatchworkPlayerApp.launchApp(args, PatchworkPlayerApp.getInstance());
    }

    public static PatchworkPlayerApp getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PatchworkPlayerApp();
        }
        return INSTANCE;
    }

    public PatchworkPlayerApp() throws HeadlessException {
        super(TITLE, PatchworkPlayerApp.PREFERRED_SIZE.width, PatchworkPlayerApp.PREFERRED_SIZE.height);
        this.setAppMenuEnabled(false);
        this.setIconImage(APP_ICON);
        if (PatchworkComposerProperties.ROUTE_STDERR_TO_LOG.getBoolean()) {
            System.setErr(new LoggerStream(LOGGER, Level.ERROR));
        }
        LOGGER.info("Character encoding: " + System.getProperty("file.encoding"));
    }

    @Override
    protected Component createMainPanel(SimpleApp app) {
        this.gridViewer = new GridViewerPanel(PatchworkProject.CARD_DIMENSION, false);
        this.audioDialog = new AudioPlayerControlDialog((Window)this, Dialog.ModalityType.APPLICATION_MODAL, this.gridViewer.getAudioPlayer());
        this.creditsDialog = new CreditsDialog((Window)this, Dialog.ModalityType.APPLICATION_MODAL);
        this.creditsDialog.setSize(500, 600);
        this.createGameMenu();
        this.createOptionsMenu();
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getModifiers() == 0) {
                    PatchworkPlayerApp.this.keyPressed();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
        this.startMouseListener = new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                PatchworkPlayerApp.this.keyPressed();
            }
        };
        this.addKeyListener(keyListener);
        this.gridViewer.addMouseListener(this.startMouseListener);
        return this.gridViewer;
    }

    @Override
    protected void onLaunch() {
        this.preload();
    }

    private void createGameMenu() {
        JMenu gameMenu = this.addMenu("Game");
        AbstractAction creditsAction = new AbstractAction("Credits..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatchworkPlayerApp.this.creditsDialog.setLocationRelativeTo(PatchworkPlayerApp.this);
                PatchworkPlayerApp.this.creditsDialog.setVisible(true);
            }
        };
        this.restartGameAction = new AbstractAction("Restart"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatchworkPlayerApp.this.restart();
            }
        };
        this.restartGameAction.setEnabled(false);
        AbstractAction quitGameAction = new AbstractAction("Quit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatchworkPlayerApp.this.exit();
            }
        };
        this.addMenuItem(gameMenu, this.restartGameAction, null);
        this.addMenuSeparator(gameMenu);
        this.addMenuItem(gameMenu, new SaveGameAction(this.gridViewer), "shift control S");
        this.addMenuItem(gameMenu, new LoadGameAction(this.gridViewer), "shift control O");
        this.addMenuSeparator(gameMenu);
        this.addMenuItem(gameMenu, new UndoAction(this.gridViewer), "control Z");
        this.addMenuItem(gameMenu, new RedoAction(this.gridViewer), "control Y");
        this.addMenuSeparator(gameMenu);
        this.addMenuItem(gameMenu, creditsAction, null);
        this.addMenuSeparator(gameMenu);
        this.addMenuItem(gameMenu, quitGameAction, null);
    }

    private void createOptionsMenu() {
        JMenu optionsMenu = this.addMenu("Options");
        AbstractAction fullscreenAction = new AbstractAction("Full Screen"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractButton aButton = (AbstractButton)e.getSource();
                boolean selected = aButton.getModel().isSelected();
                PatchworkPlayerApp.this.setFullscreen(selected, null);
            }
        };
        fullscreenAction.setEnabled(this.isFullScreenSupported());
        AbstractAction showHotspotsAction = new AbstractAction("Show Hotspots"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractButton aButton = (AbstractButton)e.getSource();
                boolean selected = aButton.getModel().isSelected();
                PatchworkPlayerApp.this.gridViewer.setOptionEnabled(CardViewer.Option.SHOW_HOTSPOTS, selected);
            }
        };
        showHotspotsAction.setEnabled(this.isFullScreenSupported());
        AbstractAction soundAction = new AbstractAction("Sound..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatchworkPlayerApp.this.audioDialog.setLocationRelativeTo(PatchworkPlayerApp.this);
                PatchworkPlayerApp.this.audioDialog.setVisible(true);
            }
        };
        this.addCheckBoxItem(optionsMenu, showHotspotsAction, null, false);
        this.addMenuItem(optionsMenu, soundAction, null);
    }

    private JMenu createFullScreenSubmenu() {
        JMenu result = this.addMenu("Full Screen Mode...");
        List<DisplayMode> modes = this.getCompatibleDisplayModes();
        DisplayMode preferredMode = this.chooseBestDisplayMode(modes, PREFERRED_SIZE);
        ButtonGroup buttonGroup = new ButtonGroup();
        AbstractAction currentAction = new AbstractAction("Current"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatchworkPlayerApp.this.setFullscreen(true, null);
            }
        };
        this.addRadioButtonItem(result, currentAction, null, buttonGroup, false);
        for (DisplayMode mode : modes) {
            String desc = String.format("(%d x %d)", mode.getWidth(), mode.getHeight());
            if (mode.equals(preferredMode)) {
                desc = "<html><i>" + desc + "</i> *</html>";
            }
            final DisplayMode fMode = mode;
            AbstractAction action = new AbstractAction(desc){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PatchworkPlayerApp.this.setFullscreen(true, fMode);
                }
            };
            this.addRadioButtonItem(result, action, null, buttonGroup, false);
        }
        this.addMenuSeparator(result);
        AbstractAction action = new AbstractAction("None"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatchworkPlayerApp.this.setFullscreen(false, null);
            }
        };
        this.addRadioButtonItem(result, action, null, buttonGroup, true);
        return result;
    }

    private void preload() {
        this.setInputEnabled(false);
        SimpleApp.BlockingWorker<PatchworkProject, Object> worker = new SimpleApp.BlockingWorker<PatchworkProject, Object>(null){

            @Override
            protected PatchworkProject doInBackground(ProgressObserver observer) throws Exception {
                InputStream projectInputStream = ResourceManager.getInputStream(PatchworkComposerProperties.PROJECT_FILE.getValue());
                if (projectInputStream == null) {
                    return null;
                }
                final PatchworkProject project = PatchworkProject.loadFromStream(projectInputStream);
                if (project != null) {
                    project.setPublished(true);
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            BufferedImage titleImage = project.getTitleImage();
                            PatchworkPlayerApp.this.gridViewer.setTitleImage(titleImage);
                            PatchworkPlayerApp.this.gridViewer.setShowLoadingPercent(true);
                            PatchworkPlayerApp.this.gridViewer.setInPrologue(true, true);
                            PatchworkPlayerApp.this.creditsDialog.setText(project.getCreditsString());
                        }
                    });
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PatchworkPlayerApp.this.gridViewer.playOpeningScore(project);
                        }
                    });
                    project.preload(observer);
                }
                return project;
            }

            @Override
            protected void progressChanged(int percentComplete) {
                PatchworkPlayerApp.this.gridViewer.setLoadingPercent(percentComplete);
            }

            @Override
            protected void done(PatchworkProject result) {
                PatchworkPlayerApp.this.project = result;
                PatchworkPlayerApp.this.gridViewer.setLoadingPercent(100);
                PatchworkPlayerApp.this.readyToStart = true;
            }
        };
        worker.execute();
    }

    private void restart() {
        this.gridViewer.restart();
    }

    private void start() {
        this.gridViewer.setShowLoadingPercent(false);
        this.gridViewer.setProject(this.project);
        this.gridViewer.newGame();
        this.readyToStart = false;
        this.restartGameAction.setEnabled(true);
    }

    private void keyPressed() {
        if (this.readyToStart) {
            this.gridViewer.removeMouseListener(this.startMouseListener);
            this.start();
        }
    }

    static {
        LOGGER = Logger.getLogger(PatchworkPlayerApp.class);
    }
}

