/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.common.ProgressObserver;
import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.AddChildPanel;
import com.sodiumarc.patchwork.app.scenecomposer.CardLinkPanel;
import com.sodiumarc.patchwork.app.scenecomposer.CardPanel;
import com.sodiumarc.patchwork.app.scenecomposer.HoleGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.InterpolatedViewpointPanel;
import com.sodiumarc.patchwork.app.scenecomposer.LayeredImageGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.LinkedGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.LocationTransitionPanel;
import com.sodiumarc.patchwork.app.scenecomposer.MotionKeyframeGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerProperties;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkProjectPanel;
import com.sodiumarc.patchwork.app.scenecomposer.PlayListGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.PredicatePanel;
import com.sodiumarc.patchwork.app.scenecomposer.SceneLayerPanel;
import com.sodiumarc.patchwork.app.scenecomposer.SceneLayerStatePanel;
import com.sodiumarc.patchwork.app.scenecomposer.SceneLocationLayerPanel;
import com.sodiumarc.patchwork.app.scenecomposer.SceneLocationPanel;
import com.sodiumarc.patchwork.app.scenecomposer.ScenePanel;
import com.sodiumarc.patchwork.app.scenecomposer.ShadowGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.SlideGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.SoundClipPanel;
import com.sodiumarc.patchwork.app.scenecomposer.SoundSequencePanel;
import com.sodiumarc.patchwork.app.scenecomposer.SpriteSequenceGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.StandardViewpointPanel;
import com.sodiumarc.patchwork.app.scenecomposer.StateTransitionPanel;
import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3Publisher;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponentListener;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.CardLink;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.LocationTransition;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.Predicate;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.StateTransition;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.HoleGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LayeredImageGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LinkedGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.MotionKeyframesGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.PlayListGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.ShadowGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.SlideGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.SpriteSequenceGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundClip;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequence;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.InterpolatedViewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.StandardViewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.tree.ProjectComponentTree;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardAnimationControls;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardInfoPanel;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridViewerPanel;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.TargetableDialog;
import com.sodiumarc.patchwork.util.TargetablePanel;
import com.sodiumarc.patchwork.util.TargetablePanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class PatchworkComposerPanel
extends JSplitPane {
    private ProjectComponentListener projectComponentListener = new ProjectComponentListener(){

        @Override
        public void modified(List<ProjectComponent> modifiedPath) {
            PatchworkComposerPanel.this.onProjectComponentChanged(modifiedPath.get(modifiedPath.size() - 1));
        }

        @Override
        public void childComponentRemoved(List<ProjectComponent> parentPath, ProjectComponent child, int index) {
            PatchworkComposerPanel.this.onProjectComponentChanged(parentPath.get(parentPath.size() - 1));
        }

        @Override
        public void childComponentAdded(List<ProjectComponent> parentPath, ProjectComponent child, int index) {
            PatchworkComposerPanel.this.onProjectComponentChanged(parentPath.get(parentPath.size() - 1));
        }
    };
    private final AS3Publisher as3Converter = new AS3Publisher();
    private ProjectComponentTree projectTree;
    private JButton newProjectButton;
    private JButton addButton;
    private JButton deleteButton;
    private JButton editButton;
    private GridViewerPanel gridViewer;
    private JFileChooser fileChooser;
    private final Map<Class<?>, TargetableDialog<?>> editDialogs;
    private PatchworkProject currentProject;
    private final Set<PatchworkProject> modifiedProjects = new HashSet<PatchworkProject>();
    private final Set<PatchworkProject> allProjects = new HashSet<PatchworkProject>();

    public PatchworkComposerPanel() {
        super(1);
        this.editDialogs = new HashMap();
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setCurrentDirectory(PatchworkComposerProperties.AS3_OUTPUT_DIR.getFile());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.createEditDialog(Card.class, new CardPanel(), "Edit Card", null);
        this.createEditDialog(Scene.class, new ScenePanel(), "Edit Scene", null);
        this.createEditDialog(SceneLayer.class, new SceneLayerPanel(), "Edit Scene Layer", new Dimension(500, 650));
        this.createEditDialog(SceneLocationLayer.class, new SceneLocationLayerPanel(), "Edit Location Layer", null);
        this.createEditDialog(PatchworkProject.class, new PatchworkProjectPanel(), "Edit Project Settings", new Dimension(300, 400));
        this.createEditDialog(SceneLocation.class, new SceneLocationPanel(), "Edit Location", null);
        this.createEditDialog(StandardViewpoint.class, new StandardViewpointPanel(), "Edit Viewpoint", null);
        this.createEditDialog(InterpolatedViewpoint.class, new InterpolatedViewpointPanel(), "Edit Viewpoint", null);
        this.createEditDialog(LocationTransition.class, new LocationTransitionPanel(), "Edit Location Transition", null);
        this.createEditDialog(LayeredImageGraphic.class, new LayeredImageGraphicPanel(), "Edit Graphic", null);
        this.createEditDialog(SpriteSequenceGraphic.class, new SpriteSequenceGraphicPanel(), "Edit Graphic", null);
        this.createEditDialog(MotionKeyframesGraphic.class, new MotionKeyframeGraphicPanel(), "Edit Graphic", new Dimension(800, 700));
        this.createEditDialog(SlideGraphic.class, new SlideGraphicPanel(), "Edit Graphic", null);
        this.createEditDialog(PlayListGraphic.class, new PlayListGraphicPanel(), "Edit Graphic", new Dimension(800, 700));
        this.createEditDialog(HoleGraphic.class, new HoleGraphicPanel(), "Edit Graphic", null);
        this.createEditDialog(ShadowGraphic.class, new ShadowGraphicPanel(), "Shadow Graphic", null);
        this.createEditDialog(LinkedGraphic.class, new LinkedGraphicPanel(), "Edit Graphic", null);
        this.createEditDialog(SceneLayerState.class, new SceneLayerStatePanel(), "Edit State", null);
        this.createEditDialog(StateTransition.class, new StateTransitionPanel(), "Edit Transition", new Dimension(300, 250));
        this.createEditDialog(Predicate.class, new PredicatePanel(), "Edit Predicate", null);
        this.createEditDialog(CardLink.class, new CardLinkPanel(), "Edit Card Link", null);
        this.createEditDialog(SoundClip.class, new SoundClipPanel(), "Edit Sound Clip", new Dimension(300, 200));
        this.createEditDialog(SoundSequence.class, new SoundSequencePanel(), "Edit Sound Sequence", new Dimension(600, 450));
        this.setDividerLocation(250);
        this.add(this.createTreePanel());
        this.add(this.createViewerPanel());
        this.updateControlEnabling();
    }

    public boolean checkProjectName(String newName, boolean showMessage) {
        assert (newName != null);
        if ((newName = newName.trim()).isEmpty() || !PatchworkProject.isValidName(newName)) {
            if (showMessage) {
                JOptionPane.showMessageDialog(this, "Invalid name: \"" + newName + "\"");
            }
            return false;
        }
        for (PatchworkProject project : this.allProjects) {
            if (!project.getID().equals(newName)) continue;
            if (showMessage) {
                JOptionPane.showMessageDialog(this, "Name already in use: \"" + newName + "\"");
            }
            return false;
        }
        return true;
    }

    public void initProject() {
        new SwingWorker<PatchworkProject, Object>(){

            @Override
            protected PatchworkProject doInBackground() throws Exception {
                File projectFile = new File(PatchworkComposerProperties.PROJECT_DIR.getFile(), PatchworkComposerProperties.PROJECT_FILE.getValue());
                if (!projectFile.exists()) {
                    return null;
                }
                PatchworkProject project = PatchworkProject.loadFromFile(projectFile);
                return project;
            }

            @Override
            protected void done() {
                try {
                    PatchworkProject project = (PatchworkProject)this.get();
                    if (project != null) {
                        PatchworkComposerPanel.this.addProject(project);
                        PatchworkComposerPanel.this.gridViewer.setProject(project);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.execute();
    }

    public void save(boolean forceResave) {
        HashSet<PatchworkProject> toSave = new HashSet<PatchworkProject>(forceResave ? this.allProjects : this.modifiedProjects);
        this.modifiedProjects.clear();
        for (PatchworkProject project : toSave) {
            project.save(PatchworkComposerProperties.PROJECT_DIR.getFile());
        }
        this.projectTree.repaint();
        this.updateControlEnabling();
    }

    public void exportAS3() {
        Set<Card> cards = this.projectTree.getSelectionByType(Card.class, true);
        if (cards.isEmpty()) {
            return;
        }
        PatchworkProject project = CollectionUtils.first(cards).getAncestorByType(PatchworkProject.class);
        int result = this.fileChooser.showSaveDialog(this);
        if (result == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.as3Converter.publishProject(project, cards, file);
        }
    }

    public void publish(ProgressObserver listener) {
        PatchworkProject project = CollectionUtils.first(this.allProjects);
        if (project == null) {
            listener.setProgress(0, 0, null);
            return;
        }
        project.publish(listener);
    }

    public void preload(ProgressObserver listener) {
        PatchworkProject project = CollectionUtils.first(this.allProjects);
        if (project == null) {
            listener.setProgress(0, 0, null);
            return;
        }
        project.preload(listener);
    }

    public <T> void showEditDialog(T selection) {
        if (selection == null) {
            return;
        }
        TargetableDialog<?> dialog = this.editDialogs.get(selection.getClass());
        if (dialog != null) {
            dialog.getTargetablePanel().setTarget(selection);
            dialog.showDialog();
        }
    }

    protected void projectsModified(Set<PatchworkProject> modifiedProjects) {
    }

    private Component createTreePanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 2));
        this.projectTree = new ProjectComponentTree(true){

            @Override
            protected void onSelectionChanged(Set<ProjectComponent> selection) {
                PatchworkComposerPanel.this.onTreeSelectionChanged();
            }

            @Override
            protected void onDoubleClick(Object lastPathComponent) {
                ProjectComponent singleSelection = PatchworkComposerPanel.this.projectTree.getSingleSelection();
                if (PatchworkComposerPanel.this.editDialogs.containsKey(singleSelection.getClass())) {
                    PatchworkComposerPanel.this.onEdit();
                }
            }

            @Override
            protected boolean canDropChildComponents(ProjectComponent parent, Set<ProjectComponent> children, int insertIndex) {
                for (ProjectComponent child : children) {
                    if (!child.isRemovable() || !parent.getAddableChildTypes().containsKey(child.getClass())) {
                        return false;
                    }
                    if (!parent.equals(child.getParentComponent()) || insertIndex >= 0) continue;
                    return false;
                }
                return true;
            }

            @Override
            protected void dropChildComponents(ProjectComponent parent, Set<ProjectComponent> children, int insertIndex) {
                for (ProjectComponent child : children) {
                    child.getParentComponent().removeChildComponent(child);
                    parent.addChildComponent(child, insertIndex);
                }
            }
        };
        JScrollPane listScroller = new JScrollPane(this.projectTree);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 4, 2, 2));
        this.newProjectButton = new JButton(null, IconLoader.loadIcon("silk/book_add.png"));
        this.newProjectButton.setToolTipText("New Project");
        this.newProjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PatchworkComposerPanel.this.onNewProject();
            }
        });
        buttonPanel.add(this.newProjectButton);
        this.addButton = new JButton(null, IconLoader.loadIcon("silk/shape_square_add.png"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PatchworkComposerPanel.this.onAdd();
            }
        });
        this.addButton.setToolTipText("Add");
        buttonPanel.add(this.addButton);
        this.deleteButton = new JButton(null, IconLoader.loadIcon("silk/shape_square_delete.png"));
        this.deleteButton.setToolTipText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PatchworkComposerPanel.this.onDelete();
            }
        });
        buttonPanel.add(this.deleteButton);
        this.editButton = new JButton(null, IconLoader.loadIcon("silk/shape_square_edit.png"));
        this.editButton.setToolTipText("Edit");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PatchworkComposerPanel.this.onEdit();
            }
        });
        buttonPanel.add(this.editButton);
        panel.add((Component)listScroller, "Center");
        panel.add((Component)buttonPanel, "South");
        panel.setBorder(BorderFactory.createTitledBorder("Projects"));
        return panel;
    }

    private Component createViewerPanel() {
        JPanel result = new JPanel(new BorderLayout(5, 5));
        this.gridViewer = new GridViewerPanel(PatchworkProject.CARD_DIMENSION, true);
        CardInfoPanel cardInfoPanel = new CardInfoPanel(this.gridViewer);
        CardAnimationControls cardAnimationControls = new CardAnimationControls(this.gridViewer);
        JScrollPane gridScroller = new JScrollPane(this.gridViewer);
        result.add((Component)cardInfoPanel, "North");
        result.add((Component)gridScroller, "Center");
        result.add((Component)cardAnimationControls, "South");
        result.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return result;
    }

    public GridViewerPanel getGridViewer() {
        return this.gridViewer;
    }

    protected void updateControlEnabling() {
        ProjectComponent selected = this.projectTree.getSingleSelection();
        this.addButton.setEnabled(selected != null && !selected.getAddableChildTypes().isEmpty());
        this.deleteButton.setEnabled(selected != null && selected.isRemovable());
        if (selected != null) {
            this.editButton.setEnabled(this.editDialogs.containsKey(selected.getClass()));
        } else {
            this.editButton.setEnabled(false);
        }
        if (!this.modifiedProjects.isEmpty()) {
            this.projectsModified(this.modifiedProjects);
        }
    }

    private void onEdit() {
        ProjectComponent singleSelection = this.projectTree.getSingleSelection();
        this.showEditDialog(singleSelection);
    }

    private void onAdd() {
        ProjectComponent selected = this.projectTree.getSingleSelection();
        AddChildPanel addChildPanel = new AddChildPanel(selected);
        int paneResult = JOptionPane.showConfirmDialog(this, addChildPanel, "Add Child", 2);
        if (paneResult == 0) {
            selected.addChildComponent(addChildPanel.getID(), addChildPanel.getChildType());
            this.modifiedProjects.add(this.currentProject);
        }
        this.updateControlEnabling();
    }

    private void onDelete() {
        ProjectComponent selected = this.projectTree.getSingleSelection();
        PatchworkProject selectedProject = this.projectTree.getSingleSelectionByType(PatchworkProject.class, true);
        if (selected == null || selectedProject == null) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(this, "Delete \"" + selected + "\"?", "Confirm Delete", 2);
        if (result == 0) {
            selected.getParentComponent().removeChildComponent(selected);
        }
        this.modifiedProjects.add(selectedProject);
        this.updateControlEnabling();
    }

    private void onTreeSelectionChanged() {
        this.currentProject = this.projectTree.getSingleSelectionByType(PatchworkProject.class, true);
        this.gridViewer.setTarget(this.projectTree.getSingleSelection());
        this.updateControlEnabling();
    }

    private void onNewProject() {
        PatchworkProject project = new PatchworkProject(this.newUniqueProjectName("New Project"));
        this.addProject(project);
    }

    private void addProject(PatchworkProject project) {
        project.addListener(this.projectComponentListener);
        this.allProjects.add(project);
        this.updateProjectList();
        this.updateControlEnabling();
    }

    private void onProjectComponentChanged(ProjectComponent projectComponent) {
        this.modifiedProjects.add(projectComponent.getAncestorByType(PatchworkProject.class));
        this.projectTree.updateSelectionDisplay();
        this.updateControlEnabling();
        this.gridViewer.setTarget(this.projectTree.getSingleSelection());
    }

    private String newUniqueProjectName(String desiredName) {
        String name = desiredName;
        int index = 1;
        while (!this.checkProjectName(name, false)) {
            name = desiredName + "_" + index;
            ++index;
        }
        return name;
    }

    private void updateProjectList() {
        this.projectTree.setRoots(this.allProjects);
        this.onTreeSelectionChanged();
    }

    private <T extends ProjectComponent> void createEditDialog(Class<T> type, TargetablePanel<T> panel, String title, Dimension size) {
        panel.addListener(new TargetablePanelListener(){

            @Override
            public void targetModified(TargetablePanel<?> source) {
                PatchworkComposerPanel.this.onProjectComponentChanged((ProjectComponent)source.getTarget());
            }

            @Override
            public void targetChanged(TargetablePanel<?> source) {
            }
        });
        TargetableDialog<T> dialog = new TargetableDialog<T>(SwingUtilities.getWindowAncestor(this), title, Dialog.ModalityType.APPLICATION_MODAL, size, panel);
        this.editDialogs.put(type, dialog);
    }
}

