/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.common.ProgressObserver;
import com.sodiumarc.patchwork.app.common.SimpleApp;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerPanel;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkPlayerApp;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridViewerPanel;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.LoadGameAction;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.RedoAction;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.SaveGameAction;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.UndoAction;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.ProgressMonitor;

public class PatchworkComposerApp
extends SimpleApp {
    public static String TITLE = "Patchwork Composer";
    public static final Rectangle4d BLENDER_VIEWPORT = new Rectangle4d(-0.45, -0.45, 0.9, 0.9);
    public static final Rectangle4d CAMERA_VIEWPORT = new Rectangle4d(-0.5, -0.5, 1.0, 1.0);
    public static Rectangle4d CANONICAL_RECT = new Rectangle4d(0.0, 0.0, 1.0, 1.0);
    private PatchworkComposerPanel mainPanel;
    private static PatchworkComposerApp INSTANCE;

    public static void main(String[] args) {
        PatchworkComposerApp.loadProperties();
        PatchworkComposerApp.launchApp(args, PatchworkComposerApp.getInstance());
    }

    public static PatchworkComposerApp getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PatchworkComposerApp();
        }
        return INSTANCE;
    }

    public PatchworkComposerPanel getMainPanel() {
        return this.mainPanel;
    }

    @Override
    protected Component createMainPanel(SimpleApp app) {
        this.mainPanel = new PatchworkComposerPanel(){

            @Override
            protected void projectsModified(Set<PatchworkProject> modifiedProjects) {
                PatchworkComposerApp.this.setSaveRequired(!modifiedProjects.isEmpty());
            }
        };
        AbstractAction resaveAction = new AbstractAction("Force Resave"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatchworkComposerApp.this.mainPanel.save(true);
            }
        };
        AbstractAction publishAction = new AbstractAction("Publish..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatchworkComposerApp.this.publish();
            }
        };
        AbstractAction preloadAction = new AbstractAction("Preload..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatchworkComposerApp.this.preload();
            }
        };
        AbstractAction exportAction = new AbstractAction("Export AS3..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatchworkComposerApp.this.mainPanel.exportAS3();
            }
        };
        this.addAppMenuItem(resaveAction, null);
        this.addAppMenuItem(publishAction, null);
        this.addAppMenuItem(preloadAction, null);
        this.addAppMenuItem(exportAction, null);
        this.createViewMenu();
        this.createGameMenu();
        return this.mainPanel;
    }

    @Override
    protected void onSave() {
        this.mainPanel.save(false);
    }

    @Override
    protected void onLaunch() {
        this.mainPanel.initProject();
    }

    private PatchworkComposerApp() throws HeadlessException {
        super(TITLE, 1240, 1000);
    }

    private void createViewMenu() {
        final GridViewerPanel locationViewer = this.mainPanel.getGridViewer();
        JMenu viewMenu = this.addMenu("View");
        AbstractAction showHotspotsAction = new AbstractAction("Toggle Hotspots"){

            @Override
            public void actionPerformed(ActionEvent e) {
                locationViewer.toggleOption(CardViewer.Option.SHOW_HOTSPOTS);
            }
        };
        AbstractAction showRefsAction = new AbstractAction("Toggle Ref Shapes"){

            @Override
            public void actionPerformed(ActionEvent e) {
                locationViewer.toggleOption(CardViewer.Option.SHOW_REFS);
            }
        };
        AbstractAction showBoundariesAction = new AbstractAction("Toggle Boundaries"){

            @Override
            public void actionPerformed(ActionEvent e) {
                locationViewer.toggleOption(CardViewer.Option.SHOW_BOUNDARIES);
            }
        };
        AbstractAction showMarginsAction = new AbstractAction("Toggle Margins"){

            @Override
            public void actionPerformed(ActionEvent e) {
                locationViewer.toggleOption(CardViewer.Option.SHOW_MARGINS);
            }
        };
        AbstractAction showBackgroundAction = new AbstractAction("Toggle Background"){

            @Override
            public void actionPerformed(ActionEvent e) {
                locationViewer.toggleOption(CardViewer.Option.SHOW_BACKGROUND);
            }
        };
        viewMenu.add(this.createFullScreenSubmenu());
        this.addMenuSeparator(viewMenu);
        this.addMenuItem(viewMenu, showHotspotsAction, "alt H");
        this.addMenuItem(viewMenu, showRefsAction, "alt R");
        this.addMenuItem(viewMenu, showBoundariesAction, "alt B");
        this.addMenuItem(viewMenu, showMarginsAction, "alt M");
        this.addMenuItem(viewMenu, showBackgroundAction, "alt G");
    }

    private JMenu createFullScreenSubmenu() {
        JMenu result = this.addMenu("Full Screen Mode...");
        List<DisplayMode> modes = this.getCompatibleDisplayModes();
        DisplayMode preferredMode = this.chooseBestDisplayMode(modes, PatchworkPlayerApp.PREFERRED_SIZE);
        ButtonGroup buttonGroup = new ButtonGroup();
        AbstractAction currentAction = new AbstractAction("Current"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatchworkComposerApp.this.setFullscreen(true, null);
            }
        };
        this.addRadioButtonItem(result, currentAction, null, buttonGroup, false);
        for (DisplayMode mode : modes) {
            String desc = String.format("(%d x %d)", mode.getWidth(), mode.getHeight());
            if (mode.equals(preferredMode)) {
                desc = "<html><i>" + desc + "</i> *</html>";
            }
            final DisplayMode fMode = mode;
            AbstractAction action = new AbstractAction(desc){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PatchworkComposerApp.this.setFullscreen(true, fMode);
                }
            };
            this.addRadioButtonItem(result, action, null, buttonGroup, false);
        }
        this.addMenuSeparator(result);
        AbstractAction action = new AbstractAction("None"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatchworkComposerApp.this.setFullscreen(false, null);
            }
        };
        this.addRadioButtonItem(result, action, null, buttonGroup, true);
        return result;
    }

    private void createGameMenu() {
        GridViewerPanel gridViewer = this.mainPanel.getGridViewer();
        JMenu gameMenu = this.addMenu("Game");
        this.addMenuItem(gameMenu, new SaveGameAction(gridViewer), "shift control S");
        this.addMenuItem(gameMenu, new LoadGameAction(gridViewer), "shift control O");
        this.addMenuSeparator(gameMenu);
        this.addMenuItem(gameMenu, new UndoAction(gridViewer), "control Z");
        this.addMenuItem(gameMenu, new RedoAction(gridViewer), "control Y");
    }

    private void publish() {
        MyWorker worker = new MyWorker(this, "Publishing Resources..."){

            @Override
            protected Object doInBackground(ProgressObserver observer) {
                try {
                    PatchworkComposerApp.this.mainPanel.publish(observer);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return null;
            }
        };
        worker.execute();
    }

    private void preload() {
        MyWorker worker = new MyWorker(this, "Loading..."){

            @Override
            protected Object doInBackground(ProgressObserver observer) {
                try {
                    PatchworkComposerApp.this.mainPanel.preload(observer);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return null;
            }
        };
        worker.execute();
    }

    private abstract class MyWorker
    extends SimpleApp.BlockingWorker<Object, Object> {
        MyWorker(Component parent, String description) {
            super(new ProgressMonitor(parent, description, "", 0, 100));
        }
    }
}

