/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.ColladaFileComboBox;
import com.sodiumarc.patchwork.app.scenecomposer.LocationLayerGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.MotionKeyframesGraphic;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;

public class MotionKeyframeGraphicPanel
extends LocationLayerGraphicPanel<MotionKeyframesGraphic> {
    private ColladaFileComboBox filenameCombo;
    private JComboBox orthoFrameCombo;
    private JComboBox cutoutFrameCombo;
    private ActionListener filenameComboListener;
    private ActionListener orthoFrameComboListener;
    private ActionListener cutoutFrameComboListener;
    private TreeChooserButton graphicButton;
    private JComboBox translationModeCombo;
    private JComboBox rotationModeCombo;
    private ActionListener modeComboListener;
    private JCheckBox pixelSnapCheckbox;
    private ActionListener pixelSnapListener;
    private LabeledRowPanel.LabeledRow orthoFrameRow;
    private LabeledRowPanel.LabeledRow cutoutFrameRow;
    private AnimationNodeTableModel tableModel;

    @Override
    protected JComponent getMainArea() {
        this.filenameCombo = new ColladaFileComboBox();
        this.filenameComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MotionKeyframesGraphic target = (MotionKeyframesGraphic)MotionKeyframeGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setInputFilename((String)MotionKeyframeGraphicPanel.this.filenameCombo.getSelectedItem());
                    MotionKeyframeGraphicPanel.this.tableModel.update();
                    MotionKeyframeGraphicPanel.this.updateFrameCombos();
                    MotionKeyframeGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.orthoFrameCombo = new JComboBox();
        this.orthoFrameComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MotionKeyframesGraphic target = (MotionKeyframesGraphic)MotionKeyframeGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setOrthoFrameMeshID((String)MotionKeyframeGraphicPanel.this.orthoFrameCombo.getSelectedItem());
                    MotionKeyframeGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.cutoutFrameCombo = new JComboBox();
        this.cutoutFrameComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MotionKeyframesGraphic target = (MotionKeyframesGraphic)MotionKeyframeGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setCutoutFrameMeshID((String)MotionKeyframeGraphicPanel.this.cutoutFrameCombo.getSelectedItem());
                    MotionKeyframeGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.graphicButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((MotionKeyframesGraphic)MotionKeyframeGraphicPanel.this.getTarget()).setGraphic((LocationLayerGraphic)selection);
                MotionKeyframeGraphicPanel.this.fireTargetModified();
            }
        };
        HashSet types = new HashSet();
        types.add(LocationLayerGraphic.class);
        this.graphicButton.setEnabledTypes(types);
        this.translationModeCombo = this.makeKeyframeModeCombo();
        this.rotationModeCombo = this.makeKeyframeModeCombo();
        this.modeComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MotionKeyframesGraphic target = (MotionKeyframesGraphic)MotionKeyframeGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setRotationKeyframeMode((MotionKeyframesGraphic.KeyframeMode)((Object)MotionKeyframeGraphicPanel.this.rotationModeCombo.getSelectedItem()));
                    target.setTranslationKeyframeMode((MotionKeyframesGraphic.KeyframeMode)((Object)MotionKeyframeGraphicPanel.this.translationModeCombo.getSelectedItem()));
                    MotionKeyframeGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.pixelSnapCheckbox = new JCheckBox();
        this.pixelSnapListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MotionKeyframesGraphic target = (MotionKeyframesGraphic)MotionKeyframeGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setPixelSnapEnabled(MotionKeyframeGraphicPanel.this.pixelSnapCheckbox.isSelected());
                }
            }
        };
        JButton saveSamplesButton = new JButton("Save Samples");
        saveSamplesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MotionKeyframesGraphic target = (MotionKeyframesGraphic)MotionKeyframeGraphicPanel.this.getTarget();
                if (target != null) {
                    target.saveSamples();
                }
            }
        });
        JButton refreshButton = new JButton("Refresh", IconLoader.loadIcon("silk/arrow_refresh.png"));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MotionKeyframesGraphic target = (MotionKeyframesGraphic)MotionKeyframeGraphicPanel.this.getTarget();
                if (target != null) {
                    target.refresh();
                }
            }
        });
        ArrayList<LabeledRowPanel.LabeledRow> colladaRows = new ArrayList<LabeledRowPanel.LabeledRow>();
        colladaRows.add(new LabeledRowPanel.LabeledRow("Input Filename:", (Component)this.filenameCombo, true));
        this.orthoFrameRow = new LabeledRowPanel.LabeledRow("Ortho Frame ID:", (Component)this.orthoFrameCombo, true);
        colladaRows.add(this.orthoFrameRow);
        this.cutoutFrameRow = new LabeledRowPanel.LabeledRow("Cutout Frame ID:", (Component)this.cutoutFrameCombo, true);
        colladaRows.add(this.cutoutFrameRow);
        JPanel colladaPanel = new JPanel(new BorderLayout(8, 8));
        colladaPanel.add((Component)new LabeledRowPanel(colladaRows), "North");
        colladaPanel.add((Component)new JScrollPane(this.createNodeNameTable()), "Center");
        TitledBorder titleBorder = BorderFactory.createTitledBorder("COLLADA Link");
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        colladaPanel.setBorder(BorderFactory.createCompoundBorder(titleBorder, emptyBorder));
        ArrayList<LabeledRowPanel.LabeledRow> animRows = new ArrayList<LabeledRowPanel.LabeledRow>();
        animRows.add(new LabeledRowPanel.LabeledRow("Translation Mode:", (Component)this.translationModeCombo));
        animRows.add(new LabeledRowPanel.LabeledRow("Rotation Mode:", (Component)this.rotationModeCombo));
        animRows.add(new LabeledRowPanel.LabeledRow("Pixel Snap:", (Component)this.pixelSnapCheckbox));
        animRows.add(new LabeledRowPanel.LabeledRow("Graphic:", (Component)this.graphicButton, true));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(refreshButton);
        buttonPanel.add(saveSamplesButton);
        animRows.add(new LabeledRowPanel.LabeledRow("", (Component)buttonPanel, true));
        JPanel result = new JPanel(new GridLayout(1, 2));
        result.setLayout(new BoxLayout(result, 0));
        JPanel left = new JPanel();
        left.setLayout(new BoxLayout(left, 1));
        result.add(left);
        JPanel right = new JPanel();
        right.setLayout(new BoxLayout(right, 1));
        result.add(right);
        left.add(new LabeledRowPanel("Animation", animRows));
        left.add(this.getMarginsPanel());
        left.add(this.getCommonSettingsPanel());
        right.add(colladaPanel);
        this.tableModel.update();
        return result;
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        MotionKeyframesGraphic target = (MotionKeyframesGraphic)this.getTarget();
        this.filenameCombo.removeActionListener(this.filenameComboListener);
        this.pixelSnapCheckbox.removeActionListener(this.pixelSnapListener);
        if (target != null) {
            this.filenameCombo.setColladaParentDir(target.getIODirectory(IOFileType.COLLADA));
            this.filenameCombo.setSelectedItem(target.getInputFilename());
            this.graphicButton.setChoiceRoot(target.getAncestorByType(Card.class));
            this.graphicButton.setExpandRoot(target.getParentComponent());
            this.pixelSnapCheckbox.setSelected(target.isPixelSnapEnabled());
            this.graphicButton.setSelected(target.getGraphic());
        } else {
            this.filenameCombo.setColladaParentDir(null);
            this.graphicButton.setChoiceRoot(null);
            this.graphicButton.setExpandRoot(null);
            this.graphicButton.setSelected(null);
        }
        this.filenameCombo.addActionListener(this.filenameComboListener);
        this.pixelSnapCheckbox.addActionListener(this.pixelSnapListener);
        this.tableModel.update();
        this.updateFrameCombos();
        this.updateRadioButtons();
    }

    private JTable createNodeNameTable() {
        this.tableModel = new AnimationNodeTableModel();
        JTable table = new JTable();
        table.setModel(this.tableModel);
        table.getColumnModel().getColumn(0).setMaxWidth(60);
        table.setRowHeight(25);
        table.setRowSelectionAllowed(true);
        table.setShowVerticalLines(false);
        table.setPreferredScrollableViewportSize(new Dimension(300, 100));
        return table;
    }

    private void updateFrameCombos() {
        MotionKeyframesGraphic target = (MotionKeyframesGraphic)this.getTarget();
        String selectedItem = null;
        List<String> nodeIDs = Collections.emptyList();
        if (target != null) {
            nodeIDs = target.getPossibleOrthoFrameMeshIDs();
            selectedItem = target.getOrthoFrameMeshID();
        }
        this.updateFrameCombo(this.orthoFrameRow, this.orthoFrameCombo, this.orthoFrameComboListener, nodeIDs, selectedItem);
        selectedItem = null;
        nodeIDs = Collections.emptyList();
        if (target != null) {
            nodeIDs = target.getPossibleCutoutFrameMeshIDs();
            selectedItem = target.getCutoutFrameMeshID();
        }
        this.updateFrameCombo(this.cutoutFrameRow, this.cutoutFrameCombo, this.cutoutFrameComboListener, nodeIDs, selectedItem);
    }

    private void updateFrameCombo(LabeledRowPanel.LabeledRow row, JComboBox combo, ActionListener listener, List<String> items, String selectedItem) {
        combo.removeActionListener(listener);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel();
        items.add(0, null);
        model = new DefaultComboBoxModel<Object>(items.toArray());
        combo.setModel(model);
        row.setEnabled(!items.isEmpty());
        combo.setSelectedItem(selectedItem);
        combo.addActionListener(listener);
    }

    private void updateRadioButtons() {
        MotionKeyframesGraphic target = (MotionKeyframesGraphic)this.getTarget();
        this.translationModeCombo.removeActionListener(this.modeComboListener);
        this.rotationModeCombo.removeActionListener(this.modeComboListener);
        if (target != null) {
            this.translationModeCombo.setSelectedItem((Object)target.getTranslationKeyframeMode());
            this.rotationModeCombo.setSelectedItem((Object)target.getRotationKeyframeMode());
        } else {
            this.translationModeCombo.setSelectedIndex(0);
            this.rotationModeCombo.setSelectedIndex(0);
        }
        this.translationModeCombo.addActionListener(this.modeComboListener);
        this.rotationModeCombo.addActionListener(this.modeComboListener);
    }

    private JComboBox makeKeyframeModeCombo() {
        JComboBox<MotionKeyframesGraphic.KeyframeMode> result = new JComboBox<MotionKeyframesGraphic.KeyframeMode>(MotionKeyframesGraphic.KeyframeMode.values());
        return result;
    }

    private class AnimationNodeTableModel
    extends AbstractTableModel {
        private final List<String> possibleNodeNames = new ArrayList<String>();
        private final Set<String> selectedNodeNames = new HashSet<String>();

        private AnimationNodeTableModel() {
        }

        void update() {
            this.possibleNodeNames.clear();
            this.selectedNodeNames.clear();
            MotionKeyframesGraphic target = (MotionKeyframesGraphic)MotionKeyframeGraphicPanel.this.getTarget();
            if (target != null) {
                this.possibleNodeNames.addAll(target.getPossibleAnimationNodeNames());
                for (String nodeName : target.getAnimationNodeNames()) {
                    if (!this.possibleNodeNames.contains(nodeName)) continue;
                    this.selectedNodeNames.add(nodeName);
                }
            }
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Select";
                }
                case 1: {
                    return "Animation Node Name";
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public int getRowCount() {
            return this.possibleNodeNames.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String possibleNode = this.possibleNodeNames.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return this.selectedNodeNames.contains(possibleNode);
                }
                case 1: {
                    return possibleNode;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            boolean isSelected = (Boolean)aValue;
            String possibleNode = this.possibleNodeNames.get(rowIndex);
            if (isSelected) {
                this.selectedNodeNames.add(possibleNode);
            } else {
                this.selectedNodeNames.remove(possibleNode);
            }
            MotionKeyframesGraphic target = (MotionKeyframesGraphic)MotionKeyframeGraphicPanel.this.getTarget();
            if (target != null) {
                target.setAnimationNodeNames(this.selectedNodeNames);
                MotionKeyframeGraphicPanel.this.fireTargetModified();
            }
        }
    }
}

