/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.ImportKeyframesPanel;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentList;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.LocationTransition;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LocationTransitionPanel
extends ProjectComponentPanel<LocationTransition> {
    private ProjectComponentList<SceneLayerState> stateList;
    private JComboBox styleCombo;
    private ActionListener styleComboListener;
    private JSpinner durationSpinner;
    private ChangeListener durationSpinnerListener;
    private JSpinner xSpinner;
    private JSpinner ySpinner;
    private JSpinner wSpinner;
    private JSpinner hSpinner;
    private ChangeListener regionSpinnerListener;
    private TreeChooserButton destinationButton;
    private TreeChooserButton animStartLocationButton;
    private TreeChooserButton animEndLocationButton;
    private ImportKeyframesPanel importKeyframesPanel;

    @Override
    protected JComponent getMainArea() {
        this.stateList = new ProjectComponentList<SceneLayerState>("Attach to States", SceneLayerState.class, 3, false){

            @Override
            protected void selectionChanged(List<SceneLayerState> selected) {
                LocationTransition target = (LocationTransition)LocationTransitionPanel.this.getTarget();
                if (target != null) {
                    target.clearAttachedStates();
                    for (SceneLayerState state : selected) {
                        target.addAttachedState(state);
                    }
                    LocationTransitionPanel.this.fireTargetModified();
                }
            }
        };
        this.styleCombo = new JComboBox<LocationTransition.HotspotStyle>(LocationTransition.HotspotStyle.values());
        this.styleComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationTransitionPanel.this.onStyleChange();
            }
        };
        this.durationSpinner = new JSpinner(new SpinnerNumberModel(800, 0, 10000, 100));
        this.durationSpinnerListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((LocationTransition)LocationTransitionPanel.this.getTarget()).setTransitionDuration((Integer)LocationTransitionPanel.this.durationSpinner.getValue());
                LocationTransitionPanel.this.fireTargetModified();
            }
        };
        this.regionSpinnerListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LocationTransitionPanel.this.onRegionChange();
            }
        };
        this.xSpinner = this.makeMarginSpinner();
        this.ySpinner = this.makeMarginSpinner();
        this.wSpinner = this.makeMarginSpinner();
        this.hSpinner = this.makeMarginSpinner();
        this.destinationButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((LocationTransition)LocationTransitionPanel.this.getTarget()).setDestLocation((SceneLocation)selection);
                LocationTransitionPanel.this.fireTargetModified();
            }
        };
        this.destinationButton.setEnabledType(SceneLocation.class);
        this.animStartLocationButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((LocationTransition)LocationTransitionPanel.this.getTarget()).setAnimStartLocation((SceneLocation)selection);
                LocationTransitionPanel.this.fireTargetModified();
            }
        };
        this.animStartLocationButton.setEnabledType(SceneLocation.class);
        this.animEndLocationButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((LocationTransition)LocationTransitionPanel.this.getTarget()).setAnimEndLocation((SceneLocation)selection);
                LocationTransitionPanel.this.fireTargetModified();
            }
        };
        this.animEndLocationButton.setEnabledType(SceneLocation.class);
        this.importKeyframesPanel = new ImportKeyframesPanel(){

            @Override
            protected int getStartFrame() {
                LocationTransition target = (LocationTransition)LocationTransitionPanel.this.getTarget();
                return target == null ? 0 : target.getAnimationStartFrame();
            }

            @Override
            protected File getColladaParentDir() {
                LocationTransition target = (LocationTransition)LocationTransitionPanel.this.getTarget();
                return target == null ? null : target.getIODirectory(IOFileType.COLLADA);
            }

            @Override
            protected String getFilename() {
                LocationTransition target = (LocationTransition)LocationTransitionPanel.this.getTarget();
                return target == null ? null : target.getInputFilename();
            }

            @Override
            protected String getAnimationNodeName() {
                LocationTransition target = (LocationTransition)LocationTransitionPanel.this.getTarget();
                return target == null ? null : target.getAnimationNodeName();
            }

            @Override
            protected List<String> getAnimationNodeNames() {
                LocationTransition target = (LocationTransition)LocationTransitionPanel.this.getTarget();
                return target == null ? new ArrayList() : target.getAnimatedNodeNames();
            }

            @Override
            protected void filenameChanged(String filename) {
                LocationTransition target = (LocationTransition)LocationTransitionPanel.this.getTarget();
                if (target != null) {
                    target.setInputFilename(filename);
                    LocationTransitionPanel.this.fireTargetModified();
                }
            }

            @Override
            protected void animationNodeNameChanged(String name) {
                LocationTransition target = (LocationTransition)LocationTransitionPanel.this.getTarget();
                if (target != null) {
                    target.setAnimationNodeName(name);
                    LocationTransitionPanel.this.fireTargetModified();
                }
            }

            @Override
            protected void startFrameChanged(int frame) {
                LocationTransition target = (LocationTransition)LocationTransitionPanel.this.getTarget();
                if (target != null) {
                    target.setAnimationStartFrame(frame);
                    LocationTransitionPanel.this.fireTargetModified();
                }
            }
        };
        ArrayList<LabeledRowPanel.LabeledRow> hotspotRows = new ArrayList<LabeledRowPanel.LabeledRow>();
        hotspotRows.add(new LabeledRowPanel.LabeledRow("Style:", (Component)this.styleCombo, true));
        JPanel xyPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        xyPanel.add(this.xSpinner);
        xyPanel.add(this.ySpinner);
        hotspotRows.add(new LabeledRowPanel.LabeledRow("Position (x,y):", (Component)xyPanel, true));
        JPanel whPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        whPanel.add(this.wSpinner);
        whPanel.add(this.hSpinner);
        hotspotRows.add(new LabeledRowPanel.LabeledRow("Size (w,h):", (Component)whPanel, true));
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("Destination:", (Component)this.destinationButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("Animation Start Location:", (Component)this.animStartLocationButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("Animation End Location:", (Component)this.animEndLocationButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("Duration:", (Component)this.durationSpinner, true));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.add(new LabeledRowPanel("Transition", rows));
        leftPanel.add(new LabeledRowPanel("Hotspot", hotspotRows));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        rightPanel.add(this.importKeyframesPanel);
        rightPanel.add(this.stateList);
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 0));
        result.add(leftPanel);
        result.add(rightPanel);
        return result;
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        LocationTransition target = (LocationTransition)this.getTarget();
        this.stateList.clear();
        this.styleCombo.removeActionListener(this.styleComboListener);
        this.durationSpinner.removeChangeListener(this.durationSpinnerListener);
        if (target != null) {
            this.destinationButton.setChoiceRoot(target.getPath().get(0));
            this.destinationButton.setExpandRoot(target.getAncestorByType(Scene.class));
            this.destinationButton.setSelected(target.getDestLocation());
            this.animStartLocationButton.setChoiceRoot(target.getPath().get(0));
            this.animStartLocationButton.setExpandRoot(target.getAncestorByType(Scene.class));
            this.animStartLocationButton.setSelected(target.getAnimStartLocation());
            this.animEndLocationButton.setChoiceRoot(target.getPath().get(0));
            this.animEndLocationButton.setExpandRoot(target.getAncestorByType(Scene.class));
            this.animEndLocationButton.setSelected(target.getAnimEndLocation());
            this.styleCombo.setSelectedItem((Object)target.getHotspotStyle());
            this.durationSpinner.setValue(target.getTransitionDuration());
            ArrayList<SceneLayerState> states = new ArrayList<SceneLayerState>();
            Card card = target.getAncestorByType(Card.class);
            if (card != null) {
                for (Scene scene : card.getScenes()) {
                    for (SceneLayer sceneLayer : scene.getSceneLayers()) {
                        states.addAll(sceneLayer.getStates());
                    }
                }
                this.stateList.setContents(states, target.getAttachedStates());
            }
        }
        this.styleCombo.addActionListener(this.styleComboListener);
        this.durationSpinner.addChangeListener(this.durationSpinnerListener);
        this.importKeyframesPanel.update();
        this.updateRegion();
        this.updateEnabling();
    }

    private JSpinner makeMarginSpinner() {
        JSpinner result = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.05));
        ((JSpinner.DefaultEditor)result.getEditor()).getTextField().setColumns(4);
        result.addChangeListener(this.regionSpinnerListener);
        return result;
    }

    private void updateRegion() {
        LocationTransition target = (LocationTransition)this.getTarget();
        Rectangle4d region = new Rectangle4d(0.0, 0.0, 0.0, 0.0);
        if (target != null) {
            region = target.getHotspotRegion();
        }
        this.setSpinner(this.xSpinner, region.getX());
        this.setSpinner(this.ySpinner, region.getY());
        this.setSpinner(this.wSpinner, region.getWidth());
        this.setSpinner(this.hSpinner, region.getHeight());
    }

    private void setSpinner(JSpinner spinner, double value) {
        spinner.removeChangeListener(this.regionSpinnerListener);
        spinner.setValue(value);
        spinner.addChangeListener(this.regionSpinnerListener);
    }

    private void onStyleChange() {
        LocationTransition target = (LocationTransition)this.getTarget();
        if (target != null) {
            target.setHotspotStyle((LocationTransition.HotspotStyle)((Object)this.styleCombo.getSelectedItem()));
            this.updateEnabling();
            this.updateRegion();
            this.fireTargetModified();
        }
    }

    private void onRegionChange() {
        LocationTransition target = (LocationTransition)this.getTarget();
        if (target != null) {
            Rectangle4d newRegion = new Rectangle4d((Double)this.xSpinner.getValue(), (Double)this.ySpinner.getValue(), (Double)this.wSpinner.getValue(), (Double)this.hSpinner.getValue());
            target.setHotspotRegion(newRegion);
            this.fireTargetModified();
        }
    }

    private void updateEnabling() {
        LocationTransition target = (LocationTransition)this.getTarget();
        boolean nonEmpty = target != null && target.getHotspotStyle() != LocationTransition.HotspotStyle.NONE;
        boolean isRegion = target != null && target.getHotspotStyle() == LocationTransition.HotspotStyle.REGION;
        this.xSpinner.setEnabled(nonEmpty);
        this.ySpinner.setEnabled(nonEmpty);
        this.wSpinner.setEnabled(isRegion);
        this.hSpinner.setEnabled(isRegion);
    }
}

