/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.LocationLayerGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LinkedGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class LinkedGraphicPanel
extends LocationLayerGraphicPanel<LinkedGraphic> {
    private TreeChooserButton graphicButton;
    private JCheckBox remoteCameraCheckBox;
    private ActionListener remoteCameraListener;
    private JCheckBox prescaleCheckBox;
    private ActionListener prescaleListener;

    @Override
    protected JComponent getMainArea() {
        this.graphicButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((LinkedGraphic)LinkedGraphicPanel.this.getTarget()).setGraphic((LocationLayerGraphic)selection);
                LinkedGraphicPanel.this.fireTargetModified();
            }
        };
        this.graphicButton.setEnabledTypes(LocationLayerGraphic.class);
        this.remoteCameraCheckBox = new JCheckBox();
        this.remoteCameraListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkedGraphic target = (LinkedGraphic)LinkedGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setUseRemoteCamera(LinkedGraphicPanel.this.remoteCameraCheckBox.isSelected());
                    LinkedGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.prescaleCheckBox = new JCheckBox();
        this.prescaleListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkedGraphic target = (LinkedGraphic)LinkedGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setPrescaleGraphic(LinkedGraphicPanel.this.prescaleCheckBox.isSelected());
                    LinkedGraphicPanel.this.fireTargetModified();
                }
            }
        };
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("Graphic:", (Component)this.graphicButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("Use Remote Camera:", (Component)this.remoteCameraCheckBox, true));
        rows.add(new LabeledRowPanel.LabeledRow("Pre-Scale Source:", (Component)this.prescaleCheckBox, true));
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        result.add(new LabeledRowPanel("Link", rows));
        result.add(this.getMarginsPanel());
        result.add(this.getCommonSettingsPanel());
        return result;
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        LinkedGraphic target = (LinkedGraphic)this.getTarget();
        this.remoteCameraCheckBox.removeActionListener(this.remoteCameraListener);
        this.prescaleCheckBox.removeActionListener(this.prescaleListener);
        if (target != null) {
            this.graphicButton.setChoiceRoot(target.getPath().get(0));
            this.graphicButton.setExpandRoot(target.getParentComponent());
            this.graphicButton.setSelected(target.getGraphic());
            this.remoteCameraCheckBox.setSelected(target.getUseRemoteCamera());
            this.prescaleCheckBox.setSelected(target.isPrescaleGraphic());
        } else {
            this.graphicButton.setChoiceRoot(null);
            this.graphicButton.setExpandRoot(null);
            this.graphicButton.setSelected(null);
            this.remoteCameraCheckBox.setSelected(false);
            this.prescaleCheckBox.setSelected(false);
        }
        this.remoteCameraCheckBox.addActionListener(this.remoteCameraListener);
        this.prescaleCheckBox.addActionListener(this.prescaleListener);
    }
}

