/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.layeredimage.LayeredImagePanel;
import com.sodiumarc.patchwork.app.scanimport.ScanImportPanel;
import com.sodiumarc.patchwork.app.scenecomposer.ColladaFileComboBox;
import com.sodiumarc.patchwork.app.scenecomposer.LocationLayerGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.PointPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TraceImagePrintable;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LayeredImageGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.TargetablePanel;
import com.sodiumarc.patchwork.util.TargetablePanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class LayeredImageGraphicPanel
extends LocationLayerGraphicPanel<LayeredImageGraphic> {
    private ColladaFileComboBox filenameCombo;
    private ActionListener filenameComboListener;
    private JComboBox nodeNameCombo;
    private ActionListener nodeNameComboListener;
    private PointPanel pivotPanel;
    private PointPanel manualPivotPanel;
    private LayeredImagePanel layeredImagePanel;

    public LayeredImageGraphicPanel() {
    }

    public LayeredImageGraphicPanel(boolean showHeaderLabel) {
        super(showHeaderLabel);
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        LayeredImageGraphic target = (LayeredImageGraphic)this.getTarget();
        this.filenameCombo.removeActionListener(this.filenameComboListener);
        if (target != null) {
            this.layeredImagePanel.setTarget(target.getLayeredImage());
            this.filenameCombo.setColladaParentDir(target.getIODirectory(IOFileType.COLLADA));
            this.filenameCombo.setSelectedItem(target.getPivotFilename());
        } else {
            this.layeredImagePanel.setTarget(null);
            this.filenameCombo.setColladaParentDir(null);
            this.manualPivotPanel.setValue(null);
        }
        this.filenameCombo.addActionListener(this.filenameComboListener);
        this.updatePointPanels();
        this.updateNodeNameCombo();
    }

    @Override
    protected JComponent getMainArea() {
        this.filenameCombo = new ColladaFileComboBox();
        this.filenameComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayeredImageGraphic target = (LayeredImageGraphic)LayeredImageGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setPivotFilename((String)LayeredImageGraphicPanel.this.filenameCombo.getSelectedItem());
                    LayeredImageGraphicPanel.this.updateNodeNameCombo();
                    LayeredImageGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.nodeNameCombo = new JComboBox();
        this.nodeNameComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayeredImageGraphic target = (LayeredImageGraphic)LayeredImageGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setPivotNodeName((String)LayeredImageGraphicPanel.this.nodeNameCombo.getSelectedItem());
                    LayeredImageGraphicPanel.this.updatePointPanels();
                    LayeredImageGraphicPanel.this.fireTargetModified();
                }
            }
        };
        ArrayList<String> layerNameOptions = new ArrayList<String>();
        for (IOFileType type : IOFileType.values()) {
            layerNameOptions.add(type.name());
        }
        this.manualPivotPanel = new PointPanel(){

            @Override
            protected void valueChanged() {
                LayeredImageGraphic target = (LayeredImageGraphic)LayeredImageGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setManualPivotPoint(LayeredImageGraphicPanel.this.manualPivotPanel.getValue());
                    LayeredImageGraphicPanel.this.fireTargetModified();
                }
            }

            @Override
            protected Range<Integer> getRange() {
                return new Range<Integer>(-1000, 10000);
            }
        };
        this.pivotPanel = new PointPanel(){

            @Override
            protected void valueChanged() {
            }

            @Override
            protected Range<Integer> getRange() {
                return new Range<Integer>(-1000, 10000);
            }
        };
        JButton updateButton = new JButton("Update");
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayeredImageGraphic target = (LayeredImageGraphic)LayeredImageGraphicPanel.this.getTarget();
                if (target != null) {
                    target.updatePivotPoint();
                    LayeredImageGraphicPanel.this.updatePointPanels();
                    LayeredImageGraphicPanel.this.fireTargetModified();
                }
            }
        });
        this.pivotPanel.setEnabled(false);
        this.layeredImagePanel = new LayeredImagePanel(layerNameOptions){

            @Override
            protected File getDefaultImageDir() {
                LayeredImageGraphic target = (LayeredImageGraphic)LayeredImageGraphicPanel.this.getTarget();
                return target == null ? null : target.getIODirectory(IOFileType.LAYER_SCANS);
            }

            @Override
            protected List<FileFilter> getChoosableFileFilters() {
                return LayeredImageGraphicPanel.this.getFileFilters();
            }
        };
        this.layeredImagePanel.addListener(new TargetablePanelListener(){

            @Override
            public void targetModified(TargetablePanel<?> source) {
                LayeredImageGraphicPanel.this.fireTargetModified();
            }

            @Override
            public void targetChanged(TargetablePanel<?> source) {
            }
        });
        this.updateNodeNameCombo();
        ArrayList<LabeledRowPanel.LabeledRow> pivotRows = new ArrayList<LabeledRowPanel.LabeledRow>();
        pivotRows.add(new LabeledRowPanel.LabeledRow("COLLADA File: ", (Component)this.filenameCombo, true));
        pivotRows.add(new LabeledRowPanel.LabeledRow("Pivot Node: ", (Component)this.nodeNameCombo, true));
        pivotRows.add(new LabeledRowPanel.LabeledRow("Pivot Point: ", (Component)this.pivotPanel, true));
        pivotRows.add(new LabeledRowPanel.LabeledRow("Manual Point: ", (Component)this.manualPivotPanel, true));
        JPanel updatePanel = new JPanel(new BorderLayout());
        updatePanel.add((Component)updateButton, "East");
        pivotRows.add(new LabeledRowPanel.LabeledRow("", (Component)updatePanel, true));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.add(this.getMarginsPanel());
        leftPanel.add(new LabeledRowPanel("Pivot", pivotRows));
        leftPanel.add(this.getCommonSettingsPanel());
        JPanel result = new JPanel(new BorderLayout(10, 10));
        result.add((Component)leftPanel, "West");
        result.add((Component)this.layeredImagePanel, "Center");
        return result;
    }

    @Override
    protected ScanImportPanel getScanImportPanel() {
        return new ScanImportPanel(){

            @Override
            protected Rectangle4d getAutoCropRegion() {
                int gridSize = PatchworkProject.CARD_SIZE * 2;
                LocationLayerGraphic target = (LocationLayerGraphic)LayeredImageGraphicPanel.this.getTarget();
                if (target != null) {
                    Rectangle4d outputBounds = target.getOutputBounds();
                    return new Rectangle4d(0.0, TraceImagePrintable.CELL_MARGIN, outputBounds.getWidth() / (double)gridSize, outputBounds.getHeight() / (double)gridSize);
                }
                return super.getAutoCropRegion();
            }
        };
    }

    private void updateNodeNameCombo() {
        LayeredImageGraphic target = (LayeredImageGraphic)this.getTarget();
        this.nodeNameCombo.removeActionListener(this.nodeNameComboListener);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel();
        String selectedItem = null;
        this.nodeNameCombo.setEnabled(false);
        if (target != null) {
            List<String> nodeNames = target.getPivotNodeNames();
            nodeNames.add(0, null);
            model = new DefaultComboBoxModel<Object>(nodeNames.toArray());
            this.nodeNameCombo.setEnabled(!nodeNames.isEmpty());
            selectedItem = target.getPivotNodeName();
        }
        this.nodeNameCombo.setModel(model);
        this.nodeNameCombo.setSelectedItem(selectedItem);
        this.nodeNameCombo.addActionListener(this.nodeNameComboListener);
        this.updatePointPanels();
    }

    private void updatePointPanels() {
        LayeredImageGraphic target = (LayeredImageGraphic)this.getTarget();
        if (target != null) {
            this.pivotPanel.setValue(target.getPivotPointBeforeOffset());
            this.manualPivotPanel.setValue(target.getManualPivotPoint());
            this.manualPivotPanel.setEnabled(this.nodeNameCombo.getSelectedItem() == null);
        }
    }

    private List<FileFilter> getFileFilters() {
        ArrayList<FileFilter> result = new ArrayList<FileFilter>();
        LayeredImageGraphic target = (LayeredImageGraphic)this.getTarget();
        if (target != null) {
            final String sceneID = target.getAncestorByType(Scene.class).getID();
            final String sceneLocationID = sceneID + "." + target.getAncestorByType(SceneLocation.class).getID();
            result.add(new FileFilter(){

                @Override
                public String getDescription() {
                    return "Images for \"" + sceneID + "\"";
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || LayeredImagePanel.IMAGE_FILTER.accept(f) && f.getName().startsWith(sceneID);
                }
            });
            result.add(new FileFilter(){

                @Override
                public String getDescription() {
                    return "Images for \"" + sceneLocationID + "\"";
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || LayeredImagePanel.IMAGE_FILTER.accept(f) && f.getName().startsWith(sceneLocationID);
                }
            });
        }
        return result;
    }
}

